/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.EnergyNet;
import ic2.api.info.Info;
import ic2.api.item.ElectricItem;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.tile.ExplosionWhitelist;
import ic2.api.util.Keys;
import ic2.core.AdvRecipe;
import ic2.core.AdvShapelessRecipe;
import ic2.core.CreativeTabIC2;
import ic2.core.ExplosionIC2;
import ic2.core.IC2Achievements;
import ic2.core.IC2CraftingHandler;
import ic2.core.IC2DamageSource;
import ic2.core.IC2Loot;
import ic2.core.IC2Potion;
import ic2.core.Ic2Items;
import ic2.core.Platform;
import ic2.core.RecipeGradual;
import ic2.core.TickHandler;
import ic2.core.TickrateTracker;
import ic2.core.WorldData;
import ic2.core.audio.AudioManager;
import ic2.core.block.BlockTextureStitched;
import ic2.core.block.EntityDynamite;
import ic2.core.block.EntityItnt;
import ic2.core.block.EntityNuke;
import ic2.core.block.EntityStickyDynamite;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.WorldGenRubTree;
import ic2.core.block.crop.IC2Crops;
import ic2.core.block.generator.tileentity.TileEntitySemifluidGenerator;
import ic2.core.block.machine.tileentity.TileEntityCanner;
import ic2.core.block.machine.tileentity.TileEntityCentrifuge;
import ic2.core.block.machine.tileentity.TileEntityCompressor;
import ic2.core.block.machine.tileentity.TileEntityExtractor;
import ic2.core.block.machine.tileentity.TileEntityMacerator;
import ic2.core.block.machine.tileentity.TileEntityMatter;
import ic2.core.block.machine.tileentity.TileEntityMetalFormer;
import ic2.core.block.machine.tileentity.TileEntityOreWashing;
import ic2.core.block.machine.tileentity.TileEntityRecycler;
import ic2.core.command.CommandIc2;
import ic2.core.command.CommandTps;
import ic2.core.energy.EnergyNetGlobal;
import ic2.core.init.BlocksItems;
import ic2.core.init.Localization;
import ic2.core.init.MainConfig;
import ic2.core.init.Rezepte;
import ic2.core.item.ElectricItemManager;
import ic2.core.item.EntityBoatCarbon;
import ic2.core.item.EntityBoatElectric;
import ic2.core.item.EntityBoatRubber;
import ic2.core.item.EntityIC2Boat;
import ic2.core.item.GatewayElectricItemManager;
import ic2.core.item.ItemScrapbox;
import ic2.core.item.armor.ItemArmorQuantumSuit;
import ic2.core.item.tfbp.ItemTFBPCultivation;
import ic2.core.item.tfbp.ItemTFBPFlatification;
import ic2.core.item.tool.EntityMiningLaser;
import ic2.core.item.tool.EntityParticle;
import ic2.core.network.NetworkManager;
import ic2.core.util.ConfigUtil;
import ic2.core.util.ItemInfo;
import ic2.core.util.Keyboard;
import ic2.core.util.PriorityExecutor;
import ic2.core.util.SideGateway;
import ic2.core.util.StackUtil;
import ic2.core.util.TextureIndex;
import ic2.core.uu.UuIndex;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.Logger;

@Mod(modid="IC2", name="IndustrialCraft 2", version="2.1.464-experimental", useMetadata=true, certificateFingerprint="de041f9f6187debbc77034a344134053277aa3b0", dependencies="required-after:Forge@[10.12.0.1056,)")
public class IC2
implements IWorldGenerator,
IFuelHandler {
    public static final String VERSION = "2.1.464-experimental";
    private static IC2 instance;
    @SidedProxy(clientSide="ic2.core.PlatformClient", serverSide="ic2.core.Platform")
    public static Platform platform;
    public static SideGateway<NetworkManager> network;
    @SidedProxy(clientSide="ic2.core.util.KeyboardClient", serverSide="ic2.core.util.Keyboard")
    public static Keyboard keyboard;
    @SidedProxy(clientSide="ic2.core.audio.AudioManagerClient", serverSide="ic2.core.audio.AudioManager")
    public static AudioManager audioManager;
    @SidedProxy(clientSide="ic2.core.util.TextureIndexClient", serverSide="ic2.core.util.TextureIndex")
    public static TextureIndex textureIndex;
    public static Logger log;
    public static IC2Achievements achievements;
    public static TickHandler tickHandler;
    public static int cableRenderId;
    public static int fenceRenderId;
    public static int miningPipeRenderId;
    public static int luminatorRenderId;
    public static int cropRenderId;
    public static Random random;
    public static Map<IRecipeInput, Integer> valuableOres;
    public static Fluid fluidUuMatter;
    public static Block blockFluidUuMatter;
    public static Fluid fluidCf;
    public static Block blockFluidCf;
    public static Fluid fluidcoolant;
    public static Block blockFluidcoolant;
    public static boolean suddenlyHoes;
    public static boolean seasonal;
    public static boolean initialized;
    public static CreativeTabIC2 tabIC2;
    public static final String textureDomain = "ic2";
    public static final int setBlockNotify = 1;
    public static final int setBlockUpdate = 2;
    public static final int setBlockNoUpdateFromClient = 4;
    public TickrateTracker tickrateTracker = new TickrateTracker();
    public final ExecutorService threadPool = new PriorityExecutor(Math.max(Runtime.getRuntime().availableProcessors(), 2));

    public IC2() {
        instance = this;
        Info.ic2ModInstance = instance;
    }

    public static IC2 getInstance() {
        return instance;
    }

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        ItemStack tStack;
        long startTime = System.currentTimeMillis();
        log = event.getModLog();
        log.info("Starting pre-init");
        MainConfig.load();
        Localization.init(event.getSourceFile());
        tickHandler = new TickHandler();
        IC2.addValuableOre(Blocks.field_150365_q, 1);
        IC2.addValuableOre(Blocks.field_150352_o, 3);
        IC2.addValuableOre(Blocks.field_150450_ax, 3);
        IC2.addValuableOre(Blocks.field_150369_x, 3);
        IC2.addValuableOre(Blocks.field_150366_p, 4);
        IC2.addValuableOre(Blocks.field_150482_ag, 5);
        IC2.addValuableOre(Blocks.field_150412_bA, 5);
        for (IRecipeInput input : ConfigUtil.asRecipeInputList(MainConfig.get().get("misc/additionalValuableOres"))) {
            IC2.addValuableOre(input, 1);
        }
        audioManager.initialize();
        ElectricItem.manager = new GatewayElectricItemManager();
        ElectricItem.rawManager = new ElectricItemManager();
        ItemInfo itemInfo = new ItemInfo();
        Info.itemEnergy = itemInfo;
        Info.itemFuel = itemInfo;
        Keys.instance = keyboard;
        BlocksItems.initBlocks();
        BlocksItems.initItems();
        Blocks.field_150343_Z.func_149752_b(60.0f);
        Blocks.field_150381_bn.func_149752_b(60.0f);
        Blocks.field_150477_bB.func_149752_b(60.0f);
        Blocks.field_150467_bQ.func_149752_b(60.0f);
        Blocks.field_150355_j.func_149752_b(30.0f);
        Blocks.field_150358_i.func_149752_b(30.0f);
        Blocks.field_150353_l.func_149752_b(30.0f);
        ExplosionWhitelist.addWhitelistedBlock(Blocks.field_150357_h);
        FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
        if (Ic2Items.rubberWood != null) {
            furnaceRecipes.func_151394_a(Ic2Items.rubberWood, new ItemStack(Blocks.field_150364_r, 1, 3), 0.1f);
        }
        if (Ic2Items.tinOre != null) {
            furnaceRecipes.func_151394_a(Ic2Items.tinOre, Ic2Items.tinIngot, 0.5f);
        }
        if (Ic2Items.copperOre != null) {
            furnaceRecipes.func_151394_a(Ic2Items.copperOre, Ic2Items.copperIngot, 0.5f);
        }
        if (Ic2Items.leadOre != null) {
            furnaceRecipes.func_151394_a(Ic2Items.leadOre, Ic2Items.leadIngot, 0.5f);
        }
        furnaceRecipes.func_151394_a(Ic2Items.ironDust, new ItemStack(Items.field_151042_j, 1), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.goldDust, new ItemStack(Items.field_151043_k, 1), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.tinDust, Ic2Items.tinIngot.func_77946_l(), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.copperDust, Ic2Items.copperIngot.func_77946_l(), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.leadDust, Ic2Items.leadIngot.func_77946_l(), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.silverDust, Ic2Items.silverIngot.func_77946_l(), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.hydratedCoalDust, Ic2Items.coalDust.func_77946_l(), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.bronzeDust, Ic2Items.bronzeIngot.func_77946_l(), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.resin, Ic2Items.rubber.func_77946_l(), 0.3f);
        furnaceRecipes.func_151396_a(Ic2Items.mugCoffee.func_77973_b(), new ItemStack(Ic2Items.mugCoffee.func_77973_b(), 1, 1), 0.1f);
        furnaceRecipes.func_151394_a(Ic2Items.crushedIronOre, new ItemStack(Items.field_151042_j, 1), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.crushedGoldOre, new ItemStack(Items.field_151043_k, 1), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.crushedCopperOre, Ic2Items.copperIngot.func_77946_l(), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.crushedTinOre, Ic2Items.tinIngot.func_77946_l(), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.crushedLeadOre, Ic2Items.leadIngot.func_77946_l(), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.crushedSilverOre, Ic2Items.silverIngot.func_77946_l(), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.purifiedCrushedIronOre, new ItemStack(Items.field_151042_j, 1), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.purifiedCrushedGoldOre, new ItemStack(Items.field_151043_k, 1), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.purifiedCrushedCopperOre, Ic2Items.copperIngot.func_77946_l(), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.purifiedCrushedTinOre, Ic2Items.tinIngot.func_77946_l(), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.purifiedCrushedLeadOre, Ic2Items.leadIngot.func_77946_l(), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.purifiedCrushedSilverOre, Ic2Items.silverIngot.func_77946_l(), 0.0f);
        furnaceRecipes.func_151394_a(Ic2Items.rawcrystalmemory, Ic2Items.crystalmemory.func_77946_l(), 0.0f);
        ItemScrapbox.init();
        ItemTFBPCultivation.init();
        ItemTFBPFlatification.init();
        TileEntityCanner.init();
        TileEntityCompressor.init();
        TileEntityExtractor.init();
        TileEntityMacerator.init();
        TileEntityRecycler.init();
        TileEntityCentrifuge.init();
        TileEntityMatter.init();
        TileEntityMetalFormer.init();
        TileEntitySemifluidGenerator.init();
        TileEntityOreWashing.init();
        EntityIC2Boat.init();
        StackUtil.getBlock(Ic2Items.reinforcedStone).setHarvestLevel("pickaxe", 2);
        StackUtil.getBlock(Ic2Items.reinforcedDoorBlock).setHarvestLevel("pickaxe", 2);
        StackUtil.getBlock(Ic2Items.insulatedCopperCableBlock).setHarvestLevel("axe", 0);
        StackUtil.getBlock(Ic2Items.constructionFoamWall).setHarvestLevel("pickaxe", 1);
        if (Ic2Items.copperOre != null) {
            StackUtil.getBlock(Ic2Items.copperOre).setHarvestLevel("pickaxe", 1);
        }
        if (Ic2Items.tinOre != null) {
            StackUtil.getBlock(Ic2Items.tinOre).setHarvestLevel("pickaxe", 1);
        }
        if (Ic2Items.uraniumOre != null) {
            StackUtil.getBlock(Ic2Items.uraniumOre).setHarvestLevel("pickaxe", 2);
        }
        if (Ic2Items.leadOre != null) {
            StackUtil.getBlock(Ic2Items.leadOre).setHarvestLevel("pickaxe", 1);
        }
        if (Ic2Items.rubberWood != null) {
            StackUtil.getBlock(Ic2Items.rubberWood).setHarvestLevel("axe", 0);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        RecipeSorter.register((String)"ic2:shaped", AdvRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shapeless");
        RecipeSorter.register((String)"ic2:shapeless", AdvShapelessRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:ic2:shaped");
        RecipeSorter.register((String)"ic2:gradual", RecipeGradual.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:ic2:shapeless");
        for (String oreName : OreDictionary.getOreNames()) {
            for (ItemStack ore : OreDictionary.getOres((String)oreName)) {
                this.registerOre(new OreDictionary.OreRegisterEvent(oreName, ore));
            }
        }
        assert (Ic2Items.bronzeIngot != null);
        assert (Ic2Items.copperIngot != null);
        assert (Ic2Items.tinIngot != null);
        assert (Ic2Items.leadIngot != null);
        assert (Ic2Items.rubber != null);
        if (Ic2Items.copperOre != null) {
            OreDictionary.registerOre((String)"oreCopper", (ItemStack)Ic2Items.copperOre.func_77946_l());
        }
        if (Ic2Items.tinOre != null) {
            OreDictionary.registerOre((String)"oreTin", (ItemStack)Ic2Items.tinOre.func_77946_l());
        }
        if (Ic2Items.uraniumOre != null) {
            OreDictionary.registerOre((String)"oreUranium", (ItemStack)Ic2Items.uraniumOre.func_77946_l());
        }
        if (Ic2Items.leadOre != null) {
            OreDictionary.registerOre((String)"oreLead", (ItemStack)Ic2Items.leadOre.func_77946_l());
        }
        if (Ic2Items.rubberLeaves != null) {
            tStack = Ic2Items.rubberLeaves.func_77946_l();
            tStack.func_77964_b(Short.MAX_VALUE);
            OreDictionary.registerOre((String)"treeLeaves", (ItemStack)tStack);
        }
        if (Ic2Items.rubberSapling != null) {
            tStack = Ic2Items.rubberSapling.func_77946_l();
            tStack.func_77964_b(Short.MAX_VALUE);
            OreDictionary.registerOre((String)"treeSapling", (ItemStack)tStack);
        }
        if (Ic2Items.rubberWood != null) {
            tStack = Ic2Items.rubberWood.func_77946_l();
            tStack.func_77964_b(Short.MAX_VALUE);
            OreDictionary.registerOre((String)"woodRubber", (ItemStack)tStack);
        }
        OreDictionary.registerOre((String)"dustStone", (ItemStack)Ic2Items.stoneDust.func_77946_l());
        OreDictionary.registerOre((String)"dustBronze", (ItemStack)Ic2Items.bronzeDust.func_77946_l());
        OreDictionary.registerOre((String)"dustClay", (ItemStack)Ic2Items.clayDust.func_77946_l());
        OreDictionary.registerOre((String)"dustCoal", (ItemStack)Ic2Items.coalDust.func_77946_l());
        OreDictionary.registerOre((String)"dustCopper", (ItemStack)Ic2Items.copperDust.func_77946_l());
        OreDictionary.registerOre((String)"dustGold", (ItemStack)Ic2Items.goldDust.func_77946_l());
        OreDictionary.registerOre((String)"dustIron", (ItemStack)Ic2Items.ironDust.func_77946_l());
        OreDictionary.registerOre((String)"dustSilver", (ItemStack)Ic2Items.silverDust.func_77946_l());
        OreDictionary.registerOre((String)"dustTin", (ItemStack)Ic2Items.tinDust.func_77946_l());
        OreDictionary.registerOre((String)"dustLead", (ItemStack)Ic2Items.leadDust.func_77946_l());
        OreDictionary.registerOre((String)"dustObsidian", (ItemStack)Ic2Items.obsidianDust.func_77946_l());
        OreDictionary.registerOre((String)"dustLapis", (ItemStack)Ic2Items.lapiDust.func_77946_l());
        OreDictionary.registerOre((String)"dustSulfur", (ItemStack)Ic2Items.sulfurDust.func_77946_l());
        OreDictionary.registerOre((String)"dustLithium", (ItemStack)Ic2Items.lithiumDust.func_77946_l());
        OreDictionary.registerOre((String)"dustDiamond", (ItemStack)Ic2Items.diamondDust.func_77946_l());
        OreDictionary.registerOre((String)"dustSiliconDioxide", (ItemStack)Ic2Items.silicondioxideDust.func_77946_l());
        OreDictionary.registerOre((String)"dustHydratedCoal", (ItemStack)Ic2Items.hydratedCoalDust.func_77946_l());
        OreDictionary.registerOre((String)"dustTinyCopper", (ItemStack)Ic2Items.smallCopperDust.func_77946_l());
        OreDictionary.registerOre((String)"dustTinyGold", (ItemStack)Ic2Items.smallGoldDust.func_77946_l());
        OreDictionary.registerOre((String)"dustTinyIron", (ItemStack)Ic2Items.smallIronDust.func_77946_l());
        OreDictionary.registerOre((String)"dustTinySilver", (ItemStack)Ic2Items.smallSilverDust.func_77946_l());
        OreDictionary.registerOre((String)"dustTinyTin", (ItemStack)Ic2Items.smallTinDust.func_77946_l());
        OreDictionary.registerOre((String)"dustTinyLead", (ItemStack)Ic2Items.smallLeadDust.func_77946_l());
        OreDictionary.registerOre((String)"dustTinySulfur", (ItemStack)Ic2Items.smallSulfurDust.func_77946_l());
        OreDictionary.registerOre((String)"dustTinyLithium", (ItemStack)Ic2Items.smallLithiumDust.func_77946_l());
        OreDictionary.registerOre((String)"itemRubber", (ItemStack)Ic2Items.rubber.func_77946_l());
        OreDictionary.registerOre((String)"ingotBronze", (ItemStack)Ic2Items.bronzeIngot.func_77946_l());
        OreDictionary.registerOre((String)"ingotCopper", (ItemStack)Ic2Items.copperIngot.func_77946_l());
        OreDictionary.registerOre((String)"ingotRefinedIron", (ItemStack)new ItemStack(Items.field_151042_j, 1));
        OreDictionary.registerOre((String)"ingotLead", (ItemStack)Ic2Items.leadIngot.func_77946_l());
        OreDictionary.registerOre((String)"ingotTin", (ItemStack)Ic2Items.tinIngot.func_77946_l());
        OreDictionary.registerOre((String)"ingotSilver", (ItemStack)Ic2Items.silverIngot.func_77946_l());
        OreDictionary.registerOre((String)"plateIron", (ItemStack)Ic2Items.plateiron.func_77946_l());
        OreDictionary.registerOre((String)"plateGold", (ItemStack)Ic2Items.plategold.func_77946_l());
        OreDictionary.registerOre((String)"plateCopper", (ItemStack)Ic2Items.platecopper.func_77946_l());
        OreDictionary.registerOre((String)"plateTin", (ItemStack)Ic2Items.platetin.func_77946_l());
        OreDictionary.registerOre((String)"plateLead", (ItemStack)Ic2Items.platelead.func_77946_l());
        OreDictionary.registerOre((String)"plateLapis", (ItemStack)Ic2Items.platelapi.func_77946_l());
        OreDictionary.registerOre((String)"plateObsidian", (ItemStack)Ic2Items.plateobsidian.func_77946_l());
        OreDictionary.registerOre((String)"plateBronze", (ItemStack)Ic2Items.platebronze.func_77946_l());
        OreDictionary.registerOre((String)"plateDenseIron", (ItemStack)Ic2Items.denseplateiron.func_77946_l());
        OreDictionary.registerOre((String)"plateDenseGold", (ItemStack)Ic2Items.denseplategold.func_77946_l());
        OreDictionary.registerOre((String)"plateDenseCopper", (ItemStack)Ic2Items.denseplatecopper.func_77946_l());
        OreDictionary.registerOre((String)"plateDenseTin", (ItemStack)Ic2Items.denseplatetin.func_77946_l());
        OreDictionary.registerOre((String)"plateDenseLead", (ItemStack)Ic2Items.denseplatelead.func_77946_l());
        OreDictionary.registerOre((String)"plateDenseLapis", (ItemStack)Ic2Items.denseplatelapi.func_77946_l());
        OreDictionary.registerOre((String)"plateDenseObsidian", (ItemStack)Ic2Items.denseplateobsidian.func_77946_l());
        OreDictionary.registerOre((String)"plateDenseBronze", (ItemStack)Ic2Items.denseplatebronze.func_77946_l());
        OreDictionary.registerOre((String)"crushedIron", (ItemStack)Ic2Items.crushedIronOre.func_77946_l());
        OreDictionary.registerOre((String)"crushedGold", (ItemStack)Ic2Items.crushedGoldOre.func_77946_l());
        OreDictionary.registerOre((String)"crushedSilver", (ItemStack)Ic2Items.crushedSilverOre.func_77946_l());
        OreDictionary.registerOre((String)"crushedLead", (ItemStack)Ic2Items.crushedLeadOre.func_77946_l());
        OreDictionary.registerOre((String)"crushedCopper", (ItemStack)Ic2Items.crushedCopperOre.func_77946_l());
        OreDictionary.registerOre((String)"crushedTin", (ItemStack)Ic2Items.crushedTinOre.func_77946_l());
        OreDictionary.registerOre((String)"crushedUranium", (ItemStack)Ic2Items.crushedUraniumOre.func_77946_l());
        OreDictionary.registerOre((String)"crushedPurifiedIron", (ItemStack)Ic2Items.purifiedCrushedIronOre.func_77946_l());
        OreDictionary.registerOre((String)"crushedPurifiedGold", (ItemStack)Ic2Items.purifiedCrushedGoldOre.func_77946_l());
        OreDictionary.registerOre((String)"crushedPurifiedSilver", (ItemStack)Ic2Items.purifiedCrushedSilverOre.func_77946_l());
        OreDictionary.registerOre((String)"crushedPurifiedLead", (ItemStack)Ic2Items.purifiedCrushedLeadOre.func_77946_l());
        OreDictionary.registerOre((String)"crushedPurifiedCopper", (ItemStack)Ic2Items.purifiedCrushedCopperOre.func_77946_l());
        OreDictionary.registerOre((String)"crushedPurifiedTin", (ItemStack)Ic2Items.purifiedCrushedTinOre.func_77946_l());
        OreDictionary.registerOre((String)"crushedPurifiedUranium", (ItemStack)Ic2Items.purifiedCrushedUraniumOre.func_77946_l());
        OreDictionary.registerOre((String)"blockBronze", (ItemStack)Ic2Items.bronzeBlock.func_77946_l());
        OreDictionary.registerOre((String)"blockCopper", (ItemStack)Ic2Items.copperBlock.func_77946_l());
        OreDictionary.registerOre((String)"blockTin", (ItemStack)Ic2Items.tinBlock.func_77946_l());
        OreDictionary.registerOre((String)"blockUranium", (ItemStack)Ic2Items.uraniumBlock.func_77946_l());
        OreDictionary.registerOre((String)"blockLead", (ItemStack)Ic2Items.leadBlock.func_77946_l());
        OreDictionary.registerOre((String)"circuitBasic", (ItemStack)Ic2Items.electronicCircuit.func_77946_l());
        OreDictionary.registerOre((String)"circuitAdvanced", (ItemStack)Ic2Items.advancedCircuit.func_77946_l());
        OreDictionary.registerOre((String)"gemDiamond", (ItemStack)Ic2Items.industrialDiamond.func_77946_l());
        OreDictionary.registerOre((String)"gemDiamond", (Item)Items.field_151045_i);
        OreDictionary.registerOre((String)"craftingToolForgeHammer", (ItemStack)new ItemStack(Ic2Items.ForgeHammer.func_77973_b(), 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"craftingToolWireCutter", (ItemStack)new ItemStack(Ic2Items.cutter.func_77973_b(), 1, Short.MAX_VALUE));
        EnergyNet.instance = EnergyNetGlobal.initialize();
        IC2Crops.init();
        Info.DMG_ELECTRIC = IC2DamageSource.electricity;
        Info.DMG_NUKE_EXPLOSION = IC2DamageSource.nuke;
        Info.DMG_RADIATION = IC2DamageSource.radiation;
        IC2Potion.init();
        new IC2Loot();
        achievements = new IC2Achievements();
        EntityRegistry.registerModEntity(EntityMiningLaser.class, (String)"MiningLaser", (int)0, (Object)this, (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityDynamite.class, (String)"Dynamite", (int)1, (Object)this, (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityStickyDynamite.class, (String)"StickyDynamite", (int)2, (Object)this, (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityItnt.class, (String)"Itnt", (int)3, (Object)this, (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityNuke.class, (String)"Nuke", (int)4, (Object)this, (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityBoatCarbon.class, (String)"BoatCarbon", (int)5, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityBoatRubber.class, (String)"BoatRubber", (int)6, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityBoatElectric.class, (String)"BoatElectric", (int)7, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityParticle.class, (String)"Particle", (int)8, (Object)this, (int)160, (int)1, (boolean)true);
        int d = Integer.parseInt(new SimpleDateFormat("Mdd").format(new Date()));
        suddenlyHoes = (double)d > Math.cbrt(6.4E7) && (double)d < Math.cbrt(6.5939264E7);
        seasonal = (double)d > Math.cbrt(1.089547389E9) && (double)d < Math.cbrt(1.338273208E9);
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)0);
        GameRegistry.registerFuelHandler((IFuelHandler)this);
        new IC2CraftingHandler();
        FluidContainerRegistry.registerFluidContainer((Fluid)FluidRegistry.WATER, (ItemStack)Ic2Items.waterCell.func_77946_l(), (ItemStack)Ic2Items.cell.func_77946_l());
        FluidContainerRegistry.registerFluidContainer((Fluid)FluidRegistry.LAVA, (ItemStack)Ic2Items.lavaCell.func_77946_l(), (ItemStack)Ic2Items.cell.func_77946_l());
        FluidContainerRegistry.registerFluidContainer((Fluid)fluidcoolant, (ItemStack)Ic2Items.reactorCoolantSimple.func_77946_l(), (ItemStack)Ic2Items.cell.func_77946_l());
        FluidContainerRegistry.registerFluidContainer((Fluid)fluidUuMatter, (ItemStack)Ic2Items.UuMatterCell.func_77946_l(), (ItemStack)Ic2Items.cell.func_77946_l());
        FluidContainerRegistry.registerFluidContainer((Fluid)fluidCf, (ItemStack)Ic2Items.CFCell.func_77946_l(), (ItemStack)Ic2Items.cell.func_77946_l());
        initialized = true;
        log.info("Finished pre-init after " + (System.currentTimeMillis() - startTime) + " ms");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        long startTime = System.currentTimeMillis();
        log.info("Starting init");
        Rezepte.registerCraftingRecipes();
        log.info("Finished init after " + (System.currentTimeMillis() - startTime) + " ms");
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        long startTime = System.currentTimeMillis();
        log.info("Starting post-init");
        if (!initialized) {
            platform.displayError("IndustrialCraft 2 has failed to initialize properly.");
        }
        if (IC2.loadSubModule("bcIntegration")) {
            log.info("BuildCraft integration module loaded");
        }
        ArrayList<IRecipeInput> purgedRecipes = new ArrayList<IRecipeInput>();
        purgedRecipes.addAll(ConfigUtil.asRecipeInputList(MainConfig.get().get("recipes/purge")));
        if (MainConfig.get().getBool("balance/disableEnderChest")) {
            purgedRecipes.add(new RecipeInputItemStack(new ItemStack(Blocks.field_150477_bB)));
        }
        Iterator it = CraftingManager.func_77594_a().func_77592_b().iterator();
        block0: while (it.hasNext()) {
            IRecipe recipe = (IRecipe)it.next();
            ItemStack itemStack = recipe.func_77571_b();
            if (itemStack == null) continue;
            for (IRecipeInput input : purgedRecipes) {
                if (!input.matches(itemStack)) continue;
                it.remove();
                continue block0;
            }
        }
        Rezepte.loadRecipes(MainConfig.get().getSub("recipes/additional/shaped"), true);
        Rezepte.loadRecipes(MainConfig.get().getSub("recipes/additional/shapeless"), false);
        if (MainConfig.get().getBool("recipes/smeltToIc2Items")) {
            Map smeltingMap = FurnaceRecipes.func_77602_a().func_77599_b();
            block2: for (Map.Entry entry : smeltingMap.entrySet()) {
                int oreId = OreDictionary.getOreID((ItemStack)((ItemStack)entry.getValue()));
                if (oreId == -1) continue;
                for (ItemStack ore : OreDictionary.getOres((Integer)oreId)) {
                    if (ore.func_77973_b() == null || !Item.field_150901_e.func_148750_c((Object)ore.func_77973_b()).startsWith("IC2:")) continue;
                    entry.setValue(StackUtil.copyWithSize(ore, ((ItemStack)entry.getValue()).field_77994_a));
                    continue block2;
                }
            }
        }
        GameRegistry.registerTileEntity(TileEntityBlock.class, (String)"Empty Management TileEntity");
        UuIndex.instance.init();
        UuIndex.instance.refresh();
        platform.onPostInit();
        platform.registerRenderers();
        log.info("Finished post-init after " + (System.currentTimeMillis() - startTime) + " ms");
    }

    private static boolean loadSubModule(String name) {
        log.info("Loading IC2 submodule: " + name);
        try {
            Class<?> subModuleClass = IC2.class.getClassLoader().loadClass("ic2." + name + ".SubModule");
            return (Boolean)subModuleClass.getMethod("init", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            log.info("Submodule " + name + " not loaded");
            return false;
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandIc2());
        event.registerServerCommand((ICommand)new CommandTps());
    }

    public int getBurnTime(ItemStack stack) {
        if (stack != null) {
            if (Ic2Items.rubberSapling != null && stack.func_77969_a(Ic2Items.rubberSapling)) {
                return 80;
            }
            if (stack.func_77973_b() == Items.field_151120_aE) {
                return 50;
            }
            if (StackUtil.equals(Blocks.field_150434_aF, stack)) {
                return 50;
            }
            if (stack.func_77969_a(Ic2Items.scrap)) {
                return 350;
            }
            if (stack.func_77969_a(Ic2Items.scrapBox)) {
                return 3150;
            }
            if (stack.func_77969_a(Ic2Items.lavaCell)) {
                return TileEntityFurnace.func_145952_a((ItemStack)new ItemStack(Items.field_151129_at));
            }
        }
        return 0;
    }

    public void generate(Random random1, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int z;
        int y;
        int x;
        int n;
        int count;
        int baseCount;
        BiomeGenBase biomegenbase;
        if (MainConfig.get().getBool("worldgen/rubberTree") && (biomegenbase = world.func_72959_q().func_76935_a(chunkX * 16 + 16, chunkZ * 16 + 16)) != null && biomegenbase.field_76791_y != null) {
            int rubbertrees = 0;
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                rubbertrees += random1.nextInt(10) + 5;
            }
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                rubbertrees += random1.nextInt(5) + 1;
            }
            if (random1.nextInt(100) + 1 <= rubbertrees * 2) {
                new WorldGenRubTree().func_76484_a(world, random1, chunkX * 16 + random1.nextInt(16), rubbertrees, chunkZ * 16 + random1.nextInt(16));
            }
        }
        int baseHeight = IC2.getSeaLevel(world) + 1;
        int baseScale = Math.round((float)baseHeight * MainConfig.get().getFloat("worldgen/oreDensityFactor"));
        if (MainConfig.get().getBool("worldgen/copperOre") && Ic2Items.copperOre != null) {
            baseCount = 15 * baseScale / 64;
            count = (int)Math.round(random1.nextGaussian() * Math.sqrt(baseCount) + (double)baseCount);
            for (n = 0; n < count; ++n) {
                x = chunkX * 16 + random1.nextInt(16);
                y = random1.nextInt(40 * baseHeight / 64) + random1.nextInt(20 * baseHeight / 64) + 10 * baseHeight / 64;
                z = chunkZ * 16 + random1.nextInt(16);
                new WorldGenMinable(StackUtil.getBlock(Ic2Items.copperOre), Ic2Items.copperOre.func_77960_j(), 10, Blocks.field_150348_b).func_76484_a(world, random1, x, y, z);
            }
        }
        if (MainConfig.get().getBool("worldgen/tinOre") && Ic2Items.tinOre != null) {
            baseCount = 25 * baseScale / 64;
            count = (int)Math.round(random1.nextGaussian() * Math.sqrt(baseCount) + (double)baseCount);
            for (n = 0; n < count; ++n) {
                x = chunkX * 16 + random1.nextInt(16);
                y = random1.nextInt(40 * baseHeight / 64);
                z = chunkZ * 16 + random1.nextInt(16);
                new WorldGenMinable(StackUtil.getBlock(Ic2Items.tinOre), Ic2Items.tinOre.func_77960_j(), 6, Blocks.field_150348_b).func_76484_a(world, random1, x, y, z);
            }
        }
        if (MainConfig.get().getBool("worldgen/uraniumOre") && Ic2Items.uraniumOre != null) {
            baseCount = 20 * baseScale / 64;
            count = (int)Math.round(random1.nextGaussian() * Math.sqrt(baseCount) + (double)baseCount);
            for (n = 0; n < count; ++n) {
                x = chunkX * 16 + random1.nextInt(16);
                y = random1.nextInt(64 * baseHeight / 64);
                z = chunkZ * 16 + random1.nextInt(16);
                new WorldGenMinable(StackUtil.getBlock(Ic2Items.uraniumOre), Ic2Items.uraniumOre.func_77960_j(), 3, Blocks.field_150348_b).func_76484_a(world, random1, x, y, z);
            }
        }
        if (MainConfig.get().getBool("worldgen/leadOre") && Ic2Items.leadOre != null) {
            baseCount = 6 * baseScale / 64;
            count = (int)Math.round(random1.nextGaussian() * Math.sqrt(baseCount) + (double)baseCount);
            for (n = 0; n < count; ++n) {
                x = chunkX * 16 + random1.nextInt(16);
                y = random1.nextInt(64 * baseHeight / 64);
                z = chunkZ * 16 + random1.nextInt(16);
                new WorldGenMinable(StackUtil.getBlock(Ic2Items.leadOre), Ic2Items.leadOre.func_77960_j(), 4, Blocks.field_150348_b).func_76484_a(world, random1, x, y, z);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (platform.isSimulating()) {
            ItemArmorQuantumSuit.removePlayerReferences(event.player);
            keyboard.removePlayerReferences(event.player);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        textureIndex.reset();
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        WorldData.onWorldUnload(event.world);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitchPost(TextureStitchEvent.Post event) {
        BlockTextureStitched.onPostStitch();
    }

    @SubscribeEvent
    public void onChunkWatchEvent(ChunkWatchEvent.Watch event) {
        Chunk chunk = event.player.field_70170_p.func_72964_e(event.chunk.field_77276_a, event.chunk.field_77275_b);
        for (TileEntity tileEntity : chunk.field_150816_i.values()) {
            network.get().sendInitialData(tileEntity, event.player);
        }
    }

    public static void explodeMachineAt(World world, int x, int y, int z) {
        ExplosionIC2 explosion = new ExplosionIC2(world, null, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, 2.5f, 0.75f);
        explosion.destroy(x, y, z);
        explosion.doExplosion();
    }

    public static int getSeaLevel(World world) {
        return world.field_73011_w.func_76557_i();
    }

    public static int getWorldHeight(World world) {
        return world.func_72800_K();
    }

    public static void addValuableOre(Block block, int value) {
        IC2.addValuableOre(new RecipeInputItemStack(new ItemStack(block)), value);
    }

    public static void addValuableOre(IRecipeInput input, int value) {
        if (input == null) {
            throw new NullPointerException("input is null");
        }
        valuableOres.put(input, value);
    }

    @SubscribeEvent
    public void registerOre(OreDictionary.OreRegisterEvent event) {
        String oreClass = event.Name;
        ItemStack ore = event.Ore;
        if (!(ore.func_77973_b() instanceof ItemBlock)) {
            return;
        }
        if (oreClass.equals("oreCopper")) {
            IC2.addValuableOre(new RecipeInputItemStack(ore), 2);
        } else if (oreClass.equals("oreLead")) {
            IC2.addValuableOre(new RecipeInputItemStack(ore), 2);
        } else if (oreClass.equals("oreGemRuby") || oreClass.equals("oreGemGreenSapphire") || oreClass.equals("oreGemSapphire") || oreClass.equals("oreRuby") || oreClass.equals("oreGreenSapphire") || oreClass.equals("oreSapphire")) {
            IC2.addValuableOre(new RecipeInputItemStack(ore), 4);
        } else if (oreClass.equals("oreSilver")) {
            IC2.addValuableOre(new RecipeInputItemStack(ore), 3);
        } else if (oreClass.equals("oreTin")) {
            IC2.addValuableOre(new RecipeInputItemStack(ore), 2);
        } else if (oreClass.equals("oreUranium")) {
            IC2.addValuableOre(new RecipeInputItemStack(ore), 4);
        } else if (oreClass.equals("oreTungsten")) {
            IC2.addValuableOre(new RecipeInputItemStack(ore), 5);
        } else if (oreClass.startsWith("ore")) {
            IC2.addValuableOre(new RecipeInputItemStack(ore), 1);
        }
    }

    @SubscribeEvent
    public void onLivingSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (seasonal && (event.entityLiving instanceof EntityZombie || event.entityLiving instanceof EntitySkeleton) && event.entityLiving.field_70170_p.field_73012_v.nextFloat() < 0.1f) {
            EntityLiving entity = (EntityLiving)event.entityLiving;
            for (int i = 0; i <= 4; ++i) {
                entity.func_96120_a(i, Float.NEGATIVE_INFINITY);
            }
            if (entity instanceof EntityZombie) {
                entity.func_70062_b(0, Ic2Items.nanoSaber.func_77946_l());
            }
            if (event.entityLiving.field_70170_p.field_73012_v.nextFloat() < 0.1f) {
                entity.func_70062_b(1, Ic2Items.quantumHelmet.func_77946_l());
                entity.func_70062_b(2, Ic2Items.quantumBodyarmor.func_77946_l());
                entity.func_70062_b(3, Ic2Items.quantumLeggings.func_77946_l());
                entity.func_70062_b(4, Ic2Items.quantumBoots.func_77946_l());
            } else {
                entity.func_70062_b(1, Ic2Items.nanoHelmet.func_77946_l());
                entity.func_70062_b(2, Ic2Items.nanoBodyarmor.func_77946_l());
                entity.func_70062_b(3, Ic2Items.nanoLeggings.func_77946_l());
                entity.func_70062_b(4, Ic2Items.nanoBoots.func_77946_l());
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Post event) {
        if (event.map.func_130086_a() == 0) {
            fluidUuMatter.setIcons(blockFluidUuMatter.func_149733_h(1), blockFluidUuMatter.func_149733_h(2));
            fluidCf.setIcons(blockFluidCf.func_149733_h(1), blockFluidCf.func_149733_h(2));
            fluidcoolant.setIcons(blockFluidcoolant.func_149733_h(1), blockFluidcoolant.func_149733_h(2));
        }
    }

    static {
        try {
            new ChunkCoordinates(1, 2, 3).func_71569_e(2, 3, 4);
        }
        catch (Throwable t) {
            throw new Error("IC2 is incompatible with this environment, use the normal IC2 version, not the dev one.", t);
        }
        instance = null;
        network = new SideGateway("ic2.core.network.NetworkManager", "ic2.core.network.NetworkManagerClient");
        random = new Random();
        valuableOres = new HashMap<IRecipeInput, Integer>();
        suddenlyHoes = false;
        seasonal = false;
        initialized = false;
        tabIC2 = new CreativeTabIC2();
    }
}

