/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.generator.tileentity.TileEntityNuclearReactorElectric;
import ic2.core.block.generator.tileentity.TileEntityReactorChamberElectric;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockIC2;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockReactorChamber
extends BlockMultiID {
    public BlockReactorChamber(InternalName internalName1) {
        super(internalName1, Material.field_151573_f, ItemBlockIC2.class);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149777_j);
        Ic2Items.reactorChamber = new ItemStack((Block)this, 1, 0);
        GameRegistry.registerTileEntity(TileEntityReactorChamberElectric.class, (String)"Reactor Chamber");
    }

    @Override
    public String getTextureFolder(int id) {
        return "generator";
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        if (!this.func_149742_c(world, x, y, z)) {
            world.func_147468_f(x, y, z);
            this.func_149642_a(world, x, y, z, Ic2Items.reactorChamber.func_77946_l());
        }
    }

    public boolean func_149742_c(World world, int i, int j, int k) {
        int count = 0;
        if (this.isReactorAt(world, i + 1, j, k)) {
            ++count;
        }
        if (this.isReactorAt(world, i - 1, j, k)) {
            ++count;
        }
        if (this.isReactorAt(world, i, j + 1, k)) {
            ++count;
        }
        if (this.isReactorAt(world, i, j - 1, k)) {
            ++count;
        }
        if (this.isReactorAt(world, i, j, k + 1)) {
            ++count;
        }
        if (this.isReactorAt(world, i, j, k - 1)) {
            ++count;
        }
        return count == 1;
    }

    public void func_149734_b(World world, int i, int j, int k, Random random) {
        int n;
        TileEntityNuclearReactorElectric reactor = this.getReactorEntity(world, i, j, k);
        if (reactor == null) {
            this.func_149695_a(world, i, j, k, this);
            return;
        }
        int puffs = reactor.heat / 1000;
        if (puffs <= 0) {
            return;
        }
        puffs = world.field_73012_v.nextInt(puffs);
        for (n = 0; n < puffs; ++n) {
            world.func_72869_a("smoke", (double)((float)i + random.nextFloat()), (double)((float)j + 0.95f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
        }
        puffs -= world.field_73012_v.nextInt(4) + 3;
        for (n = 0; n < puffs; ++n) {
            world.func_72869_a("flame", (double)((float)i + random.nextFloat()), (double)((float)j + 1.0f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    public boolean isReactorAt(World world, int x, int y, int z) {
        return world.func_147438_o(x, y, z) instanceof TileEntityNuclearReactorElectric && StackUtil.equals(world.func_147439_a(x, y, z), Ic2Items.nuclearReactor) && world.func_72805_g(x, y, z) == Ic2Items.nuclearReactor.func_77960_j();
    }

    public TileEntityNuclearReactorElectric getReactorEntity(World world, int i, int j, int k) {
        if (this.isReactorAt(world, i + 1, j, k)) {
            return (TileEntityNuclearReactorElectric)world.func_147438_o(i + 1, j, k);
        }
        if (this.isReactorAt(world, i - 1, j, k)) {
            return (TileEntityNuclearReactorElectric)world.func_147438_o(i - 1, j, k);
        }
        if (this.isReactorAt(world, i, j + 1, k)) {
            return (TileEntityNuclearReactorElectric)world.func_147438_o(i, j + 1, k);
        }
        if (this.isReactorAt(world, i, j - 1, k)) {
            return (TileEntityNuclearReactorElectric)world.func_147438_o(i, j - 1, k);
        }
        if (this.isReactorAt(world, i, j, k + 1)) {
            return (TileEntityNuclearReactorElectric)world.func_147438_o(i, j, k + 1);
        }
        if (this.isReactorAt(world, i, j, k - 1)) {
            return (TileEntityNuclearReactorElectric)world.func_147438_o(i, j, k - 1);
        }
        this.func_149695_a(world, i, j, k, world.func_147439_a(i, j, k));
        return null;
    }

    @Override
    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float a, float b, float c) {
        if (entityplayer.func_70093_af()) {
            return false;
        }
        TileEntityNuclearReactorElectric reactor = this.getReactorEntity(world, i, j, k);
        if (reactor == null) {
            this.func_149695_a(world, i, j, k, this);
            return false;
        }
        if (!IC2.platform.isSimulating()) {
            return true;
        }
        return IC2.platform.launchGui(entityplayer, reactor);
    }

    @Override
    public TileEntity createTileEntity(World world, int meta) {
        try {
            return new TileEntityReactorChamberElectric();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(Ic2Items.machine.func_77946_l());
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.uncommon;
    }
}

