/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.tile.IWrenchable;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.Ic2Items;
import ic2.core.block.wiring.TileEntityCable;
import ic2.core.util.StackUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLuminator
extends TileEntity
implements IEnergySink,
IWrenchable {
    public double energy = 0.0;
    public boolean lswitch = true;
    public int ticker = -1;
    public boolean ignoreBlockStay = false;
    public int maxInput = 32;
    public boolean addedToEnergyNet = false;
    private boolean loaded = false;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.energy = nbttagcompound.func_74769_h("energy");
        }
        catch (Exception e) {
            this.energy = nbttagcompound.func_74765_d("energy");
        }
        this.lswitch = nbttagcompound.func_74767_n("lswitch");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
        nbttagcompound.func_74757_a("lswitch", this.lswitch);
    }

    public void func_145829_t() {
        super.func_145829_t();
        IC2.tickHandler.addSingleTickCallback(this.field_145850_b, new ITickCallback(){

            @Override
            public void tickCallback(World world) {
                if (TileEntityLuminator.this.func_145837_r() || !world.func_72899_e(TileEntityLuminator.this.field_145851_c, TileEntityLuminator.this.field_145848_d, TileEntityLuminator.this.field_145849_e)) {
                    return;
                }
                TileEntityLuminator.this.onLoaded();
                if (TileEntityLuminator.this.enableUpdateEntity()) {
                    world.field_147482_g.add(TileEntityLuminator.this);
                }
            }
        });
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onLoaded() {
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    public final boolean canUpdate() {
        return false;
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public boolean isRedstonePowered() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        ++this.ticker;
        if (this.ticker % 4 == 0) {
            TileEntityLuminator newLumi;
            if (this.isActive()) {
                this.energy -= 1.0;
            }
            if (StackUtil.equals(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), Ic2Items.activeLuminator) && !this.isActive()) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, StackUtil.getBlock(Ic2Items.luminator), this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), 7);
                newLumi = (TileEntityLuminator)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                newLumi.lswitch = this.lswitch;
                newLumi.energy = this.energy;
            }
            if (StackUtil.equals(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), Ic2Items.luminator) && this.isActive()) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, StackUtil.getBlock(Ic2Items.activeLuminator), this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), 7);
                newLumi = (TileEntityLuminator)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                newLumi.lswitch = this.lswitch;
                newLumi.energy = this.energy;
            }
        }
    }

    public boolean isActive() {
        if (this.energy <= 0.0) {
            return false;
        }
        return !this.lswitch && this.isRedstonePowered() || this.lswitch && !this.isRedstonePowered();
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return emitter instanceof TileEntityCable;
    }

    @Override
    public double demandedEnergyUnits() {
        return (double)this.getMaxEnergy() - this.energy;
    }

    @Override
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        if (amount > (double)this.maxInput) {
            this.poof();
            return 0.0;
        }
        if (this.energy >= (double)this.getMaxEnergy() || amount <= 0.0) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    @Override
    public int getMaxSafeInput() {
        return this.maxInput;
    }

    public int getMaxEnergy() {
        return 2;
    }

    public void poof() {
        if (this.loaded) {
            this.onUnloaded();
        }
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ExplosionIC2 explosion = new ExplosionIC2(this.field_145850_b, null, 0.5 + (double)this.field_145851_c, 0.5 + (double)this.field_145848_d, 0.5 + (double)this.field_145849_e, 0.5f, 0.85f);
        explosion.doExplosion();
    }

    public boolean canCableConnectFrom(int x, int y, int z) {
        int facing = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        switch (facing) {
            case 0: {
                return x == this.field_145851_c && y == this.field_145848_d + 1 && z == this.field_145849_e;
            }
            case 1: {
                return x == this.field_145851_c && y == this.field_145848_d - 1 && z == this.field_145849_e;
            }
            case 2: {
                return x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e + 1;
            }
            case 3: {
                return x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e - 1;
            }
            case 4: {
                return x == this.field_145851_c + 1 && y == this.field_145848_d && z == this.field_145849_e;
            }
            case 5: {
                return x == this.field_145851_c - 1 && y == this.field_145848_d && z == this.field_145849_e;
            }
        }
        return false;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return true;
    }

    @Override
    public short getFacing() {
        return 0;
    }

    @Override
    public void setFacing(short facing) {
        this.lswitch = !this.lswitch;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public float getWrenchDropRate() {
        return 0.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return null;
    }
}

