/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.api.recipe.IScrapboxManager;
import ic2.api.recipe.Recipes;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.init.InternalName;
import ic2.core.item.BehaviorScrapboxDispense;
import ic2.core.item.ItemIC2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemScrapbox
extends ItemIC2 {
    public ItemScrapbox(InternalName internalName) {
        super(internalName);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new BehaviorScrapboxDispense());
    }

    public static void init() {
        ArrayList ores;
        Recipes.scrapboxDrops = new ScrapboxRecipeManager();
        if (IC2.suddenlyHoes) {
            ItemScrapbox.addDrop(Items.field_151017_I, 9001.0f);
        } else {
            ItemScrapbox.addDrop(Items.field_151017_I, 5.01f);
        }
        ItemScrapbox.addDrop(Blocks.field_150346_d, 5.0f);
        ItemScrapbox.addDrop(Items.field_151055_y, 4.0f);
        ItemScrapbox.addDrop((Block)Blocks.field_150349_c, 3.0f);
        ItemScrapbox.addDrop(Blocks.field_150351_n, 3.0f);
        ItemScrapbox.addDrop(Blocks.field_150424_aL, 2.0f);
        ItemScrapbox.addDrop(Items.field_151078_bh, 2.0f);
        ItemScrapbox.addDrop(Items.field_151034_e, 1.5f);
        ItemScrapbox.addDrop(Items.field_151025_P, 1.5f);
        ItemScrapbox.addDrop(Ic2Items.filledTinCan.func_77973_b(), 1.5f);
        ItemScrapbox.addDrop(Items.field_151041_m);
        ItemScrapbox.addDrop(Items.field_151038_n);
        ItemScrapbox.addDrop(Items.field_151039_o);
        ItemScrapbox.addDrop(Blocks.field_150425_aM);
        ItemScrapbox.addDrop(Items.field_151155_ap);
        ItemScrapbox.addDrop(Items.field_151116_aA);
        ItemScrapbox.addDrop(Items.field_151008_G);
        ItemScrapbox.addDrop(Items.field_151103_aS);
        ItemScrapbox.addDrop(Items.field_151157_am, 0.9f);
        ItemScrapbox.addDrop(Items.field_151083_be, 0.9f);
        ItemScrapbox.addDrop(Blocks.field_150423_aK, 0.9f);
        ItemScrapbox.addDrop(Items.field_151077_bg, 0.9f);
        ItemScrapbox.addDrop(Items.field_151143_au, 0.01f);
        ItemScrapbox.addDrop(Items.field_151137_ax, 0.9f);
        ItemScrapbox.addDrop(Ic2Items.rubber.func_77973_b(), 0.8f);
        ItemScrapbox.addDrop(Items.field_151114_aO, 0.8f);
        ItemScrapbox.addDrop(Ic2Items.coalDust.func_77973_b(), 0.8f);
        ItemScrapbox.addDrop(Ic2Items.copperDust.func_77973_b(), 0.8f);
        ItemScrapbox.addDrop(Ic2Items.tinDust.func_77973_b(), 0.8f);
        ItemScrapbox.addDrop(Ic2Items.plantBall.func_77973_b(), 0.7f);
        ItemScrapbox.addDrop(Ic2Items.suBattery.func_77973_b(), 0.7f);
        ItemScrapbox.addDrop(Ic2Items.ironDust.func_77973_b(), 0.7f);
        ItemScrapbox.addDrop(Ic2Items.goldDust.func_77973_b(), 0.7f);
        ItemScrapbox.addDrop(Items.field_151123_aH, 0.6f);
        ItemScrapbox.addDrop(Blocks.field_150366_p, 0.5f);
        ItemScrapbox.addDrop((Item)Items.field_151169_ag, 0.01f);
        ItemScrapbox.addDrop(Blocks.field_150352_o, 0.5f);
        ItemScrapbox.addDrop(Items.field_151105_aU, 0.5f);
        ItemScrapbox.addDrop(Items.field_151045_i, 0.1f);
        ItemScrapbox.addDrop(Items.field_151166_bC, 0.05f);
        if (Ic2Items.copperOre != null) {
            ItemScrapbox.addDrop(Ic2Items.copperOre.func_77973_b(), 0.7f);
        } else {
            ores = OreDictionary.getOres((String)"oreCopper");
            if (!ores.isEmpty()) {
                ItemScrapbox.addDrop(((ItemStack)ores.get(0)).func_77946_l(), 0.7f);
            }
        }
        if (Ic2Items.tinOre != null) {
            ItemScrapbox.addDrop(Ic2Items.tinOre.func_77973_b(), 0.7f);
        } else {
            ores = OreDictionary.getOres((String)"oreTin");
            if (!ores.isEmpty()) {
                ItemScrapbox.addDrop(((ItemStack)ores.get(0)).func_77946_l(), 0.7f);
            }
        }
    }

    public static void addDrop(Item item) {
        ItemScrapbox.addDrop(new ItemStack(item), 1.0f);
    }

    public static void addDrop(Item item, float chance) {
        ItemScrapbox.addDrop(new ItemStack(item), chance);
    }

    public static void addDrop(Block block) {
        ItemScrapbox.addDrop(new ItemStack(block), 1.0f);
    }

    public static void addDrop(Block block, float chance) {
        ItemScrapbox.addDrop(new ItemStack(block), chance);
    }

    public static void addDrop(ItemStack item) {
        ItemScrapbox.addDrop(item, 1.0f);
    }

    public static void addDrop(ItemStack item, float chance) {
        Recipes.scrapboxDrops.addDrop(item, chance);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        ItemStack itemStack;
        if (IC2.platform.isSimulating() && (itemStack = Recipes.scrapboxDrops.getDrop(itemstack, !entityplayer.field_71075_bZ.field_75098_d)) != null) {
            entityplayer.func_71019_a(itemStack, false);
        }
        return itemstack;
    }

    static class ScrapboxRecipeManager
    implements IScrapboxManager {
        private final List<Drop> drops = new ArrayList<Drop>();
        private final Random random = new Random();

        ScrapboxRecipeManager() {
        }

        @Override
        public void addDrop(ItemStack drop, float rawChance) {
            this.drops.add(new Drop(drop, rawChance));
        }

        @Override
        public ItemStack getDrop(ItemStack input, boolean adjustInput) {
            if (this.drops.isEmpty()) {
                return null;
            }
            if (adjustInput) {
                --input.field_77994_a;
            }
            float chance = this.random.nextFloat() * Drop.topChance;
            int low = 0;
            int high = this.drops.size() - 1;
            while (low < high) {
                int mid = (high + low) / 2;
                if (chance < this.drops.get((int)mid).upperChanceBound) {
                    high = mid;
                    continue;
                }
                low = mid + 1;
            }
            return this.drops.get((int)low).item.func_77946_l();
        }

        @Override
        public Map<ItemStack, Float> getDrops() {
            HashMap<ItemStack, Float> ret = new HashMap<ItemStack, Float>(this.drops.size());
            for (Drop drop : this.drops) {
                ret.put(drop.item, Float.valueOf(drop.originalChance.floatValue() / Drop.topChance));
            }
            return ret;
        }
    }

    static class Drop {
        ItemStack item;
        Float originalChance;
        float upperChanceBound;
        static float topChance;

        Drop(ItemStack item1, float chance) {
            this.item = item1;
            this.originalChance = Float.valueOf(chance);
            this.upperChanceBound = topChance += chance;
        }
    }
}

