/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import ic2.api.Direction;
import ic2.core.block.personal.IPersonalBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;

public final class StackUtil {
    private static final Random random = new Random();

    public static List<AdjacentInv> getAdjacentInventories(TileEntity source) {
        ArrayList<AdjacentInv> inventories = new ArrayList<AdjacentInv>();
        for (Direction direction : Direction.directions) {
            TileEntity target = direction.applyToTileEntity(source);
            if (!(target instanceof IInventory)) continue;
            IInventory inventory = (IInventory)target;
            if (target instanceof TileEntityChest) {
                for (Direction direction2 : Direction.directions) {
                    TileEntity target2;
                    if (direction2 == Direction.YN || direction2 == Direction.YP || !((target2 = direction2.applyToTileEntity(target)) instanceof TileEntityChest)) continue;
                    inventory = new InventoryLargeChest("", inventory, (IInventory)target2);
                    break;
                }
            }
            if (target instanceof IPersonalBlock && (!(source instanceof IPersonalBlock) || !((IPersonalBlock)target).permitsAccess(((IPersonalBlock)source).getUsername()))) continue;
            inventories.add(new AdjacentInv(inventory, direction));
        }
        Collections.sort(inventories, new Comparator<AdjacentInv>(){

            @Override
            public int compare(AdjacentInv a, AdjacentInv b) {
                if (a.inv instanceof IPersonalBlock || !(b.inv instanceof IPersonalBlock)) {
                    return -1;
                }
                if (b.inv instanceof IPersonalBlock || !(a.inv instanceof IPersonalBlock)) {
                    return 1;
                }
                return b.inv.func_70302_i_() - a.inv.func_70302_i_();
            }
        });
        return inventories;
    }

    public static int distribute(TileEntity source, ItemStack itemStack, boolean simulate) {
        int transferred = 0;
        for (AdjacentInv inventory : StackUtil.getAdjacentInventories(source)) {
            int amount = StackUtil.putInInventory(inventory.inv, inventory.dir.getInverse(), itemStack, simulate);
            transferred += amount;
            itemStack.field_77994_a -= amount;
            if (itemStack.field_77994_a != 0) continue;
            break;
        }
        itemStack.field_77994_a += transferred;
        return transferred;
    }

    public static ItemStack fetch(TileEntity source, ItemStack itemStack, boolean simulate) {
        ItemStack ret = null;
        int oldStackSize = itemStack.field_77994_a;
        for (AdjacentInv inventory : StackUtil.getAdjacentInventories(source)) {
            ItemStack transferred = StackUtil.getFromInventory(inventory.inv, inventory.dir.getInverse(), itemStack, simulate);
            if (transferred == null) continue;
            if (ret == null) {
                ret = transferred;
            } else {
                ret.field_77994_a += transferred.field_77994_a;
                itemStack.field_77994_a -= transferred.field_77994_a;
            }
            if (ret.field_77994_a != itemStack.field_77994_a) continue;
            break;
        }
        itemStack.field_77994_a = oldStackSize;
        return ret;
    }

    public static void distributeDrop(TileEntity source, List<ItemStack> itemStacks) {
        Iterator<ItemStack> it = itemStacks.iterator();
        while (it.hasNext()) {
            ItemStack itemStack = it.next();
            int amount = StackUtil.distribute(source, itemStack, false);
            if (amount == itemStack.field_77994_a) {
                it.remove();
                continue;
            }
            itemStack.field_77994_a -= amount;
        }
        for (ItemStack itemStack : itemStacks) {
            StackUtil.dropAsEntity(source.func_145831_w(), source.field_145851_c, source.field_145848_d, source.field_145849_e, itemStack);
        }
        itemStacks.clear();
    }

    public static ItemStack getFromInventory(IInventory inv, Direction side, ItemStack itemStackDestination, boolean simulate) {
        ItemStack ret = null;
        int toTransfer = itemStackDestination.field_77994_a;
        int vanillaSide = side.toSideValue();
        for (int i : StackUtil.getInventorySlots(inv, vanillaSide)) {
            ItemStack itemStack;
            if (toTransfer <= 0) break;
            if (inv instanceof ISidedInventory && !((ISidedInventory)inv).func_102008_b(i, itemStackDestination, vanillaSide) || (itemStack = inv.func_70301_a(i)) == null || !StackUtil.isStackEqual(itemStack, itemStackDestination)) continue;
            if (ret == null) {
                ret = StackUtil.copyWithSize(itemStack, 0);
            }
            int transfer = Math.min(toTransfer, itemStack.field_77994_a);
            if (!simulate) {
                itemStack.field_77994_a -= transfer;
                if (itemStack.field_77994_a == 0) {
                    inv.func_70299_a(i, null);
                }
            }
            toTransfer -= transfer;
            ret.field_77994_a += transfer;
        }
        if (!simulate && toTransfer != itemStackDestination.field_77994_a) {
            inv.func_70296_d();
        }
        return ret;
    }

    public static int putInInventory(IInventory inv, Direction side, ItemStack itemStackSource, boolean simulate) {
        int transfer;
        ItemStack itemStack;
        int[] slots;
        int toTransfer = itemStackSource.field_77994_a;
        int vanillaSide = side.toSideValue();
        for (int i : slots = StackUtil.getInventorySlots(inv, vanillaSide)) {
            if (toTransfer <= 0) break;
            if (!inv.func_94041_b(i, itemStackSource) || inv instanceof ISidedInventory && !((ISidedInventory)inv).func_102007_a(i, itemStackSource, vanillaSide) || (itemStack = inv.func_70301_a(i)) == null || !itemStack.func_77969_a(itemStackSource)) continue;
            transfer = Math.min(toTransfer, itemStack.func_77976_d() - itemStack.field_77994_a);
            if (!simulate) {
                itemStack.field_77994_a += transfer;
            }
            toTransfer -= transfer;
        }
        for (int i : slots) {
            if (toTransfer <= 0) break;
            if (!inv.func_94041_b(i, itemStackSource) || inv instanceof ISidedInventory && !((ISidedInventory)inv).func_102007_a(i, itemStackSource, vanillaSide) || (itemStack = inv.func_70301_a(i)) != null) continue;
            transfer = Math.min(toTransfer, itemStackSource.func_77976_d());
            if (!simulate) {
                ItemStack dest = StackUtil.copyWithSize(itemStackSource, transfer);
                inv.func_70299_a(i, dest);
            }
            toTransfer -= transfer;
        }
        if (!simulate && toTransfer != itemStackSource.field_77994_a) {
            inv.func_70296_d();
        }
        return itemStackSource.field_77994_a - toTransfer;
    }

    public static int[] getInventorySlots(IInventory inv, int side) {
        if (inv instanceof ISidedInventory) {
            return ((ISidedInventory)inv).func_94128_d(side);
        }
        int[] ret = new int[inv.func_70302_i_()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    public static void dropAsEntity(World world, int x, int y, int z, ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        double f = 0.7;
        double dx = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dy = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dz = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)x + dx, (double)y + dy, (double)z + dz, itemStack.func_77946_l());
        entityItem.field_145804_b = 10;
        world.func_72838_d((Entity)entityItem);
    }

    public static ItemStack copyWithSize(ItemStack itemStack, int newSize) {
        ItemStack ret = itemStack.func_77946_l();
        ret.field_77994_a = newSize;
        return ret;
    }

    public static ItemStack copyWithWildCard(ItemStack itemStack) {
        ItemStack ret = itemStack.func_77946_l();
        Items.field_151100_aR.setDamage(ret, Short.MAX_VALUE);
        return ret;
    }

    public static NBTTagCompound getOrCreateNbtData(ItemStack itemStack) {
        NBTTagCompound ret = itemStack.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound();
            itemStack.func_77982_d(ret);
        }
        return ret;
    }

    public static boolean isStackEqual(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() && !stack1.func_77984_f() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static Block getBlock(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).field_150939_a;
        }
        return null;
    }

    public static boolean equals(Block block, ItemStack stack) {
        return block == StackUtil.getBlock(stack);
    }

    public static boolean damageItemStack(ItemStack itemStack, int amount) {
        if (itemStack.func_96631_a(amount, random)) {
            --itemStack.field_77994_a;
            itemStack.func_77964_b(0);
            return itemStack.field_77994_a <= 0;
        }
        return false;
    }

    public static boolean check2(Iterable<List<ItemStack>> list) {
        for (List<ItemStack> list2 : list) {
            if (StackUtil.check(list2)) continue;
            return false;
        }
        return true;
    }

    public static boolean check(ItemStack[] array) {
        return StackUtil.check(Arrays.asList(array));
    }

    public static boolean check(Iterable<ItemStack> list) {
        for (ItemStack stack : list) {
            if (StackUtil.check(stack)) continue;
            return false;
        }
        return true;
    }

    public static boolean check(ItemStack stack) {
        return stack.func_77973_b() != null;
    }

    public static String toStringSafe2(Iterable<List<ItemStack>> list) {
        String ret = "[";
        for (List<ItemStack> list2 : list) {
            if (ret.length() > 1) {
                ret = ret + ", ";
            }
            ret = ret + StackUtil.toStringSafe(list2);
        }
        ret = ret + "]";
        return ret;
    }

    public static String toStringSafe(ItemStack[] array) {
        return StackUtil.toStringSafe(Arrays.asList(array));
    }

    public static String toStringSafe(Iterable<ItemStack> list) {
        String ret = "[";
        for (ItemStack stack : list) {
            if (ret.length() > 1) {
                ret = ret + ", ";
            }
            ret = ret + StackUtil.toStringSafe(stack);
        }
        ret = ret + "]";
        return ret;
    }

    public static String toStringSafe(ItemStack stack) {
        if (stack.func_77973_b() == null) {
            return stack.field_77994_a + "x(null)@(unknown)";
        }
        return stack.toString();
    }

    public static void consumInventoryItem(EntityPlayer player, ItemStack itemStack) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null || !player.field_71071_by.field_70462_a[i].func_77969_a(itemStack)) continue;
            player.field_71071_by.func_70298_a(i, 1);
            return;
        }
    }

    public static class AdjacentInv {
        public IInventory inv;
        public Direction dir;

        public AdjacentInv(IInventory inv1, Direction dir1) {
            this.inv = inv1;
            this.dir = dir1;
        }
    }
}

