/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.uu;

import cpw.mods.fml.common.registry.GameRegistry;
import ic2.core.IC2;
import ic2.core.Ic2Player;
import ic2.core.init.MainConfig;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import ic2.core.util.ItemStackWrapper;
import ic2.core.util.PriorityExecutor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunkProvider;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;

public class DropScan {
    private EntityPlayer player;
    private final Map<ItemStackWrapper, MutableInt> drops = new HashMap<ItemStackWrapper, MutableInt>();
    private static final ConcurrentMap<BlockDesc, DropDesc> typicalDrops = new ConcurrentHashMap<BlockDesc, DropDesc>();
    private static final Object generatorLock = new Object();
    private static AtomicInteger uuScanProgress = new AtomicInteger();
    private static int uuScanAmount;

    public static void start(World world, int area, int areaCount, int range) {
        uuScanProgress.set(0);
        uuScanAmount = areaCount;
        FutureTask[] futures = new FutureTask[areaCount];
        for (int i = 0; i < areaCount; ++i) {
            int x = IC2.random.nextInt(area) - area / 2;
            int z = IC2.random.nextInt(area) - area / 2;
            futures[i] = IC2.getInstance().threadPool.submit(new Calculation(world, x, z, range));
        }
        DropScan.analyze(futures);
    }

    private static void analyze(Future<Iterable<Map.Entry<ItemStack, Integer>>>[] futures) {
        double normalizeBy;
        HashMap<ItemStackWrapper, MutableLong> result = new HashMap<ItemStackWrapper, MutableLong>();
        for (Future<Iterable<Map.Entry<ItemStack, Integer>>> future : futures) {
            try {
                Iterable<Map.Entry<ItemStack, Integer>> partialResult = future.get();
                for (Map.Entry<ItemStack, Integer> entry : partialResult) {
                    ItemStackWrapper itemStackWrapper = new ItemStackWrapper(entry.getKey());
                    MutableLong amount = (MutableLong)result.get(itemStackWrapper);
                    if (amount == null) {
                        amount = new MutableLong();
                        result.put(itemStackWrapper, amount);
                    }
                    amount.add((Number)entry.getValue());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        TreeSet<Map.Entry<ItemStackWrapper, MutableLong>> counts = new TreeSet<Map.Entry<ItemStackWrapper, MutableLong>>(new Comparator<Map.Entry<ItemStackWrapper, MutableLong>>(){

            @Override
            public int compare(Map.Entry<ItemStackWrapper, MutableLong> a, Map.Entry<ItemStackWrapper, MutableLong> b) {
                long ret = b.getValue().getValue() - a.getValue().getValue();
                return ret > 0L ? 1 : (ret < 0L ? -1 : 0);
            }
        });
        counts.addAll(result.entrySet());
        ItemStackWrapper cobblestone = new ItemStackWrapper(new ItemStack(Blocks.field_150347_e));
        ItemStackWrapper netherrack = new ItemStackWrapper(new ItemStack(Blocks.field_150424_aL));
        if (!result.containsKey(cobblestone)) {
            if (!result.containsKey(netherrack)) {
                IC2.log.warn("UU scan failed, there was no cobblestone or netherrack dropped");
                return;
            }
            normalizeBy = ((MutableLong)result.get(netherrack)).getValue().longValue();
        } else {
            normalizeBy = ((MutableLong)result.get(cobblestone)).getValue().longValue();
            if (result.containsKey(netherrack)) {
                normalizeBy = Math.max(normalizeBy, (double)((MutableLong)result.get(netherrack)).getValue().longValue());
            }
        }
        Config config = MainConfig.get().getSub("balance/uu-values/world scan");
        if (config == null) {
            config = MainConfig.get().getSub("balance/uu-values").addSub("world scan", "Initial uu values from scanning the world.\nRun /ic2 uu-world-scan <small|medium|large> to calibrate them for your world.\nDelete this whole section to revert to the default predefined values.");
        }
        IC2.log.info("total");
        for (Map.Entry entry : counts) {
            ItemStack stack = ((ItemStackWrapper)entry.getKey()).stack;
            long count = ((MutableLong)entry.getValue()).getValue();
            IC2.log.info("{} {}", new Object[]{count, stack.func_77973_b().func_77653_i(stack)});
            config.set(ConfigUtil.fromStack(stack), normalizeBy / (double)count);
        }
        MainConfig.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<Map.Entry<ItemStack, Integer>> scanArea(World originalWorld, int xStart, int zStart, int range) {
        IChunkProvider generator;
        DummyWorld world = new DummyWorld(originalWorld);
        ((DummyChunkProvider)world.func_72863_F()).generator = generator = world.field_73011_w.func_76555_c();
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        ArrayList<Chunk> pendingChunks = new ArrayList<Chunk>();
        Object object = generatorLock;
        synchronized (object) {
            for (int x = xStart; x < xStart + range; ++x) {
                for (int i = zStart; i < zStart + range; ++i) {
                    Chunk chunk = generator.func_73154_d(x, i);
                    chunks.add(chunk);
                    if (x == xStart || x == xStart + range || i == zStart || i == zStart + range) continue;
                    pendingChunks.add(chunk);
                }
            }
            ((DummyChunkProvider)world.func_72863_F()).setChunks(chunks);
            for (Chunk chunk : pendingChunks) {
                chunk.func_76624_a(world.func_72863_F(), world.func_72863_F(), chunk.field_76635_g, chunk.field_76647_h);
            }
        }
        this.player = new Ic2Player(world);
        for (Chunk chunk : pendingChunks) {
            this.scanChunk(world, chunk);
        }
        ArrayList<Map.Entry<ItemStack, Integer>> counts = new ArrayList<Map.Entry<ItemStack, Integer>>(this.drops.size());
        for (Map.Entry entry : this.drops.entrySet()) {
            counts.add(new AbstractMap.SimpleImmutableEntry<ItemStack, Integer>(((ItemStackWrapper)entry.getKey()).stack, ((MutableInt)entry.getValue()).getValue()));
        }
        Collections.sort(counts, new Comparator<Map.Entry<ItemStack, Integer>>(){

            @Override
            public int compare(Map.Entry<ItemStack, Integer> a, Map.Entry<ItemStack, Integer> b) {
                return b.getValue() - a.getValue();
            }
        });
        return counts;
    }

    private void scanChunk(DummyWorld world, Chunk chunk) {
        int yMax = world.func_72800_K();
        for (int y = 0; y < yMax; ++y) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    Block block = chunk.func_150810_a(x, y, z);
                    if (block == Blocks.field_150350_a) continue;
                    int meta = chunk.func_76628_c(x, y, z);
                    for (ItemStack drop : this.getDrops(world, x, y, z, block, meta)) {
                        this.addDrop(drop);
                    }
                }
            }
        }
    }

    private List<ItemStack> getDrops(DummyWorld world, int x, int y, int z, Block block, int meta) {
        BlockDesc key = new BlockDesc(block, meta);
        DropDesc typicalDrop = (DropDesc)typicalDrops.get(key);
        if (typicalDrop == null || typicalDrop.dropCount.get() < 1000) {
            DropDesc prevValue;
            block.func_149681_a((World)world, x, y, z, meta, this.player);
            if (block.removedByPlayer((World)world, this.player, x, y, z)) {
                block.func_149664_b((World)world, x, y, z, meta);
                block.func_149697_b((World)world, x, y, z, meta, 0);
            } else {
                IC2.log.info("can't harvest " + block);
            }
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>(world.spawnedEntities.size());
            for (Entity entity : world.spawnedEntities) {
                if (!(entity instanceof EntityItem)) continue;
                drops.add(((EntityItem)entity).func_92059_d());
            }
            world.spawnedEntities.clear();
            if (typicalDrop == null && (prevValue = typicalDrops.putIfAbsent(key, typicalDrop = new DropDesc(drops))) != null) {
                typicalDrop = prevValue;
            }
            if (typicalDrop.dropCount.get() >= 0) {
                boolean equal;
                boolean bl = equal = typicalDrop.drops.size() == drops.size();
                if (equal) {
                    Iterator it = drops.iterator();
                    Iterator<ItemStack> it2 = typicalDrop.drops.iterator();
                    while (it.hasNext()) {
                        ItemStack b;
                        ItemStack a = (ItemStack)it.next();
                        if (ItemStack.func_77989_b((ItemStack)a, (ItemStack)(b = it2.next()))) continue;
                        equal = false;
                        break;
                    }
                }
                if (equal) {
                    int prev = typicalDrop.dropCount.incrementAndGet();
                    if (prev < 0) {
                        typicalDrop.dropCount.set(Integer.MIN_VALUE);
                    }
                } else {
                    typicalDrop.dropCount.set(Integer.MIN_VALUE);
                }
            }
            return drops;
        }
        return typicalDrop.drops;
    }

    private void addDrop(ItemStack stack) {
        ItemStackWrapper key = new ItemStackWrapper(stack);
        MutableInt amount = this.drops.get(key);
        if (amount == null) {
            amount = new MutableInt();
            this.drops.put(key, amount);
        }
        amount.add(stack.field_77994_a);
    }

    private static final class DropDesc {
        List<ItemStack> drops;
        AtomicInteger dropCount = new AtomicInteger();

        DropDesc(List<ItemStack> drops) {
            this.drops = drops;
        }
    }

    private static final class BlockDesc {
        private final Block block;
        private final int meta;

        BlockDesc(Block block, int meta) {
            this.block = block;
            this.meta = meta;
        }

        public int hashCode() {
            return this.block.hashCode() * 31 + this.meta;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BlockDesc) {
                return ((BlockDesc)obj).block == this.block && ((BlockDesc)obj).meta == this.meta;
            }
            return false;
        }
    }

    static class DummyChunkProvider
    implements IChunkProvider {
        private final World world;
        private Chunk lastChunk;
        private final Map<Long, Chunk> chunkMap = new HashMap<Long, Chunk>();
        private final Chunk emptyChunk;
        public IChunkProvider generator;

        public DummyChunkProvider(World world1) {
            this.world = world1;
            this.emptyChunk = new EmptyChunk(world1, 0, 0);
        }

        public void setChunks(List<Chunk> chunks) {
            for (Chunk chunk : chunks) {
                this.chunkMap.put(ChunkCoordIntPair.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h), chunk);
            }
        }

        public boolean func_73157_c() {
            return false;
        }

        public boolean func_73149_a(int x, int z) {
            return this.chunkMap.containsKey(ChunkCoordIntPair.func_77272_a((int)x, (int)z));
        }

        public ChunkPosition func_147416_a(World world1, String s, int i, int j, int k) {
            return null;
        }

        public int func_73152_e() {
            return 1;
        }

        public List func_73155_a(EnumCreatureType enumcreaturetype, int i, int j, int k) {
            return null;
        }

        public Chunk func_73158_c(int i, int j) {
            return null;
        }

        public String func_73148_d() {
            return "Dummy";
        }

        public void func_73153_a(IChunkProvider provider, int x, int z) {
            Chunk chunk = this.func_73154_d(x, z);
            if (!chunk.field_76646_k) {
                chunk.field_76646_k = true;
                if (this.generator != null) {
                    this.generator.func_73153_a(provider, x, z);
                    GameRegistry.generateWorld((int)x, (int)z, (World)this.world, (IChunkProvider)this.generator, (IChunkProvider)provider);
                    chunk.func_76630_e();
                }
            }
        }

        public Chunk func_73154_d(int x, int z) {
            if (this.lastChunk != null && this.lastChunk.field_76635_g == x && this.lastChunk.field_76647_h == z) {
                return this.lastChunk;
            }
            Chunk ret = this.chunkMap.get(ChunkCoordIntPair.func_77272_a((int)x, (int)z));
            if (ret == null) {
                return this.emptyChunk;
            }
            this.lastChunk = ret;
            return ret;
        }

        public void func_82695_e(int i, int j) {
        }

        public boolean func_73151_a(boolean flag, IProgressUpdate iprogressupdate) {
            return true;
        }

        public void func_104112_b() {
        }

        public boolean func_73156_b() {
            return false;
        }
    }

    static class DummyWorld
    extends World {
        List<Entity> spawnedEntities = new ArrayList<Entity>();

        public DummyWorld(World world) {
            super(world.func_72860_G(), "DummyWorld", new WorldSettings(world.func_72912_H()), WorldProvider.func_76570_a((int)world.field_73011_w.field_76574_g), world.field_72984_F);
            this.field_73020_y = new DummyChunkProvider(this);
            this.field_73013_u = world.field_73013_u;
        }

        protected IChunkProvider func_72970_h() {
            return null;
        }

        public Entity func_73045_a(int i) {
            return null;
        }

        public boolean func_147465_d(int x, int y, int z, Block block, int meta, int flags) {
            if (y >= 256 || y < 0) {
                return false;
            }
            Chunk chunk = this.func_72964_e(x >> 4, z >> 4);
            return chunk.func_150807_a(x & 0xF, y, z & 0xF, block, meta);
        }

        public boolean func_72921_c(int x, int y, int z, int meta, int flags) {
            if (y >= 256 || y < 0) {
                return false;
            }
            Chunk chunk = this.func_72964_e(x >> 4, z >> 4);
            return chunk.func_76589_b(x & 0xF, y, z & 0xF, meta);
        }

        public boolean func_147463_c(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
            return true;
        }

        public boolean func_72838_d(Entity entity) {
            this.spawnedEntities.add(entity);
            return true;
        }
    }

    static class Calculation
    implements Callable<Iterable<Map.Entry<ItemStack, Integer>>>,
    PriorityExecutor.CustomPriority {
        private final World world;
        private final int x;
        private final int z;
        private final int range;

        Calculation(World world1, int x1, int z1, int range1) {
            this.world = world1;
            this.x = x1;
            this.z = z1;
            this.range = range1;
        }

        @Override
        public Iterable<Map.Entry<ItemStack, Integer>> call() throws Exception {
            String threadName = Thread.currentThread().getName();
            Thread.currentThread().setName("Server thread");
            Iterable ret = new DropScan().scanArea(this.world, this.x, this.z, this.range);
            Thread.currentThread().setName(threadName);
            int done = uuScanProgress.incrementAndGet();
            if (done % 50 == 0) {
                IC2.log.info("World scan progress: {}%", new Object[]{100 * done / uuScanAmount});
            }
            return ret;
        }

        @Override
        public int getPriority() {
            return -100;
        }
    }
}

