/*
 * Decompiled with CFR 0.152.
 */
package ic2.neiIntegration.core;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.core.block.machine.gui.GuiMetalFormer;
import ic2.core.util.StackUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public abstract class MetalFormerRecipeHandler
extends TemplateRecipeHandler {
    int ticks;

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)6, (int)146, (int)70);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticks;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(47, 33, 46, 9), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<IRecipeInput, RecipeOutput> entry : this.getRecipeList().entrySet()) {
                this.arecipes.add(new CachedIORecipe(entry.getKey(), entry.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        block0: for (Map.Entry<IRecipeInput, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            for (ItemStack output : entry.getValue().items) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)output, (ItemStack)result)) continue;
                this.arecipes.add(new CachedIORecipe(entry.getKey(), entry.getValue()));
                continue block0;
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<IRecipeInput, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            if (!entry.getKey().matches(ingredient)) continue;
            this.arecipes.add(new CachedIORecipe(entry.getKey(), entry.getValue()));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiMetalFormer.class;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"ic2.blockMetalFormer");
    }

    public String getRecipeId() {
        return "ic2.MetalFormer";
    }

    public String getGuiTexture() {
        return "ic2:textures/gui/GUIMetalFormer.png";
    }

    public String getOverlayIdentifier() {
        return "metalformer";
    }

    public abstract Map<IRecipeInput, RecipeOutput> getRecipeList();

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public List<PositionedStack> ingredients;
        public PositionedStack output;

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(MetalFormerRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public CachedIORecipe(ItemStack input, ItemStack output1) {
            super((TemplateRecipeHandler)MetalFormerRecipeHandler.this);
            this.ingredients = new ArrayList<PositionedStack>();
            this.ingredients.add(new PositionedStack((Object)input, 12, 11));
            this.output = new PositionedStack((Object)output1, 112, 30);
        }

        public CachedIORecipe(IRecipeInput input, RecipeOutput output1) {
            super((TemplateRecipeHandler)MetalFormerRecipeHandler.this);
            this.ingredients = new ArrayList<PositionedStack>();
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (ItemStack item : input.getInputs()) {
                items.add(StackUtil.copyWithSize(item, input.getAmount()));
            }
            this.ingredients.add(new PositionedStack(items, 12, 11));
            this.output = new PositionedStack((Object)output1.items.get(0), 112, 30);
        }
    }
}

