/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftBuilders;
import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.BuildCraftMod;
import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.core.EnumColor;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.JavaTools;
import buildcraft.api.gates.GateExpansions;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.StatementManager;
import buildcraft.api.transport.IExtractionHandler;
import buildcraft.api.transport.PipeManager;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.DefaultProps;
import buildcraft.core.InterModComms;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.PowerMode;
import buildcraft.core.network.BuildCraftChannelHandler;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.silicon.ItemRedstoneChipset;
import buildcraft.transport.BlockFilteredBuffer;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.GuiHandler;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.ItemGateCopier;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.ItemPipeWire;
import buildcraft.transport.ItemPlug;
import buildcraft.transport.ItemRobotStation;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeActionProvider;
import buildcraft.transport.PipeColoringRecipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTriggerProvider;
import buildcraft.transport.TileFilteredBuffer;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TransportProxy;
import buildcraft.transport.WireIconProvider;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.GateExpansionPulsar;
import buildcraft.transport.gates.GateExpansionRedstoneFader;
import buildcraft.transport.gates.GateExpansionTimer;
import buildcraft.transport.gates.ItemGate;
import buildcraft.transport.network.PacketHandlerTransport;
import buildcraft.transport.pipes.PipeFluidsCobblestone;
import buildcraft.transport.pipes.PipeFluidsEmerald;
import buildcraft.transport.pipes.PipeFluidsGold;
import buildcraft.transport.pipes.PipeFluidsIron;
import buildcraft.transport.pipes.PipeFluidsQuartz;
import buildcraft.transport.pipes.PipeFluidsSandstone;
import buildcraft.transport.pipes.PipeFluidsStone;
import buildcraft.transport.pipes.PipeFluidsVoid;
import buildcraft.transport.pipes.PipeFluidsWood;
import buildcraft.transport.pipes.PipeItemsCobblestone;
import buildcraft.transport.pipes.PipeItemsDaizuli;
import buildcraft.transport.pipes.PipeItemsDiamond;
import buildcraft.transport.pipes.PipeItemsEmerald;
import buildcraft.transport.pipes.PipeItemsEmzuli;
import buildcraft.transport.pipes.PipeItemsGold;
import buildcraft.transport.pipes.PipeItemsIron;
import buildcraft.transport.pipes.PipeItemsLapis;
import buildcraft.transport.pipes.PipeItemsObsidian;
import buildcraft.transport.pipes.PipeItemsQuartz;
import buildcraft.transport.pipes.PipeItemsSandstone;
import buildcraft.transport.pipes.PipeItemsStone;
import buildcraft.transport.pipes.PipeItemsStripes;
import buildcraft.transport.pipes.PipeItemsVoid;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.pipes.PipePowerCobblestone;
import buildcraft.transport.pipes.PipePowerDiamond;
import buildcraft.transport.pipes.PipePowerEmerald;
import buildcraft.transport.pipes.PipePowerGold;
import buildcraft.transport.pipes.PipePowerIron;
import buildcraft.transport.pipes.PipePowerQuartz;
import buildcraft.transport.pipes.PipePowerStone;
import buildcraft.transport.pipes.PipePowerWood;
import buildcraft.transport.pipes.PipeStructureCobblestone;
import buildcraft.transport.recipes.AdvancedFacadeRecipe;
import buildcraft.transport.recipes.GateExpansionRecipe;
import buildcraft.transport.recipes.GateLogicSwapRecipe;
import buildcraft.transport.schematics.BptItemPipeFilters;
import buildcraft.transport.schematics.BptPipeIron;
import buildcraft.transport.schematics.BptPipeWooden;
import buildcraft.transport.schematics.SchematicPipe;
import buildcraft.transport.statements.ActionEnergyPulsar;
import buildcraft.transport.statements.ActionExtractionPreset;
import buildcraft.transport.statements.ActionParameterSignal;
import buildcraft.transport.statements.ActionPipeColor;
import buildcraft.transport.statements.ActionPipeDirection;
import buildcraft.transport.statements.ActionPowerLimiter;
import buildcraft.transport.statements.ActionRedstoneFaderOutput;
import buildcraft.transport.statements.ActionSignalOutput;
import buildcraft.transport.statements.ActionSingleEnergyPulse;
import buildcraft.transport.statements.ActionValve;
import buildcraft.transport.statements.TriggerClockTimer;
import buildcraft.transport.statements.TriggerParameterSignal;
import buildcraft.transport.statements.TriggerPipeContents;
import buildcraft.transport.statements.TriggerPipeSignal;
import buildcraft.transport.statements.TriggerRedstoneFaderInput;
import buildcraft.transport.stripes.StripesHandlerArrow;
import buildcraft.transport.stripes.StripesHandlerBucket;
import buildcraft.transport.stripes.StripesHandlerRightClick;
import buildcraft.transport.stripes.StripesHandlerShears;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import io.netty.channel.ChannelHandler;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;

@Mod(version="6.1.5", modid="BuildCraft|Transport", name="Buildcraft Transport", dependencies="required-after:BuildCraft|Core@6.1.5")
public class BuildCraftTransport
extends BuildCraftMod {
    @Mod.Instance(value="BuildCraft|Transport")
    public static BuildCraftTransport instance;
    public static float pipeDurability;
    public static int pipeFluidsBaseFlowRate;
    public static BlockGenericPipe genericPipeBlock;
    public static BlockFilteredBuffer filteredBufferBlock;
    public static Item pipeWaterproof;
    public static Item pipeGate;
    public static Item pipeWire;
    public static Item plugItem;
    public static Item robotStationItem;
    public static Item pipeStructureCobblestone;
    public static Item gateCopier;
    public static ItemFacade facadeItem;
    public static Item pipeItemsWood;
    public static Item pipeItemsEmerald;
    public static Item pipeItemsStone;
    public static Item pipeItemsCobblestone;
    public static Item pipeItemsIron;
    public static Item pipeItemsQuartz;
    public static Item pipeItemsGold;
    public static Item pipeItemsDiamond;
    public static Item pipeItemsObsidian;
    public static Item pipeItemsLapis;
    public static Item pipeItemsDaizuli;
    public static Item pipeItemsVoid;
    public static Item pipeItemsSandstone;
    public static Item pipeItemsEmzuli;
    public static Item pipeItemsStripes;
    public static Item pipeFluidsWood;
    public static Item pipeFluidsCobblestone;
    public static Item pipeFluidsStone;
    public static Item pipeFluidsQuartz;
    public static Item pipeFluidsIron;
    public static Item pipeFluidsGold;
    public static Item pipeFluidsVoid;
    public static Item pipeFluidsSandstone;
    public static Item pipeFluidsEmerald;
    public static Item pipePowerWood;
    public static Item pipePowerCobblestone;
    public static Item pipePowerStone;
    public static Item pipePowerQuartz;
    public static Item pipePowerIron;
    public static Item pipePowerGold;
    public static Item pipePowerDiamond;
    public static Item pipePowerEmerald;
    public static int groupItemsTrigger;
    public static String[] facadeBlacklist;
    public static ITriggerInternal[] triggerPipe;
    public static ITriggerInternal[] triggerPipeWireActive;
    public static ITriggerInternal[] triggerPipeWireInactive;
    public static ITriggerInternal[] triggerTimer;
    public static ITriggerInternal[] triggerRedstoneLevel;
    public static IActionInternal[] actionPipeWire;
    public static IActionInternal actionEnergyPulser;
    public static IActionInternal actionSingleEnergyPulse;
    public static IActionInternal[] actionPipeColor;
    public static IActionInternal[] actionPipeDirection;
    public static IActionInternal[] actionPowerLimiter;
    public static IActionInternal[] actionRedstoneLevel;
    public static IActionInternal actionExtractionPresetRed;
    public static IActionInternal actionExtractionPresetBlue;
    public static IActionInternal actionExtractionPresetGreen;
    public static IActionInternal actionExtractionPresetYellow;
    public static IActionInternal[] actionValve;
    public static boolean debugPrintFacadeList;
    private static LinkedList<PipeRecipe> pipeRecipes;
    public IIconProvider pipeIconProvider = new PipeIconProvider();
    public IIconProvider wireIconProvider = new WireIconProvider();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        try {
            Property exclusionFluidList;
            String[] excludedFluidBlocks;
            Property durability = BuildCraftCore.mainConfiguration.get("general", "pipes.durability", DefaultProps.PIPES_DURABILITY);
            durability.comment = "How long a pipe will take to break";
            pipeDurability = (float)durability.getDouble(DefaultProps.PIPES_DURABILITY);
            Property baseFlowRate = BuildCraftCore.mainConfiguration.get("general", "pipes.fluids.baseFlowRate", DefaultProps.PIPES_FLUIDS_BASE_FLOW_RATE);
            pipeFluidsBaseFlowRate = baseFlowRate.getInt();
            Property printFacadeList = BuildCraftCore.mainConfiguration.get("debug", "facades.printFacadeList", false);
            debugPrintFacadeList = printFacadeList.getBoolean();
            Property exclusionItemList = BuildCraftCore.mainConfiguration.get("general", "woodenPipe.item.exclusion", new String[0]);
            String[] excludedItemBlocks = exclusionItemList.getStringList();
            if (excludedItemBlocks != null) {
                for (int j = 0; j < excludedItemBlocks.length; ++j) {
                    excludedItemBlocks[j] = excludedItemBlocks[j].trim();
                }
            } else {
                excludedItemBlocks = new String[]{};
            }
            if ((excludedFluidBlocks = (exclusionFluidList = BuildCraftCore.mainConfiguration.get("general", "woodenPipe.liquid.exclusion", new String[0])).getStringList()) != null) {
                for (int j = 0; j < excludedFluidBlocks.length; ++j) {
                    excludedFluidBlocks[j] = excludedFluidBlocks[j].trim();
                }
            } else {
                excludedFluidBlocks = new String[]{};
            }
            filteredBufferBlock = new BlockFilteredBuffer();
            CoreProxy.proxy.registerBlock(filteredBufferBlock.func_149663_c("filteredBufferBlock"));
            PipeManager.registerExtractionHandler(new ExtractionHandler(excludedItemBlocks, excludedFluidBlocks));
            GateExpansions.registerExpansion(GateExpansionPulsar.INSTANCE);
            GateExpansions.registerExpansion(GateExpansionTimer.INSTANCE);
            GateExpansions.registerExpansion(GateExpansionRedstoneFader.INSTANCE);
            Property groupItemsTriggerProp = BuildCraftCore.mainConfiguration.get("general", "pipes.groupItemsTrigger", 32);
            groupItemsTriggerProp.comment = "when reaching this amount of objects in a pipes, items will be automatically grouped";
            groupItemsTrigger = groupItemsTriggerProp.getInt();
            Property facadeBlacklistProp = BuildCraftCore.mainConfiguration.get("general", "facade.blacklist", new String[]{Block.field_149771_c.func_148750_c((Object)Blocks.field_150357_h), Block.field_149771_c.func_148750_c((Object)Blocks.field_150483_bI), Block.field_149771_c.func_148750_c((Object)Blocks.field_150378_br), Block.field_149771_c.func_148750_c((Object)Blocks.field_150349_c), Block.field_149771_c.func_148750_c((Object)Blocks.field_150362_t), Block.field_149771_c.func_148750_c((Object)Blocks.field_150361_u), Block.field_149771_c.func_148750_c((Object)Blocks.field_150428_aP), Block.field_149771_c.func_148750_c((Object)Blocks.field_150374_bv), Block.field_149771_c.func_148750_c((Object)Blocks.field_150474_ac), Block.field_149771_c.func_148750_c((Object)Blocks.field_150418_aU), Block.field_149771_c.func_148750_c((Object)Blocks.field_150379_bu), Block.field_149771_c.func_148750_c((Object)Blocks.field_150334_T), Block.field_149771_c.func_148750_c((Object)Blocks.field_150373_bw), Block.field_149771_c.func_148750_c((Object)Blocks.field_150360_v), JavaTools.surroundWithQuotes(Block.field_149771_c.func_148750_c((Object)BuildCraftBuilders.architectBlock)), JavaTools.surroundWithQuotes(Block.field_149771_c.func_148750_c((Object)BuildCraftBuilders.builderBlock)), JavaTools.surroundWithQuotes(Block.field_149771_c.func_148750_c((Object)BuildCraftBuilders.fillerBlock)), JavaTools.surroundWithQuotes(Block.field_149771_c.func_148750_c((Object)BuildCraftBuilders.libraryBlock)), JavaTools.surroundWithQuotes(Block.field_149771_c.func_148750_c((Object)BuildCraftFactory.autoWorkbenchBlock)), JavaTools.surroundWithQuotes(Block.field_149771_c.func_148750_c((Object)BuildCraftFactory.floodGateBlock)), JavaTools.surroundWithQuotes(Block.field_149771_c.func_148750_c((Object)BuildCraftFactory.miningWellBlock)), JavaTools.surroundWithQuotes(Block.field_149771_c.func_148750_c((Object)BuildCraftFactory.pumpBlock)), JavaTools.surroundWithQuotes(Block.field_149771_c.func_148750_c((Object)BuildCraftFactory.quarryBlock)), JavaTools.surroundWithQuotes(Block.field_149771_c.func_148750_c((Object)filteredBufferBlock))});
            facadeBlacklistProp.comment = "Blocks listed here will not have facades created. The format is modid:blockname.\nFor mods with a | character, the value needs to be surrounded with quotes.";
            facadeBlacklist = facadeBlacklistProp.getStringList();
            pipeWaterproof = new ItemBuildCraft();
            pipeWaterproof.func_77655_b("pipeWaterproof");
            CoreProxy.proxy.registerItem(pipeWaterproof);
            if (Loader.isModLoaded((String)"BuildCraft|Compat")) {
                try {
                    genericPipeBlock = (BlockGenericPipe)((Object)this.getClass().getClassLoader().loadClass("buildcraft.transport.BlockGenericPipeCompat").newInstance());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    genericPipeBlock = new BlockGenericPipe();
                }
            } else {
                genericPipeBlock = new BlockGenericPipe();
            }
            CoreProxy.proxy.registerBlock(genericPipeBlock.func_149663_c("pipeBlock"), ItemBlock.class);
            pipeItemsWood = BuildCraftTransport.buildPipe(PipeItemsWood.class, "Wooden Transport Pipe", CreativeTabBuildCraft.PIPES, "plankWood", Blocks.field_150359_w, "plankWood");
            pipeItemsEmerald = BuildCraftTransport.buildPipe(PipeItemsEmerald.class, "Emerald Transport Pipe", CreativeTabBuildCraft.PIPES, Items.field_151166_bC, Blocks.field_150359_w, Items.field_151166_bC);
            pipeItemsCobblestone = BuildCraftTransport.buildPipe(PipeItemsCobblestone.class, "Cobblestone Transport Pipe", CreativeTabBuildCraft.PIPES, "cobblestone", Blocks.field_150359_w, "cobblestone");
            pipeItemsStone = BuildCraftTransport.buildPipe(PipeItemsStone.class, "Stone Transport Pipe", CreativeTabBuildCraft.PIPES, "stone", Blocks.field_150359_w, "stone");
            pipeItemsQuartz = BuildCraftTransport.buildPipe(PipeItemsQuartz.class, "Quartz Transport Pipe", CreativeTabBuildCraft.PIPES, Blocks.field_150371_ca, Blocks.field_150359_w, Blocks.field_150371_ca);
            pipeItemsIron = BuildCraftTransport.buildPipe(PipeItemsIron.class, "Iron Transport Pipe", CreativeTabBuildCraft.PIPES, Items.field_151042_j, Blocks.field_150359_w, Items.field_151042_j);
            pipeItemsGold = BuildCraftTransport.buildPipe(PipeItemsGold.class, "Golden Transport Pipe", CreativeTabBuildCraft.PIPES, Items.field_151043_k, Blocks.field_150359_w, Items.field_151043_k);
            pipeItemsDiamond = BuildCraftTransport.buildPipe(PipeItemsDiamond.class, "Diamond Transport Pipe", CreativeTabBuildCraft.PIPES, Items.field_151045_i, Blocks.field_150359_w, Items.field_151045_i);
            pipeItemsObsidian = BuildCraftTransport.buildPipe(PipeItemsObsidian.class, "Obsidian Transport Pipe", CreativeTabBuildCraft.PIPES, Blocks.field_150343_Z, Blocks.field_150359_w, Blocks.field_150343_Z);
            pipeItemsLapis = BuildCraftTransport.buildPipe(PipeItemsLapis.class, "Lapis Transport Pipe", CreativeTabBuildCraft.PIPES, Blocks.field_150368_y, Blocks.field_150359_w, Blocks.field_150368_y);
            pipeItemsDaizuli = BuildCraftTransport.buildPipe(PipeItemsDaizuli.class, "Daizuli Transport Pipe", CreativeTabBuildCraft.PIPES, Blocks.field_150368_y, Blocks.field_150359_w, Items.field_151045_i);
            pipeItemsSandstone = BuildCraftTransport.buildPipe(PipeItemsSandstone.class, "Sandstone Transport Pipe", CreativeTabBuildCraft.PIPES, Blocks.field_150322_A, Blocks.field_150359_w, Blocks.field_150322_A);
            pipeItemsVoid = BuildCraftTransport.buildPipe(PipeItemsVoid.class, "Void Transport Pipe", CreativeTabBuildCraft.PIPES, "dyeBlack", Blocks.field_150359_w, Items.field_151137_ax);
            pipeItemsEmzuli = BuildCraftTransport.buildPipe(PipeItemsEmzuli.class, "Emzuli Transport Pipe", CreativeTabBuildCraft.PIPES, Blocks.field_150368_y, Blocks.field_150359_w, Items.field_151166_bC);
            pipeItemsStripes = BuildCraftTransport.buildPipe(PipeItemsStripes.class, "Stripes Transport Pipe", CreativeTabBuildCraft.PIPES, BuildCraftCore.goldGearItem, Blocks.field_150359_w, BuildCraftCore.goldGearItem);
            pipeFluidsWood = BuildCraftTransport.buildPipe(PipeFluidsWood.class, "Wooden Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsWood);
            pipeFluidsCobblestone = BuildCraftTransport.buildPipe(PipeFluidsCobblestone.class, "Cobblestone Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsCobblestone);
            pipeFluidsStone = BuildCraftTransport.buildPipe(PipeFluidsStone.class, "Stone Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsStone);
            pipeFluidsQuartz = BuildCraftTransport.buildPipe(PipeFluidsQuartz.class, "Quartz Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsQuartz);
            pipeFluidsIron = BuildCraftTransport.buildPipe(PipeFluidsIron.class, "Iron Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsIron);
            pipeFluidsGold = BuildCraftTransport.buildPipe(PipeFluidsGold.class, "Golden Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsGold);
            pipeFluidsEmerald = BuildCraftTransport.buildPipe(PipeFluidsEmerald.class, "Emerald Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsEmerald);
            pipeFluidsSandstone = BuildCraftTransport.buildPipe(PipeFluidsSandstone.class, "Sandstone Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsSandstone);
            pipeFluidsVoid = BuildCraftTransport.buildPipe(PipeFluidsVoid.class, "Void Waterproof Pipe", CreativeTabBuildCraft.PIPES, pipeWaterproof, pipeItemsVoid);
            pipePowerWood = BuildCraftTransport.buildPipe(PipePowerWood.class, "Wooden Kinesis Pipe", CreativeTabBuildCraft.PIPES, Items.field_151137_ax, pipeItemsWood);
            pipePowerCobblestone = BuildCraftTransport.buildPipe(PipePowerCobblestone.class, "Cobblestone Kinesis Pipe", CreativeTabBuildCraft.PIPES, Items.field_151137_ax, pipeItemsCobblestone);
            pipePowerStone = BuildCraftTransport.buildPipe(PipePowerStone.class, "Stone Kinesis Pipe", CreativeTabBuildCraft.PIPES, Items.field_151137_ax, pipeItemsStone);
            pipePowerQuartz = BuildCraftTransport.buildPipe(PipePowerQuartz.class, "Quartz Kinesis Pipe", CreativeTabBuildCraft.PIPES, Items.field_151137_ax, pipeItemsQuartz);
            pipePowerIron = BuildCraftTransport.buildPipe(PipePowerIron.class, "Iron Kinesis Pipe", CreativeTabBuildCraft.PIPES, Items.field_151137_ax, pipeItemsIron);
            pipePowerGold = BuildCraftTransport.buildPipe(PipePowerGold.class, "Golden Kinesis Pipe", CreativeTabBuildCraft.PIPES, Items.field_151137_ax, pipeItemsGold);
            pipePowerDiamond = BuildCraftTransport.buildPipe(PipePowerDiamond.class, "Diamond Kinesis Pipe", CreativeTabBuildCraft.PIPES, Items.field_151137_ax, pipeItemsDiamond);
            pipePowerEmerald = BuildCraftTransport.buildPipe(PipePowerEmerald.class, "Emerald Kinesis Pipe", CreativeTabBuildCraft.PIPES, Items.field_151137_ax, pipeItemsEmerald);
            pipeStructureCobblestone = BuildCraftTransport.buildPipe(PipeStructureCobblestone.class, "Cobblestone Structure Pipe", CreativeTabBuildCraft.PIPES, Blocks.field_150351_n, pipeItemsCobblestone);
            pipeWire = new ItemPipeWire();
            CoreProxy.proxy.registerItem(pipeWire);
            PipeWire.item = pipeWire;
            pipeGate = new ItemGate();
            pipeGate.func_77655_b("pipeGate");
            CoreProxy.proxy.registerItem(pipeGate);
            facadeItem = new ItemFacade();
            facadeItem.func_77655_b("pipeFacade");
            CoreProxy.proxy.registerItem(facadeItem);
            plugItem = new ItemPlug();
            plugItem.func_77655_b("pipePlug");
            CoreProxy.proxy.registerItem(plugItem);
            robotStationItem = new ItemRobotStation();
            robotStationItem.func_77655_b("robotStation");
            CoreProxy.proxy.registerItem(robotStationItem);
            gateCopier = new ItemGateCopier();
            CoreProxy.proxy.registerItem(gateCopier);
            for (TriggerPipeContents.PipeContents pipeContents : TriggerPipeContents.PipeContents.values()) {
                BuildCraftTransport.triggerPipe[pipeContents.ordinal()] = new TriggerPipeContents(pipeContents);
            }
            for (Enum enum_ : PipeWire.values()) {
                BuildCraftTransport.triggerPipeWireActive[enum_.ordinal()] = new TriggerPipeSignal(true, (PipeWire)enum_);
                BuildCraftTransport.triggerPipeWireInactive[enum_.ordinal()] = new TriggerPipeSignal(false, (PipeWire)enum_);
                BuildCraftTransport.actionPipeWire[enum_.ordinal()] = new ActionSignalOutput((PipeWire)enum_);
            }
            for (Enum enum_ : TriggerClockTimer.Time.VALUES) {
                BuildCraftTransport.triggerTimer[enum_.ordinal()] = new TriggerClockTimer((TriggerClockTimer.Time)enum_);
            }
            for (int level = 0; level < triggerRedstoneLevel.length; ++level) {
                BuildCraftTransport.triggerRedstoneLevel[level] = new TriggerRedstoneFaderInput(level + 1);
                BuildCraftTransport.actionRedstoneLevel[level] = new ActionRedstoneFaderOutput(level + 1);
            }
            for (EnumColor enumColor : EnumColor.VALUES) {
                BuildCraftTransport.actionPipeColor[enumColor.ordinal()] = new ActionPipeColor(enumColor);
            }
            for (EnumColor enumColor : ForgeDirection.VALID_DIRECTIONS) {
                BuildCraftTransport.actionPipeDirection[enumColor.ordinal()] = new ActionPipeDirection((ForgeDirection)enumColor);
            }
            for (Enum enum_ : ActionValve.ValveState.VALUES) {
                BuildCraftTransport.actionValve[enum_.ordinal()] = new ActionValve((ActionValve.ValveState)enum_);
            }
            for (Enum enum_ : PowerMode.VALUES) {
                BuildCraftTransport.actionPowerLimiter[enum_.ordinal()] = new ActionPowerLimiter((PowerMode)enum_);
            }
        }
        finally {
            BuildCraftCore.mainConfiguration.save();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-TRANSPORT", new ChannelHandler[]{new BuildCraftChannelHandler(), new PacketHandlerTransport()});
        TransportProxy.proxy.registerTileEntities();
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)genericPipeBlock, SchematicPipe.class, new Object[0]);
        new BptPipeIron(pipeItemsIron);
        new BptPipeIron(pipeFluidsIron);
        new BptPipeIron(pipePowerIron);
        new BptPipeWooden(pipeItemsWood);
        new BptPipeWooden(pipeFluidsWood);
        new BptPipeWooden(pipePowerWood);
        new BptPipeWooden(pipeItemsEmerald);
        new BptItemPipeFilters(pipeItemsDiamond);
        StatementManager.registerParameterClass(TriggerParameterSignal.class);
        StatementManager.registerParameterClass(ActionParameterSignal.class);
        StatementManager.registerTriggerProvider(new PipeTriggerProvider());
        StatementManager.registerActionProvider(new PipeActionProvider());
        PipeManager.registerStripesHandler(new StripesHandlerRightClick());
        PipeManager.registerStripesHandler(new StripesHandlerBucket());
        PipeManager.registerStripesHandler(new StripesHandlerArrow());
        PipeManager.registerStripesHandler(new StripesHandlerShears());
        if (BuildCraftCore.loadDefaultRecipes) {
            this.loadRecipes();
        }
        TransportProxy.proxy.registerRenderers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        facadeItem.initialize();
        if (debugPrintFacadeList) {
            try {
                PrintWriter writer = new PrintWriter("FacadeDebug.txt", "UTF-8");
                writer.println("*** REGISTERED FACADES ***");
                for (ItemStack stack : ItemFacade.allFacades) {
                    if (facadeItem.getBlocksForFacade(stack).length <= 0) continue;
                    writer.println(Block.field_149771_c.func_148750_c((Object)facadeItem.getBlocksForFacade(stack)[0]) + ":" + facadeItem.getMetaValuesForFacade(stack)[0]);
                }
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void loadRecipes() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(pipeWaterproof, 1), (Object[])new Object[]{new ItemStack(Items.field_151100_aR, 1, 2)});
        for (PipeRecipe pipe : pipeRecipes) {
            if (pipe.isShapeless) {
                CoreProxy.proxy.addShapelessRecipe(pipe.result, pipe.input);
                continue;
            }
            CoreProxy.proxy.addCraftingRecipe(pipe.result, pipe.input);
        }
        GameRegistry.addRecipe((IRecipe)new PipeColoringRecipe());
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)filteredBufferBlock, 1), "wdw", "wcw", "wpw", Character.valueOf('w'), "plankWood", Character.valueOf('d'), pipeItemsDiamond, Character.valueOf('c'), Blocks.field_150486_ae, Character.valueOf('p'), Blocks.field_150331_J);
        GameRegistry.addRecipe((IRecipe)new ItemFacade.FacadeRecipe(facadeItem));
        RecipeSorter.register((String)"facadeTurningHelper", ItemFacade.FacadeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:pipePlug", 10000, new ItemStack(plugItem, 8), new ItemStack(pipeStructureCobblestone));
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(robotStationItem), "   ", " I ", "ICI", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('C'), ItemRedstoneChipset.Chipset.GOLD.getStack());
        if (Loader.isModLoaded((String)"BuildCraft|Silicon")) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(gateCopier, 1), (Object[])new Object[]{new ItemStack(BuildCraftCore.wrenchItem), ItemRedstoneChipset.Chipset.RED.getStack(1)});
            BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:redWire", 5000, PipeWire.RED.getStack(8), OreDictionary.getOres((String)"dyeRed"), Items.field_151137_ax, Items.field_151042_j);
            BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:blueWire", 5000, PipeWire.BLUE.getStack(8), OreDictionary.getOres((String)"dyeBlue"), Items.field_151137_ax, Items.field_151042_j);
            BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:greenWire", 5000, PipeWire.GREEN.getStack(8), OreDictionary.getOres((String)"dyeGreen"), Items.field_151137_ax, Items.field_151042_j);
            BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:yellowWire", 5000, PipeWire.YELLOW.getStack(8), OreDictionary.getOres((String)"dyeYellow"), Items.field_151137_ax, Items.field_151042_j);
            BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:simpleGate", 100000, ItemGate.makeGateItem(GateDefinition.GateMaterial.REDSTONE, GateDefinition.GateLogic.AND), ItemRedstoneChipset.Chipset.RED.getStack(), PipeWire.RED.getStack());
            BuildCraftTransport.addGateRecipe("Iron", 200000, GateDefinition.GateMaterial.IRON, ItemRedstoneChipset.Chipset.IRON, PipeWire.RED, PipeWire.BLUE);
            BuildCraftTransport.addGateRecipe("Gold", 400000, GateDefinition.GateMaterial.GOLD, ItemRedstoneChipset.Chipset.GOLD, PipeWire.RED, PipeWire.BLUE, PipeWire.GREEN);
            BuildCraftTransport.addGateRecipe("Diamond", 800000, GateDefinition.GateMaterial.DIAMOND, ItemRedstoneChipset.Chipset.DIAMOND, PipeWire.RED, PipeWire.BLUE, PipeWire.GREEN, PipeWire.YELLOW);
            BuildCraftTransport.addGateRecipe("Emerald", 1200000, GateDefinition.GateMaterial.EMERALD, ItemRedstoneChipset.Chipset.DIAMOND, PipeWire.RED, PipeWire.BLUE, PipeWire.GREEN, PipeWire.YELLOW);
            BuildcraftRecipeRegistry.integrationTable.addRecipe(new GateLogicSwapRecipe("buildcraft:gateSwap"));
            BuildcraftRecipeRegistry.integrationTable.addRecipe(new GateExpansionRecipe("buildcraft:expansionPulsar", GateExpansionPulsar.INSTANCE, ItemRedstoneChipset.Chipset.PULSATING.getStack()));
            BuildcraftRecipeRegistry.integrationTable.addRecipe(new GateExpansionRecipe("buildcraft:expansionQuartz", GateExpansionTimer.INSTANCE, ItemRedstoneChipset.Chipset.QUARTZ.getStack()));
            BuildcraftRecipeRegistry.integrationTable.addRecipe(new GateExpansionRecipe("buildcraft:expansionComp", GateExpansionRedstoneFader.INSTANCE, ItemRedstoneChipset.Chipset.COMP.getStack()));
            BuildcraftRecipeRegistry.integrationTable.addRecipe(new AdvancedFacadeRecipe("buildcraft:advancedFacade"));
        }
    }

    private static void addGateRecipe(String materialName, int energyCost, GateDefinition.GateMaterial material, ItemRedstoneChipset.Chipset chipset, PipeWire ... pipeWire) {
        ArrayList<ItemStack> temp = new ArrayList<ItemStack>();
        temp.add(chipset.getStack());
        for (PipeWire wire : pipeWire) {
            temp.add(wire.getStack());
        }
        Object[] inputs = temp.toArray();
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:andGate" + materialName, energyCost, ItemGate.makeGateItem(material, GateDefinition.GateLogic.AND), inputs);
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:orGate" + materialName, energyCost, ItemGate.makeGateItem(material, GateDefinition.GateLogic.OR), inputs);
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    public static Item buildPipe(Class<? extends Pipe> clas, String descr, CreativeTabBuildCraft creativeTab, Object ... ingredients) {
        ItemPipe res;
        block4: {
            block3: {
                res = BlockGenericPipe.registerPipe(clas, creativeTab);
                res.func_77655_b(clas.getSimpleName());
                if (ingredients.length != 3) break block3;
                for (int i = 0; i < 17; ++i) {
                    PipeRecipe recipe = new PipeRecipe();
                    ItemStack glass = i == 0 ? new ItemStack(Blocks.field_150359_w) : new ItemStack((Block)Blocks.field_150399_cn, 1, i - 1);
                    recipe.result = new ItemStack((Item)res, 8, i);
                    recipe.input = new Object[]{"ABC", Character.valueOf('A'), ingredients[0], Character.valueOf('B'), glass, Character.valueOf('C'), ingredients[2]};
                    pipeRecipes.add(recipe);
                }
                break block4;
            }
            if (ingredients.length != 2) break block4;
            for (int i = 0; i < 17; ++i) {
                PipeRecipe recipe = new PipeRecipe();
                Object left = ingredients[0];
                Object right = ingredients[1];
                if (ingredients[1] instanceof ItemPipe) {
                    right = new ItemStack((Item)right, 1, i);
                }
                recipe.isShapeless = true;
                recipe.result = new ItemStack((Item)res, 1, i);
                recipe.input = new Object[]{left, right};
                pipeRecipes.add(recipe);
                if (!(ingredients[1] instanceof ItemPipe)) continue;
                PipeRecipe uncraft = new PipeRecipe();
                uncraft.isShapeless = true;
                uncraft.input = new Object[]{recipe.result};
                uncraft.result = (ItemStack)right;
                pipeRecipes.add(uncraft);
            }
        }
        return res;
    }

    @Mod.EventHandler
    public void whiteListAppliedEnergetics(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileGenericPipe.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileFilteredBuffer.class.getCanonicalName());
    }

    static {
        triggerPipe = new ITriggerInternal[TriggerPipeContents.PipeContents.values().length];
        triggerPipeWireActive = new ITriggerInternal[PipeWire.values().length];
        triggerPipeWireInactive = new ITriggerInternal[PipeWire.values().length];
        triggerTimer = new ITriggerInternal[TriggerClockTimer.Time.VALUES.length];
        triggerRedstoneLevel = new ITriggerInternal[15];
        actionPipeWire = new ActionSignalOutput[PipeWire.values().length];
        actionEnergyPulser = new ActionEnergyPulsar();
        actionSingleEnergyPulse = new ActionSingleEnergyPulse();
        actionPipeColor = new IActionInternal[16];
        actionPipeDirection = new IActionInternal[16];
        actionPowerLimiter = new IActionInternal[7];
        actionRedstoneLevel = new IActionInternal[15];
        actionExtractionPresetRed = new ActionExtractionPreset(EnumColor.RED);
        actionExtractionPresetBlue = new ActionExtractionPreset(EnumColor.BLUE);
        actionExtractionPresetGreen = new ActionExtractionPreset(EnumColor.GREEN);
        actionExtractionPresetYellow = new ActionExtractionPreset(EnumColor.YELLOW);
        actionValve = new IActionInternal[4];
        debugPrintFacadeList = false;
        pipeRecipes = new LinkedList();
    }

    private static class ExtractionHandler
    implements IExtractionHandler {
        private final String[] items;
        private final String[] liquids;

        public ExtractionHandler(String[] items, String[] liquids) {
            this.items = items;
            this.liquids = liquids;
        }

        @Override
        public boolean canExtractItems(Object extractor, World world, int i, int j, int k) {
            return this.testStrings(this.items, world, i, j, k);
        }

        @Override
        public boolean canExtractFluids(Object extractor, World world, int i, int j, int k) {
            return this.testStrings(this.liquids, world, i, j, k);
        }

        private boolean testStrings(String[] excludedBlocks, World world, int i, int j, int k) {
            Block block = world.func_147439_a(i, j, k);
            return block != null;
        }
    }

    private static class PipeRecipe {
        boolean isShapeless = false;
        ItemStack result;
        Object[] input;

        private PipeRecipe() {
        }
    }
}

