/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.core.JavaTools;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class SchematicTile
extends SchematicBlock {
    public NBTTagCompound tileNBT = new NBTTagCompound();

    @Override
    public void idsToBlueprint(MappingRegistry registry) {
        registry.scanAndTranslateStacksToRegistry(this.tileNBT);
    }

    @Override
    public void idsToWorld(MappingRegistry registry) {
        try {
            registry.scanAndTranslateStacksToWorld(this.tileNBT);
        }
        catch (MappingNotFoundException e) {
            this.tileNBT = new NBTTagCompound();
        }
    }

    @Override
    public void placeInWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
        super.placeInWorld(context, x, y, z, stacks);
        if (this.block.hasTileEntity(this.meta)) {
            TileEntity tile = context.world().func_147438_o(x, y, z);
            this.tileNBT.func_74768_a("x", x);
            this.tileNBT.func_74768_a("y", y);
            this.tileNBT.func_74768_a("z", z);
            if (tile != null) {
                tile.func_145839_a(this.tileNBT);
            }
        }
    }

    @Override
    public void initializeFromObjectAt(IBuilderContext context, int x, int y, int z) {
        TileEntity tile;
        super.initializeFromObjectAt(context, x, y, z);
        if (this.block.hasTileEntity(this.meta) && (tile = context.world().func_147438_o(x, y, z)) != null) {
            tile.func_145841_b(this.tileNBT);
        }
    }

    @Override
    public void storeRequirements(IBuilderContext context, int x, int y, int z) {
        TileEntity tile;
        super.storeRequirements(context, x, y, z);
        if (this.block.hasTileEntity(this.meta) && (tile = context.world().func_147438_o(x, y, z)) instanceof IInventory) {
            IInventory inv = (IInventory)tile;
            ArrayList<ItemStack> rqs = new ArrayList<ItemStack>();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i) == null) continue;
                rqs.add(inv.func_70301_a(i));
            }
            this.storedRequirements = JavaTools.concat(this.storedRequirements, rqs.toArray(new ItemStack[rqs.size()]));
        }
    }

    @Override
    public void writeSchematicToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.writeSchematicToNBT(nbt, registry);
        nbt.func_74782_a("blockCpt", (NBTBase)this.tileNBT);
    }

    @Override
    public void readSchematicFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.readSchematicFromNBT(nbt, registry);
        this.tileNBT = nbt.func_74775_l("blockCpt");
    }

    @Override
    public int buildTime() {
        return 5;
    }
}

