/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.core;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JavaTools {
    public static double bounds(double value, double min, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static int[] concat(int[] first, int[] second) {
        int[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static float[] concat(float[] first, float[] second) {
        float[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public <T> T[] concatenate(T[] a, T[] b) {
        int aLen = a.length;
        int bLen = b.length;
        Object[] c = (Object[])Array.newInstance(a.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public static List<Field> getAllFields(Class<?> clas) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> current = clas; current != null && current != Object.class; current = current.getSuperclass()) {
            for (Field f : current.getDeclaredFields()) {
                result.add(f);
            }
        }
        return result;
    }

    public static List<Method> getAllMethods(Class<?> clas) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> current = clas; current != null && current != Object.class; current = current.getSuperclass()) {
            for (Method m : current.getDeclaredMethods()) {
                result.add(m);
            }
        }
        return result;
    }

    public static String surroundWithQuotes(String stringToSurroundWithQuotes) {
        return String.format("\"%s\"", stringToSurroundWithQuotes);
    }

    public static String stripSurroundingQuotes(String stringToStripQuotes) {
        return stringToStripQuotes.replaceAll("^\"|\"$", "");
    }
}

