/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.core;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class WorldBlockIndex
implements Comparable<WorldBlockIndex> {
    public int x;
    public int y;
    public int z;
    public int dimension;

    public WorldBlockIndex() {
    }

    public WorldBlockIndex(World world, int x, int y, int z) {
        this.dimension = world.field_73011_w.field_76574_g;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public WorldBlockIndex(NBTTagCompound c) {
        this.dimension = c.func_74762_e("dimension");
        this.x = c.func_74762_e("x");
        this.y = c.func_74762_e("y");
        this.z = c.func_74762_e("z");
    }

    public WorldBlockIndex(Entity entity) {
        this.dimension = entity.field_70170_p.field_73011_w.field_76574_g;
        this.x = (int)Math.floor(entity.field_70165_t);
        this.y = (int)Math.floor(entity.field_70163_u);
        this.z = (int)Math.floor(entity.field_70161_v);
    }

    @Override
    public int compareTo(WorldBlockIndex o) {
        if (o.dimension < this.dimension) {
            return 1;
        }
        if (o.dimension > this.dimension) {
            return -1;
        }
        if (o.x < this.x) {
            return 1;
        }
        if (o.x > this.x) {
            return -1;
        }
        if (o.z < this.z) {
            return 1;
        }
        if (o.z > this.z) {
            return -1;
        }
        if (o.y < this.y) {
            return 1;
        }
        if (o.y > this.y) {
            return -1;
        }
        return 0;
    }

    public void writeTo(NBTTagCompound c) {
        c.func_74768_a("dimension", this.dimension);
        c.func_74768_a("x", this.x);
        c.func_74768_a("y", this.y);
        c.func_74768_a("z", this.z);
    }

    public String toString() {
        return "{" + this.dimension + ":" + this.x + ", " + this.y + ", " + this.z + "}";
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorldBlockIndex) {
            WorldBlockIndex b = (WorldBlockIndex)obj;
            return b.dimension == this.dimension && b.x == this.x && b.y == this.y && b.z == this.z;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return (this.dimension * 37 + (this.x * 37 + this.y)) * 37 + this.z;
    }
}

