/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.statements;

import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IActionProvider;
import buildcraft.api.statements.IOverrideDefaultStatements;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public final class StatementManager {
    public static Map<String, IStatement> statements = new HashMap<String, IStatement>();
    public static Map<String, Class<? extends IStatementParameter>> parameters = new HashMap<String, Class<? extends IStatementParameter>>();
    private static List<ITriggerProvider> triggerProviders = new LinkedList<ITriggerProvider>();
    private static List<IActionProvider> actionProviders = new LinkedList<IActionProvider>();

    private StatementManager() {
    }

    public static void registerTriggerProvider(ITriggerProvider provider) {
        if (provider != null && !triggerProviders.contains(provider)) {
            triggerProviders.add(provider);
        }
    }

    public static void registerActionProvider(IActionProvider provider) {
        if (provider != null && !actionProviders.contains(provider)) {
            actionProviders.add(provider);
        }
    }

    public static void registerStatement(IStatement statement) {
        statements.put(statement.getUniqueTag(), statement);
    }

    public static void registerParameterClass(Class<? extends IStatementParameter> param) {
        parameters.put(StatementManager.createParameter(param).getUniqueTag(), param);
    }

    @Deprecated
    public static void registerParameterClass(String name, Class<? extends IStatementParameter> param) {
        parameters.put(name, param);
    }

    public static List<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity entity) {
        List<ITriggerExternal> result;
        if (entity instanceof IOverrideDefaultStatements && (result = ((IOverrideDefaultStatements)entity).overrideTriggers()) != null) {
            return result;
        }
        result = new LinkedList<ITriggerExternal>();
        for (ITriggerProvider provider : triggerProviders) {
            Collection<ITriggerExternal> toAdd = provider.getExternalTriggers(side, entity);
            if (toAdd == null) continue;
            for (ITriggerExternal t : toAdd) {
                if (result.contains(t)) continue;
                result.add(t);
            }
        }
        return result;
    }

    public static List<IActionExternal> getExternalActions(ForgeDirection side, TileEntity entity) {
        LinkedList<IActionExternal> result = new LinkedList();
        if (entity instanceof IOverrideDefaultStatements && (result = ((IOverrideDefaultStatements)entity).overrideActions()) != null) {
            return result;
        }
        for (IActionProvider provider : actionProviders) {
            Collection<IActionExternal> toAdd = provider.getExternalActions(side, entity);
            if (toAdd == null) continue;
            for (IActionExternal t : toAdd) {
                if (result.contains(t)) continue;
                result.add(t);
            }
        }
        return result;
    }

    public static List<ITriggerInternal> getInternalTriggers(IStatementContainer container) {
        LinkedList<ITriggerInternal> result = new LinkedList<ITriggerInternal>();
        for (ITriggerProvider provider : triggerProviders) {
            Collection<ITriggerInternal> toAdd = provider.getInternalTriggers(container);
            if (toAdd == null) continue;
            for (ITriggerInternal t : toAdd) {
                if (result.contains(t)) continue;
                result.add(t);
            }
        }
        return result;
    }

    public static List<IActionInternal> getInternalActions(IStatementContainer container) {
        LinkedList<IActionInternal> result = new LinkedList<IActionInternal>();
        for (IActionProvider provider : actionProviders) {
            Collection<IActionInternal> toAdd = provider.getInternalActions(container);
            if (toAdd == null) continue;
            for (IActionInternal t : toAdd) {
                if (result.contains(t)) continue;
                result.add(t);
            }
        }
        return result;
    }

    public static IStatementParameter createParameter(String kind) {
        return StatementManager.createParameter(parameters.get(kind));
    }

    private static IStatementParameter createParameter(Class<? extends IStatementParameter> param) {
        try {
            return param.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IIconRegister register) {
        for (IStatement iStatement : statements.values()) {
            iStatement.registerIcons(register);
        }
        for (Class clazz : parameters.values()) {
            StatementManager.createParameter(clazz).registerIcons(register);
        }
    }
}

