/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicFluid;
import buildcraft.builders.schematics.SchematicBlockCreative;
import buildcraft.builders.schematics.SchematicTileCreative;
import buildcraft.core.blueprints.SchematicRegistry;
import java.util.BitSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public final class HeuristicBlockDetection {
    private static BitSet craftableBlockList = new BitSet(65536);

    private HeuristicBlockDetection() {
    }

    public static void start() {
        for (Fluid f : FluidRegistry.getRegisteredFluids().values()) {
            SchematicRegistry.INSTANCE.registerSchematicBlock(f.getBlock(), SchematicFluid.class, new FluidStack(f, 1000));
        }
        for (Block block : Block.field_149771_c) {
            if (block == null || block == Blocks.field_150350_a) continue;
            for (int meta = 0; meta < 16; ++meta) {
                if (SchematicRegistry.INSTANCE.isSupported(block, meta)) continue;
                if (block.hasTileEntity(meta)) {
                    SchematicRegistry.INSTANCE.registerSchematicBlock(block, meta, SchematicTileCreative.class, new Object[0]);
                    continue;
                }
                boolean creativeOnly = false;
                try {
                    if (creativeOnly) {
                        SchematicRegistry.INSTANCE.registerSchematicBlock(block, meta, SchematicBlockCreative.class, new Object[0]);
                        continue;
                    }
                    SchematicRegistry.INSTANCE.registerSchematicBlock(block, meta, SchematicBlock.class, new Object[0]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean canCraft(Block block, int meta) {
        int pos = Block.func_149682_b((Block)block) << 4 | meta;
        return craftableBlockList.get(pos);
    }
}

