/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.core.NetworkData;
import buildcraft.api.core.Position;
import buildcraft.builders.ItemBlueprint;
import buildcraft.core.Box;
import buildcraft.core.IBoxProvider;
import buildcraft.core.LaserData;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.builders.BuildingItem;
import buildcraft.core.builders.IBuildingItemsProvider;
import buildcraft.core.network.RPC;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.network.RPCMessageInfo;
import buildcraft.core.network.RPCSide;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileConstructionMarker
extends TileBuildCraft
implements IBuildingItemsProvider,
IBoxProvider {
    public static HashSet<TileConstructionMarker> currentMarkers = new HashSet();
    public ForgeDirection direction = ForgeDirection.UNKNOWN;
    @NetworkData
    public LaserData laser;
    @NetworkData
    public ItemStack itemBlueprint;
    @NetworkData
    public Box box = new Box();
    public BptBuilderBase bluePrintBuilder;
    public BptContext bptContext;
    private ArrayList<BuildingItem> buildersInAction = new ArrayList();
    private NBTTagCompound initNBT;

    @Override
    public void initialize() {
        this.box.kind = Box.Kind.BLUE_STRIPES;
        if (this.field_145850_b.field_72995_K) {
            RPCHandler.rpcServer(this, "uploadBuildersInAction", new Object[0]);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        BuildingItem toRemove = null;
        for (BuildingItem i : this.buildersInAction) {
            i.update();
            if (!i.isDone) continue;
            toRemove = i;
        }
        if (toRemove != null) {
            this.buildersInAction.remove(toRemove);
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.itemBlueprint != null && ItemBlueprint.getId(this.itemBlueprint) != null && this.bluePrintBuilder == null) {
            BlueprintBase bpt = BlueprintBase.instantiate(this.itemBlueprint, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.direction);
            this.bluePrintBuilder = new BptBuilderBlueprint((Blueprint)bpt, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.bptContext = this.bluePrintBuilder.getContext();
            this.box.initialize(this.bluePrintBuilder);
            this.sendNetworkUpdate();
        }
        if (this.laser == null && this.direction != ForgeDirection.UNKNOWN) {
            this.laser = new LaserData();
            this.laser.head = new Position((float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 0.5f, (float)this.field_145849_e + 0.5f);
            this.laser.tail = new Position((float)this.field_145851_c + 0.5f + (float)this.direction.offsetX * 0.5f, (float)this.field_145848_d + 0.5f + (float)this.direction.offsetY * 0.5f, (float)this.field_145849_e + 0.5f + (float)this.direction.offsetZ * 0.5f);
            this.laser.isVisible = true;
            this.sendNetworkUpdate();
        }
        if (this.initNBT != null) {
            if (this.bluePrintBuilder != null) {
                this.bluePrintBuilder.loadBuildStateToNBT(this.initNBT.func_74775_l("builderState"), this);
            }
            this.initNBT = null;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        NBTTagCompound bptNBT;
        super.func_145841_b(nbt);
        nbt.func_74774_a("direction", (byte)this.direction.ordinal());
        if (this.itemBlueprint != null) {
            bptNBT = new NBTTagCompound();
            this.itemBlueprint.func_77955_b(bptNBT);
            nbt.func_74782_a("itemBlueprint", (NBTBase)bptNBT);
        }
        bptNBT = new NBTTagCompound();
        if (this.bluePrintBuilder != null) {
            NBTTagCompound builderCpt = new NBTTagCompound();
            this.bluePrintBuilder.saveBuildStateToNBT(builderCpt, this);
            bptNBT.func_74782_a("builderState", (NBTBase)builderCpt);
        }
        nbt.func_74782_a("bptBuilder", (NBTBase)bptNBT);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.direction = ForgeDirection.getOrientation((int)nbt.func_74771_c("direction"));
        if (nbt.func_74764_b("itemBlueprint")) {
            this.itemBlueprint = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("itemBlueprint"));
        }
        this.initNBT = (NBTTagCompound)nbt.func_74775_l("bptBuilder").func_74737_b();
    }

    public void setBlueprint(ItemStack currentItem) {
        this.itemBlueprint = currentItem;
        this.sendNetworkUpdate();
    }

    @Override
    public ArrayList<BuildingItem> getBuilders() {
        return this.buildersInAction;
    }

    public void func_145829_t() {
        if (!this.field_145850_b.field_72995_K) {
            currentMarkers.add(this);
        }
    }

    @Override
    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            currentMarkers.remove(this);
        }
    }

    public boolean needsToBuild() {
        return this.bluePrintBuilder != null && !this.bluePrintBuilder.isDone(this);
    }

    public BptContext getContext() {
        return this.bptContext;
    }

    @Override
    public void addAndLaunchBuildingItem(BuildingItem item) {
        this.buildersInAction.add(item);
        RPCHandler.rpcBroadcastWorldPlayers(this.field_145850_b, this, "launchItem", item);
    }

    @RPC(value=RPCSide.CLIENT)
    private void launchItem(BuildingItem item) {
        this.buildersInAction.add(item);
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Box renderBox = new Box(this).extendToEncompass(this.box);
        return renderBox.expand(50).getBoundingBox();
    }

    @RPC(value=RPCSide.SERVER)
    private void uploadBuildersInAction(RPCMessageInfo info) {
        for (BuildingItem i : this.buildersInAction) {
            RPCHandler.rpcPlayer(info.sender, this, "launchItem", i);
        }
    }
}

