/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.builders.TileArchitect;
import buildcraft.builders.gui.ContainerArchitect;
import buildcraft.core.DefaultProps;
import buildcraft.core.blueprints.BlueprintReadConfiguration;
import buildcraft.core.gui.GuiBuildCraft;
import buildcraft.core.gui.buttons.GuiBetterButton;
import buildcraft.core.gui.tooltips.ToolTip;
import buildcraft.core.gui.tooltips.ToolTipLine;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.utils.StringUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiArchitect
extends GuiBuildCraft {
    private static final int TEXT_X = 90;
    private static final int TEXT_Y = 62;
    private static final int TEXT_WIDTH = 156;
    private static final int TEXT_HEIGHT = 12;
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/architect_gui.png");
    private TileArchitect architect;
    private GuiBetterButton optionRotate;
    private GuiBetterButton optionExcavate;
    private GuiBetterButton optionAllowCreative;
    private GuiTextField textField;

    public GuiArchitect(EntityPlayer player, TileArchitect architect) {
        super(new ContainerArchitect(player, architect), architect, TEXTURE);
        this.architect = architect;
        this.field_146999_f = 256;
        this.field_147000_g = 166;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.optionRotate = new GuiBetterButton(0, this.field_147003_i + 5, this.field_147009_r + 30, 79, "");
        this.field_146292_n.add(this.optionRotate);
        this.optionExcavate = new GuiBetterButton(1, this.field_147003_i + 5, this.field_147009_r + 55, 79, "");
        this.field_146292_n.add(this.optionExcavate);
        this.optionAllowCreative = new GuiBetterButton(2, this.field_147003_i + 5, this.field_147009_r + 80, 79, "");
        this.optionAllowCreative.setToolTip(new ToolTip(500, new ToolTipLine(StringUtils.localize("tile.architect.tooltip.allowCreative.1")), new ToolTipLine(StringUtils.localize("tile.architect.tooltip.allowCreative.2"))));
        this.field_146292_n.add(this.optionAllowCreative);
        this.textField = new GuiTextField(this.field_146289_q, 90, 62, 156, 12);
        this.textField.func_146203_f(32);
        this.textField.func_146180_a(this.architect.name);
        this.textField.func_146195_b(true);
        this.updateButtons();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton button) {
        BlueprintReadConfiguration conf = this.architect.readConfiguration;
        if (button == this.optionRotate) {
            conf.rotate = !conf.rotate;
        } else if (button == this.optionExcavate) {
            conf.excavate = !conf.excavate;
        } else if (button == this.optionAllowCreative) {
            conf.allowCreative = !conf.allowCreative;
        }
        this.architect.rpcSetConfiguration(conf);
        this.updateButtons();
    }

    private void updateButtons() {
        BlueprintReadConfiguration conf = this.architect.readConfiguration;
        this.optionRotate.field_146126_j = conf.rotate ? StringUtils.localize("tile.architect.rotate") : StringUtils.localize("tile.architect.norotate");
        this.optionExcavate.field_146126_j = conf.excavate ? StringUtils.localize("tile.architect.excavate") : StringUtils.localize("tile.architect.noexcavate");
        this.optionAllowCreative.field_146126_j = conf.allowCreative ? StringUtils.localize("tile.architect.allowCreative") : StringUtils.localize("tile.architect.noallowCreative");
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        String title = StringUtils.localize("tile.architectBlock.name");
        this.field_146289_q.func_78276_b(title, this.getCenteredOffset(title), 6, 0x404040);
        this.textField.func_146194_f();
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int i1 = ((ContainerArchitect)this.container).computingTime;
        this.func_73729_b(this.field_147003_i + 159, this.field_147009_r + 34, 0, 166, i1 + 1, 16);
    }

    @Override
    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        this.textField.func_146192_a(i - this.field_147003_i, j - this.field_147009_r, k);
    }

    protected void func_73869_a(char c, int i) {
        if (this.textField.func_146206_l()) {
            if (c == '\r' || c == '\u001b') {
                this.textField.func_146195_b(false);
            } else {
                this.textField.func_146201_a(c, i);
                RPCHandler.rpcServer(this.architect, "handleClientSetName", this.textField.func_146179_b());
            }
        } else {
            super.func_73869_a(c, i);
        }
    }
}

