/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.builders.TileBuilder;
import buildcraft.builders.gui.ContainerBuilder;
import buildcraft.core.DefaultProps;
import buildcraft.core.fluids.Tank;
import buildcraft.core.gui.AdvancedSlot;
import buildcraft.core.gui.GuiAdvancedInterface;
import buildcraft.core.gui.ItemSlot;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.utils.StringUtils;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiBuilder
extends GuiAdvancedInterface {
    private static final ResourceLocation BLUEPRINT_TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/builder_blueprint.png");
    private static final ResourceLocation FOREGROUND_TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/builder_foreground.png");
    private IInventory playerInventory;
    private TileBuilder builder;
    private GuiButton selectedButton;

    public GuiBuilder(IInventory playerInventory, TileBuilder builder) {
        super(new ContainerBuilder(playerInventory, builder), builder, BLUEPRINT_TEXTURE);
        this.playerInventory = playerInventory;
        this.builder = builder;
        this.field_146999_f = 176;
        this.field_147000_g = 225;
        this.resetNullSlots(24);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.slots.set(i * 4 + j, new ItemSlot(this, 179 + j * 18, 18 + i * 18));
            }
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        this.drawCenteredString(StringUtils.localize("tile.builderBlock.name"), 89, 16, 0x404040);
        this.field_146289_q.func_78276_b(StringUtils.localize("gui.building.resources"), 8, 60, 0x404040);
        this.field_146289_q.func_78276_b(StringUtils.localize("gui.inventory"), 8, this.field_147000_g - 97, 0x404040);
        this.field_146289_q.func_78276_b(StringUtils.localize("gui.needed"), 178, 7, 0x404040);
        this.field_146289_q.func_78276_b(StringUtils.localize("gui.building.fluids"), 178, 133, 0x404040);
        this.drawTooltipForSlotAt(par1, par2);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        int i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(BLUEPRINT_TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 256, this.field_147000_g);
        for (AdvancedSlot s : this.slots) {
            ((ItemSlot)s).stack = null;
        }
        Collection<ItemStack> needs = this.builder.getNeededItems();
        if (needs != null) {
            int s = 0;
            for (ItemStack stack : needs) {
                if (s >= this.slots.size()) break;
                ((ItemSlot)this.slots.get((int)s)).stack = stack.func_77946_l();
                ++s;
            }
        }
        this.drawBackgroundSlots();
        for (i = 0; i < this.builder.fluidTanks.length; ++i) {
            Tank tank = this.builder.fluidTanks[i];
            this.drawFluid(tank.getFluid(), this.field_147003_i + 179 + 18 * i, this.field_147009_r + 145, 16, 47, tank.getCapacity());
        }
        this.field_146297_k.field_71446_o.func_110577_a(FOREGROUND_TEXTURE);
        for (i = 0; i < this.builder.fluidTanks.length; ++i) {
            this.func_73729_b(this.field_147003_i + 179 + 18 * i, this.field_147009_r + 145, 0, 54, 16, 47);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (int i = 0; i < 4; ++i) {
            this.field_146292_n.add(new BuilderEraseButton(i, this.field_147003_i + 178 + 18 * i, this.field_147009_r + 197, 18, 18));
        }
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int eventType) {
        super.func_146286_b(mouseX, mouseY, eventType);
        if (this.selectedButton != null && eventType == 0) {
            this.selectedButton.func_146118_a(mouseX, mouseY);
            this.selectedButton = null;
        }
    }

    private class BuilderEraseButton
    extends GuiButton {
        private boolean clicked;

        public BuilderEraseButton(int id, int x, int y, int width, int height) {
            super(id, x, y, width, height, null);
        }

        public boolean func_146116_c(Minecraft mc, int x, int y) {
            if (super.func_146116_c(mc, x, y)) {
                GuiBuilder.this.selectedButton = this;
                this.clicked = true;
                RPCHandler.rpcServer(GuiBuilder.this.builder, "eraseFluidTank", this.field_146127_k);
                return true;
            }
            return false;
        }

        public void func_146118_a(int x, int y) {
            super.func_146118_a(x, y);
            this.clicked = false;
        }

        public void func_146112_a(Minecraft mc, int x, int y) {
            this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
            mc.field_71446_o.func_110577_a(FOREGROUND_TEXTURE);
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, (this.clicked ? 1 : (this.field_146123_n ? 2 : 0)) * 18, 18, 18);
            this.func_146119_b(mc, x, y);
        }
    }
}

