/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.commander;

import buildcraft.commander.GuiZonePlan;
import buildcraft.commander.TileZonePlan;
import buildcraft.core.BCDynamicTexture;
import buildcraft.core.ZonePlan;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.gui.slots.SlotOutput;
import buildcraft.core.network.RPC;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.network.RPCMessageInfo;
import buildcraft.core.network.RPCSide;
import net.minecraft.block.material.MapColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerZonePlan
extends BuildCraftContainer {
    public BCDynamicTexture mapTexture;
    public ZonePlan currentAreaSelection;
    public GuiZonePlan gui;
    private TileZonePlan map;

    public ContainerZonePlan(IInventory playerInventory, TileZonePlan iZonePlan) {
        super(0);
        this.map = iZonePlan;
        this.func_75146_a(new Slot((IInventory)iZonePlan, 0, 233, 20));
        this.func_75146_a(new SlotOutput(iZonePlan, 1, 233, 68));
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.func_75146_a(new Slot(playerInventory, k1 + l * 9 + 9, 88 + k1 * 18, 138 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot(playerInventory, i1, 88 + i1 * 18, 196));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void loadArea(int index) {
        RPCHandler.rpcServer((Object)this, "rpcLoadArea", index);
    }

    public void saveArea(int index) {
        RPCHandler.rpcServer((Object)this, "rpcSaveArea", index, this.currentAreaSelection);
    }

    @RPC(value=RPCSide.SERVER)
    private void rpcLoadArea(int index, RPCMessageInfo info) {
        RPCHandler.rpcPlayer(info.sender, (Object)this, "rpcAreaLoaded", this.map.selectArea(index));
    }

    @RPC(value=RPCSide.SERVER)
    private void rpcSaveArea(int index, ZonePlan area) {
        this.map.setArea(index, area);
    }

    @RPC(value=RPCSide.CLIENT)
    private void rpcAreaLoaded(ZonePlan areaSelection) {
        this.currentAreaSelection = areaSelection;
        this.gui.refreshSelectedArea();
    }

    @RPC(value=RPCSide.SERVER)
    private void computeMap(int cx, int cz, int width, int height, int blocksPerPixel, RPCMessageInfo info) {
        this.mapTexture = new BCDynamicTexture(width, height);
        int startX = cx - width * blocksPerPixel / 2;
        int startZ = cz - height * blocksPerPixel / 2;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                double r = 0.0;
                double g = 0.0;
                double b = 0.0;
                for (int stepi = 0; stepi < blocksPerPixel; ++stepi) {
                    for (int stepj = 0; stepj < blocksPerPixel; ++stepj) {
                        int x = startX + i * blocksPerPixel + stepi;
                        int z = startZ + j * blocksPerPixel + stepj;
                        int ix = x - (this.map.chunkStartX << 4);
                        int iz = z - (this.map.chunkStartZ << 4);
                        if (ix <= 0 || ix >= 2048 || iz <= 0 || iz >= 2048) continue;
                        int color = MapColor.field_76281_a[this.map.colors[ix + iz * 2048]].field_76291_p;
                        r += (double)(color >> 16 & 0xFF);
                        g += (double)(color >> 8 & 0xFF);
                        b += (double)(color & 0xFF);
                    }
                }
                r /= (double)(blocksPerPixel * blocksPerPixel);
                g /= (double)(blocksPerPixel * blocksPerPixel);
                b /= (double)(blocksPerPixel * blocksPerPixel);
                this.mapTexture.setColor(i, j, r /= 255.0, g /= 255.0, b /= 255.0, 1.0);
            }
        }
        RPCHandler.rpcPlayer(info.sender, (Object)this, "receiveImage", new Object[]{this.mapTexture.colorMap});
    }

    @RPC(value=RPCSide.CLIENT)
    private void receiveImage(int[] colors) {
        for (int i = 0; i < colors.length; ++i) {
            this.mapTexture.colorMap[i] = colors[i];
        }
    }
}

