/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.commander;

import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.api.robots.ResourceId;
import buildcraft.api.robots.StackRequest;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.network.RPC;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.network.RPCSide;
import buildcraft.core.robots.ResourceIdRequest;
import buildcraft.core.robots.RobotRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileRequester
extends TileBuildCraft
implements IInventory,
IRequestProvider {
    public static final int NB_ITEMS = 20;
    private SimpleInventory inv = new SimpleInventory(20, "items", 64);
    private SimpleInventory requests = new SimpleInventory(20, "requests", 64);

    @RPC(value=RPCSide.SERVER)
    public void setRequest(int index, ItemStack stack) {
        if (this.field_145850_b.field_72995_K) {
            RPCHandler.rpcServer(this, "setRequest", index, stack);
            return;
        }
        this.requests.func_70299_a(index, stack);
    }

    public ItemStack getRequest(int index) {
        return this.requests.func_70301_a(index);
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int slotId) {
        return this.inv.func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int count) {
        return this.inv.func_70298_a(slotId, count);
    }

    public ItemStack func_70304_b(int slotId) {
        return this.inv.func_70304_b(slotId);
    }

    public void func_70299_a(int slotId, ItemStack itemStack) {
        this.inv.func_70299_a(slotId, itemStack);
    }

    public String func_145825_b() {
        return this.inv.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inv.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.inv.func_70300_a(entityPlayer);
    }

    public void func_70295_k_() {
        this.inv.func_70295_k_();
    }

    public void func_70305_f() {
        this.inv.func_70305_f();
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (this.requests.func_70301_a(i) == null) {
            return false;
        }
        if (!StackHelper.isMatchingItemOrList(this.requests.func_70301_a(i), itemStack)) {
            return false;
        }
        return this.inv.func_94041_b(i, itemStack);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound invNBT = new NBTTagCompound();
        this.inv.writeToNBT(invNBT);
        nbt.func_74782_a("inv", (NBTBase)invNBT);
        NBTTagCompound reqNBT = new NBTTagCompound();
        this.requests.writeToNBT(reqNBT);
        nbt.func_74782_a("req", (NBTBase)reqNBT);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inv.readFromNBT(nbt.func_74775_l("inv"));
        this.requests.readFromNBT(nbt.func_74775_l("req"));
    }

    public boolean isFulfilled(int i) {
        if (this.requests.func_70301_a(i) == null) {
            return true;
        }
        if (this.inv.func_70301_a(i) == null) {
            return false;
        }
        return StackHelper.isMatchingItemOrList(this.requests.func_70301_a(i), this.inv.func_70301_a(i)) && this.inv.func_70301_a((int)i).field_77994_a >= this.requests.func_70301_a((int)i).field_77994_a;
    }

    @Override
    public int getNumberOfRequests() {
        return 20;
    }

    @Override
    public StackRequest getAvailableRequest(int i) {
        if (this.requests.func_70301_a(i) == null) {
            return null;
        }
        if (this.isFulfilled(i)) {
            return null;
        }
        if (RobotRegistry.getRegistry(this.field_145850_b).isTaken(new ResourceIdRequest(this, i))) {
            return null;
        }
        StackRequest r = new StackRequest();
        r.index = i;
        r.stack = this.requests.func_70301_a(i);
        r.requester = this;
        return r;
    }

    @Override
    public boolean takeRequest(int i, EntityRobotBase robot) {
        if (this.requests.func_70301_a(i) == null) {
            return false;
        }
        if (this.isFulfilled(i)) {
            return false;
        }
        return RobotRegistry.getRegistry(this.field_145850_b).take((ResourceId)new ResourceIdRequest(this, i), robot);
    }

    @Override
    public ItemStack provideItemsForRequest(int i, ItemStack stack) {
        ItemStack existingStack = this.inv.func_70301_a(i);
        if (this.requests.func_70301_a(i) == null) {
            return stack;
        }
        if (existingStack == null) {
            int maxQty = this.requests.func_70301_a((int)i).field_77994_a;
            if (stack.field_77994_a <= maxQty) {
                this.inv.func_70299_a(i, stack);
                return null;
            }
            ItemStack newStack = stack.func_77946_l();
            newStack.field_77994_a = maxQty;
            stack.field_77994_a -= maxQty;
            this.inv.func_70299_a(i, newStack);
            return stack;
        }
        if (!StackHelper.isMatchingItemOrList(stack, existingStack)) {
            return stack;
        }
        if (existingStack == null || StackHelper.isMatchingItemOrList(stack, this.requests.func_70301_a(i))) {
            int maxQty = this.requests.func_70301_a((int)i).field_77994_a;
            if (existingStack.field_77994_a + stack.field_77994_a <= maxQty) {
                existingStack.field_77994_a += stack.field_77994_a;
                return null;
            }
            stack.field_77994_a -= maxQty - existingStack.field_77994_a;
            existingStack.field_77994_a = maxQty;
            return stack;
        }
        return stack;
    }
}

