/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.BCLog;
import buildcraft.api.gates.GateExpansions;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.core.recipes.AssemblyRecipeManager;
import buildcraft.core.recipes.IntegrationRecipeManager;
import buildcraft.core.recipes.RefineryRecipeManager;
import buildcraft.energy.worldgen.OilPopulate;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.recipes.GateExpansionRecipe;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.FluidStack;

public final class InterModComms {
    private InterModComms() {
    }

    public static void processIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            if (m.key.equals("add-facade")) {
                InterModComms.processAddFacadeIMC(event, m);
                continue;
            }
            if (m.key.equals("blacklist-facade")) {
                InterModComms.processBlacklistFacadeIMC(event, m);
                continue;
            }
            if (m.key.equals("oil-lake-biome")) {
                InterModComms.processOilLakeBiomeIMC(event, m);
                continue;
            }
            if (m.key.equals("oil-gen-exclude")) {
                InterModComms.processOilGenExcludeIMC(event, m);
                continue;
            }
            if (m.key.equals("add-assembly-recipe")) {
                InterModComms.processAssemblyRecipeAddIMC(event, m);
                continue;
            }
            if (m.key.equals("add-refinery-recipe")) {
                InterModComms.processRefineryRecipeAddIMC(event, m);
                continue;
            }
            if (m.key.equals("add-gate-expansion-recipe")) {
                InterModComms.processGateExpansionRecipeAddIMC(event, m);
                continue;
            }
            if (m.key.equals("remove-assembly-recipe")) {
                InterModComms.processAssemblyRecipeRemoveIMC(event, m);
                continue;
            }
            if (m.key.equals("remove-refinery-recipe")) {
                InterModComms.processRefineryRecipeRemoveIMC(event, m);
                continue;
            }
            BCLog.logger.warn("Received an IMC message with unknown key ('%s') from %s!", new Object[]{m.key, m.getSender()});
        }
    }

    public static void processAssemblyRecipeRemoveIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage msg) {
        if (msg.isStringMessage()) {
            AssemblyRecipeManager.INSTANCE.removeRecipe(msg.getStringValue());
            BCLog.logger.info(String.format("Received an assembly recipe '%s' removal request from mod %s", msg.getStringValue(), msg.getSender()));
        }
    }

    public static void processRefineryRecipeRemoveIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage msg) {
        if (msg.isStringMessage()) {
            RefineryRecipeManager.INSTANCE.removeRecipe(msg.getStringValue());
            BCLog.logger.info(String.format("Received a refinery recipe '%s' removal request from mod %s", msg.getStringValue(), msg.getSender()));
        }
    }

    public static void processGateExpansionRecipeAddIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage msg) {
        boolean failed = false;
        if (!msg.isNBTMessage()) {
            failed = true;
        } else {
            NBTTagCompound recipe = msg.getNBTValue();
            if (!(recipe.func_74764_b("id") && recipe.func_74764_b("expansion") && recipe.func_74764_b("input"))) {
                failed = true;
                return;
            }
            IGateExpansion exp = GateExpansions.getExpansion(recipe.func_74779_i("expansion"));
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)recipe.func_74775_l("input"));
            if (exp == null || is == null) {
                failed = true;
                return;
            }
            IntegrationRecipeManager.INSTANCE.addRecipe(new GateExpansionRecipe(recipe.func_74779_i("id"), exp, is));
        }
        if (failed) {
            BCLog.logger.warn("Received invalid gate expansion recipe IMC message from mod %s!", new Object[]{msg.getSender()});
        }
    }

    public static void processAssemblyRecipeAddIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage msg) {
        boolean failed = false;
        if (!msg.isNBTMessage()) {
            failed = true;
        } else {
            NBTTagCompound recipe = msg.getNBTValue();
            if (!(recipe.func_74764_b("id") && recipe.func_150297_b("input", 9) && recipe.func_150297_b("output", 10) && recipe.func_150297_b("energy", 6))) {
                failed = true;
            } else {
                ItemStack is;
                NBTTagList list = (NBTTagList)recipe.func_74781_a("input");
                ArrayList<ItemStack> input = new ArrayList<ItemStack>();
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    is = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i));
                    if (is == null) continue;
                    input.add(is);
                }
                String id = recipe.func_74779_i("id");
                is = ItemStack.func_77949_a((NBTTagCompound)recipe.func_74775_l("output"));
                if (is != null && !input.isEmpty() && id.length() > 0) {
                    AssemblyRecipeManager.INSTANCE.addRecipe(id, recipe.func_74762_e("energy"), is, input.toArray(new ItemStack[input.size()]));
                } else {
                    failed = true;
                }
            }
        }
        if (failed) {
            BCLog.logger.warn("Received invalid assembly recipe IMC message from mod %s!", new Object[]{msg.getSender()});
        }
    }

    public static void processRefineryRecipeAddIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage msg) {
        boolean failed = false;
        if (!msg.isNBTMessage()) {
            failed = true;
        } else {
            NBTTagCompound recipe = msg.getNBTValue();
            if (!((recipe.func_74764_b("id") || recipe.func_150297_b("input", 10)) && recipe.func_150297_b("output", 10) && recipe.func_150297_b("energy", 3) && recipe.func_150297_b("delay", 3))) {
                failed = true;
            } else {
                FluidStack output = FluidStack.loadFluidStackFromNBT((NBTTagCompound)recipe.func_74775_l("output"));
                FluidStack input = FluidStack.loadFluidStackFromNBT((NBTTagCompound)recipe.func_74775_l("input"));
                FluidStack input2 = null;
                String id = recipe.func_74779_i("id");
                if (recipe.func_150297_b("input_2", 10)) {
                    input2 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)recipe.func_74775_l("input_2"));
                }
                if (input != null && output != null && id.length() > 0) {
                    RefineryRecipeManager.INSTANCE.addRecipe(id, input, input2, output, recipe.func_74762_e("energy"), recipe.func_74762_e("delay"));
                } else {
                    failed = true;
                }
            }
        }
        if (failed) {
            BCLog.logger.warn("Received invalid refinery recipe IMC message from mod %s!", new Object[]{msg.getSender()});
        }
    }

    public static void processAddFacadeIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage m) {
        try {
            if (m.isStringMessage()) {
                Splitter splitter = Splitter.on((String)"@").trimResults();
                String[] array = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)m.getStringValue()), String.class);
                if (array.length != 2) {
                    BCLog.logger.info(String.format("Received an invalid add-facade request %s from mod %s", m.getStringValue(), m.getSender()));
                } else {
                    String blockName = array[0];
                    Integer metaId = Ints.tryParse((String)array[1]);
                    if (Strings.isNullOrEmpty((String)blockName) || metaId == null) {
                        BCLog.logger.info(String.format("Received an invalid add-facade request %s from mod %s", m.getStringValue(), m.getSender()));
                    } else {
                        Block block = (Block)Block.field_149771_c.func_82594_a(blockName);
                        if (block.func_149645_b() != 0 && block.func_149645_b() != 31) {
                            BuildCraftTransport.facadeItem.addFacade("buildcraft:facade{" + blockName + "}", new ItemStack(block, 1, metaId.intValue()));
                        } else {
                            InterModComms.logRedundantAddFacadeMessage(m, block.toString());
                        }
                    }
                }
            } else if (m.isItemStackMessage()) {
                ItemStack modItemStack = m.getItemStackValue();
                Block block = Block.func_149634_a((Item)modItemStack.func_77973_b());
                if (block != null && block.func_149645_b() != 0 && block.func_149645_b() != 31) {
                    BuildCraftTransport.facadeItem.addFacade("buildcraft:facade{" + Block.field_149771_c.func_148750_c((Object)block) + "}", modItemStack);
                } else {
                    InterModComms.logRedundantAddFacadeMessage(m, block.toString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void processBlacklistFacadeIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage message) {
        try {
            if (message.isItemStackMessage()) {
                ItemStack modItemStack = message.getItemStackValue();
                Block block = Block.func_149634_a((Item)modItemStack.func_77973_b());
                if (block != null) {
                    String blockName = Block.field_149771_c.func_148750_c((Object)block);
                    ItemFacade.blacklistFacade(blockName);
                }
            } else {
                BCLog.logger.info(String.format("Invalid blacklist-facade message from mod %s. Send an ItemStackMessage instead.", message.getSender()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void logRedundantAddFacadeMessage(FMLInterModComms.IMCMessage m, String blockName) {
        BCLog.logger.warn(String.format("%s is trying to add %s - a facade that BuildCraft will add later. Facade addition not necessary.", m.getSender(), blockName));
    }

    public static void processOilLakeBiomeIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage m) {
        try {
            String biomeID = m.getStringValue().trim();
            int id = Integer.valueOf(biomeID);
            if (id >= BiomeGenBase.func_150565_n().length) {
                throw new IllegalArgumentException("Biome ID must be less than " + BiomeGenBase.func_150565_n().length);
            }
            OilPopulate.INSTANCE.surfaceDepositBiomes.add(id);
        }
        catch (Exception ex) {
            BCLog.logger.warn(String.format("Received an invalid oil-lake-biome request %s from mod %s", m.getStringValue(), m.getSender()));
        }
        BCLog.logger.info(String.format("Received a successful oil-lake-biome request %s from mod %s", m.getStringValue(), m.getSender()));
    }

    public static void processOilGenExcludeIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage m) {
        try {
            String biomeID = m.getStringValue().trim();
            int id = Integer.valueOf(biomeID);
            if (id >= BiomeGenBase.func_150565_n().length) {
                throw new IllegalArgumentException("Biome ID must be less than " + BiomeGenBase.func_150565_n().length);
            }
            OilPopulate.INSTANCE.excludedBiomes.add(id);
        }
        catch (Exception ex) {
            BCLog.logger.warn(String.format("Received an invalid oil-gen-exclude request %s from mod %s", m.getStringValue(), m.getSender()));
        }
        BCLog.logger.info(String.format("Received a successful oil-gen-exclude request %s from mod %s", m.getStringValue(), m.getSender()));
    }
}

