/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftSilicon;
import buildcraft.api.boards.RedstoneBoardNBT;
import buildcraft.api.boards.RedstoneBoardRegistry;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.robots.EntityRobot;
import buildcraft.core.utils.NBTUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ItemRobot
extends ItemBuildCraft {
    public ItemRobot() {
        super(CreativeTabBuildCraft.BOARDS);
    }

    public EntityRobot createRobot(ItemStack stack, World world) {
        try {
            NBTTagCompound nbt = NBTUtils.getItemData(stack);
            NBTTagCompound boardCpt = nbt.func_74775_l("board");
            EntityRobot robot = new EntityRobot(world, boardCpt);
            return robot;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RedstoneBoardNBT getRobotNBT(ItemStack stack) {
        try {
            NBTTagCompound nbt = NBTUtils.getItemData(stack);
            NBTTagCompound boardCpt = nbt.func_74775_l("board");
            return RedstoneBoardRegistry.instance.getRedstoneBoard(boardCpt);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public ResourceLocation getTextureRobot(ItemStack stack) {
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        if (!nbt.func_74764_b("board")) {
            return EntityRobot.ROBOT_BASE;
        }
        NBTTagCompound board = nbt.func_74775_l("board");
        RedstoneBoardNBT boardNBT = RedstoneBoardRegistry.instance.getRedstoneBoard(board);
        if (boardNBT instanceof RedstoneBoardRobotNBT) {
            return ((RedstoneBoardRobotNBT)boardNBT).getRobotTexture();
        }
        return EntityRobot.ROBOT_BASE;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        RedstoneBoardNBT nbt;
        NBTTagCompound cpt = NBTUtils.getItemData(stack).func_74775_l("board");
        if (cpt.func_74764_b("id") && !"<unknown>".equals(cpt.func_74779_i("id")) && (nbt = RedstoneBoardRegistry.instance.getRedstoneBoard(cpt)) != null) {
            nbt.addInformation(stack, player, list, advanced);
        }
    }

    @Override
    public void func_94581_a(IIconRegister par1IconRegister) {
    }

    public static ItemStack createRobotStack(ItemStack board) {
        ItemStack robot = new ItemStack(BuildCraftSilicon.robotItem);
        NBTUtils.getItemData(robot).func_74782_a("board", (NBTBase)NBTUtils.getItemData(board));
        return robot;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(new ItemStack(BuildCraftSilicon.robotItem));
        for (RedstoneBoardNBT<?> nbt : RedstoneBoardRegistry.instance.getAllBoardNBTs()) {
            ItemStack boardStack = new ItemStack((Item)BuildCraftSilicon.redstoneBoard);
            NBTTagCompound nbtData = NBTUtils.getItemData(boardStack);
            nbt.createBoard(nbtData);
            ItemStack robotStack = ItemRobot.createRobotStack(boardStack);
            itemList.add(robotStack.func_77946_l());
        }
    }
}

