/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.NetworkData;
import buildcraft.core.utils.BitSetUtils;
import java.util.BitSet;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;

public class ZoneChunk {
    @NetworkData
    public BitSet property;
    @NetworkData
    private boolean fullSet = false;

    public boolean get(int xChunk, int zChunk) {
        if (this.fullSet) {
            return true;
        }
        if (this.property == null) {
            return false;
        }
        return this.property.get(xChunk + zChunk * 16);
    }

    public void set(int xChunk, int zChunk, boolean value) {
        if (value) {
            if (this.fullSet) {
                return;
            }
            if (this.property == null) {
                this.property = new BitSet(256);
            }
            this.property.set(xChunk + zChunk * 16, value);
            if (this.property.cardinality() >= 256) {
                this.property = null;
                this.fullSet = true;
            }
        } else {
            if (this.fullSet) {
                this.property = new BitSet(256);
                this.property.flip(0, 255);
                this.fullSet = false;
            } else if (this.property == null) {
                this.property = new BitSet(256);
            }
            this.property.set(xChunk + zChunk * 16, value);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("fullSet", this.fullSet);
        if (this.property != null) {
            nbt.func_74773_a("bits", BitSetUtils.toByteArray(this.property));
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.fullSet = nbt.func_74767_n("fullSet");
        if (nbt.func_74764_b("bits")) {
            this.property = BitSetUtils.fromByteArray(nbt.func_74770_j("bits"));
        }
    }

    public BlockIndex getRandomBlockIndex(Random rand) {
        int z;
        int x;
        if (this.fullSet) {
            x = rand.nextInt(16);
            z = rand.nextInt(16);
        } else {
            int bitPosition = this.property.nextSetBit(0);
            for (int bitId = rand.nextInt(this.property.cardinality()); bitId > 0; --bitId) {
                bitPosition = this.property.nextSetBit(bitPosition);
            }
            z = bitPosition / 16;
            x = bitPosition - 16 * z;
        }
        return new BlockIndex(x, 0, z);
    }

    public boolean isEmpty() {
        return !this.fullSet && this.property.isEmpty();
    }
}

