/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.Position;
import buildcraft.core.Box;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.builders.BuildingItem;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.builders.BuildingSlotBlock;
import buildcraft.core.builders.IBuildingItemsProvider;
import buildcraft.core.builders.TileAbstractBuilder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public abstract class BptBuilderBase
implements IAreaProvider {
    public BlueprintBase blueprint;
    public BptContext context;
    protected boolean done;
    protected TreeSet<BlockIndex> clearedLocations = new TreeSet();
    protected TreeSet<BlockIndex> builtLocations = new TreeSet();
    protected int x;
    protected int y;
    protected int z;
    protected boolean initialized = false;
    private long nextBuildDate = 0L;

    public BptBuilderBase(BlueprintBase bluePrint, World world, int x, int y, int z) {
        this.blueprint = bluePrint;
        this.x = x;
        this.y = y;
        this.z = z;
        this.done = false;
        Box box = new Box();
        box.initialize(this);
        this.context = bluePrint.getContext(world, box);
    }

    protected abstract void initialize();

    protected abstract BuildingSlot reserveNextBlock(World var1);

    protected abstract BuildingSlot getNextBlock(World var1, TileAbstractBuilder var2);

    public boolean buildNextSlot(World world, TileAbstractBuilder builder, double x, double y, double z) {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        if (world.func_82737_E() < this.nextBuildDate) {
            return false;
        }
        BuildingSlot slot = this.getNextBlock(world, builder);
        if (this.buildSlot(world, builder, slot, x + 0.5, y + 0.5, z + 0.5)) {
            this.nextBuildDate = world.func_82737_E() + (long)slot.buildTime();
            return true;
        }
        return false;
    }

    public boolean buildSlot(World world, IBuildingItemsProvider builder, BuildingSlot slot, double x, double y, double z) {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        if (slot != null) {
            slot.built = true;
            BuildingItem i = new BuildingItem();
            i.origin = new Position(x, y, z);
            i.destination = slot.getDestination();
            i.slotToBuild = slot;
            i.context = this.getContext();
            i.setStacksToDisplay(slot.getStacksToDisplay());
            builder.addAndLaunchBuildingItem(i);
            return true;
        }
        return false;
    }

    public BuildingSlot reserveNextSlot(World world) {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        return this.reserveNextBlock(world);
    }

    @Override
    public int xMin() {
        return this.x - this.blueprint.anchorX;
    }

    @Override
    public int yMin() {
        return this.y - this.blueprint.anchorY;
    }

    @Override
    public int zMin() {
        return this.z - this.blueprint.anchorZ;
    }

    @Override
    public int xMax() {
        return this.x + this.blueprint.sizeX - this.blueprint.anchorX - 1;
    }

    @Override
    public int yMax() {
        return this.y + this.blueprint.sizeY - this.blueprint.anchorY - 1;
    }

    @Override
    public int zMax() {
        return this.z + this.blueprint.sizeZ - this.blueprint.anchorZ - 1;
    }

    @Override
    public void removeFromWorld() {
    }

    public AxisAlignedBB getBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.xMin(), (double)this.yMin(), (double)this.zMin(), (double)this.xMax(), (double)this.yMax(), (double)this.zMax());
    }

    public void postProcessing(World world) {
    }

    public BptContext getContext() {
        return this.context;
    }

    public void removeDoneBuilders(TileAbstractBuilder builder) {
        ArrayList<BuildingItem> items = builder.getBuilders();
        for (int i = items.size() - 1; i >= 0; --i) {
            if (!items.get(i).isDone()) continue;
            items.remove(i);
        }
    }

    public boolean isDone(IBuildingItemsProvider builder) {
        return this.done && builder.getBuilders().size() == 0;
    }

    private int getHardness(BuildingSlotBlock slot) {
        int hardness = (int)this.context.world().func_147439_a(slot.x, slot.y, slot.z).func_149712_f(this.context.world(), slot.x, slot.y, slot.z) + 1;
        return hardness *= 2;
    }

    protected final boolean canDestroy(TileAbstractBuilder builder, IBuilderContext context, BuildingSlotBlock slot) {
        LinkedList result = new LinkedList();
        int hardness = this.getHardness(slot);
        return builder.energyAvailable() >= hardness * BuilderAPI.BREAK_ENERGY;
    }

    public void consumeEnergyToDestroy(TileAbstractBuilder builder, BuildingSlotBlock slot) {
        int hardness = this.getHardness(slot);
        builder.consumeEnergy(hardness * BuilderAPI.BREAK_ENERGY);
    }

    public void createDestroyItems(BuildingSlotBlock slot) {
        int hardness = this.getHardness(slot);
        for (int i = 0; i < hardness; ++i) {
            slot.addStackConsumed(new ItemStack((Block)BuildCraftBuilders.buildToolBlock));
        }
    }

    public void useRequirements(IInventory inv, BuildingSlot slot) {
    }

    public void saveBuildStateToNBT(NBTTagCompound nbt, IBuildingItemsProvider builder) {
        NBTTagList clearList = new NBTTagList();
        for (BlockIndex loc : this.clearedLocations) {
            NBTTagCompound cpt = new NBTTagCompound();
            loc.writeTo(cpt);
            clearList.func_74742_a((NBTBase)cpt);
        }
        nbt.func_74782_a("clearList", (NBTBase)clearList);
        NBTTagList builtList = new NBTTagList();
        for (BlockIndex loc : this.builtLocations) {
            NBTTagCompound cpt = new NBTTagCompound();
            loc.writeTo(cpt);
            builtList.func_74742_a((NBTBase)cpt);
        }
        nbt.func_74782_a("builtList", (NBTBase)builtList);
        NBTTagList buildingList = new NBTTagList();
        for (BuildingItem item : builder.getBuilders()) {
            NBTTagCompound sub = new NBTTagCompound();
            item.writeToNBT(sub);
            buildingList.func_74742_a((NBTBase)sub);
        }
        nbt.func_74782_a("buildersInAction", (NBTBase)buildingList);
    }

    public void loadBuildStateToNBT(NBTTagCompound nbt, IBuildingItemsProvider builder) {
        NBTTagList clearList = nbt.func_150295_c("clearList", 10);
        for (int i = 0; i < clearList.func_74745_c(); ++i) {
            NBTTagCompound cpt = clearList.func_150305_b(i);
            this.clearedLocations.add(new BlockIndex(cpt));
        }
        NBTTagList builtList = nbt.func_150295_c("builtList", 10);
        for (int i = 0; i < builtList.func_74745_c(); ++i) {
            NBTTagCompound cpt = builtList.func_150305_b(i);
            this.builtLocations.add(new BlockIndex(cpt));
        }
        NBTTagList buildingList = nbt.func_150295_c("buildersInAction", 10);
        for (int i = 0; i < buildingList.func_74745_c(); ++i) {
            BuildingItem item = new BuildingItem();
            try {
                item.readFromNBT(buildingList.func_150305_b(i));
                item.context = this.getContext();
                builder.getBuilders().add(item);
                continue;
            }
            catch (MappingNotFoundException e) {
                BCLog.logger.log(Level.WARN, "can't load building item", (Throwable)e);
            }
        }
    }
}

