/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.core.Box;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.blueprints.BptBuilderTemplate;
import buildcraft.core.blueprints.Template;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RecursiveBlueprintBuilder {
    private boolean returnedThis = false;
    private BlueprintBase blueprint;
    private RecursiveBlueprintBuilder current;
    private int nextSubBlueprint = 0;
    private ArrayList<NBTTagCompound> subBlueprints = new ArrayList();
    private int x;
    private int y;
    private int z;
    private ForgeDirection dir;
    private World world;
    private Box box = new Box();

    public RecursiveBlueprintBuilder(BlueprintBase iBlueprint, World iWorld, int iX, int iY, int iZ, ForgeDirection iDir) {
        this.blueprint = iBlueprint;
        this.subBlueprints = iBlueprint.subBlueprintsNBT;
        this.world = iWorld;
        this.x = iX;
        this.y = iY;
        this.z = iZ;
        this.dir = iDir;
    }

    public BptBuilderBase nextBuilder() {
        BptBuilderBase builder;
        if (!this.returnedThis) {
            BptBuilderBase builder2;
            this.blueprint.adjustToWorld(this.world, this.x, this.y, this.x, this.dir);
            this.returnedThis = true;
            if (this.blueprint instanceof Blueprint) {
                builder2 = new BptBuilderBlueprint((Blueprint)this.blueprint, this.world, this.x, this.y, this.z);
            } else if (this.blueprint instanceof Template) {
                builder2 = new BptBuilderTemplate(this.blueprint, this.world, this.x, this.y, this.z);
            } else {
                return null;
            }
            this.box.initialize(builder2);
            return builder2;
        }
        this.blueprint = null;
        if (this.current != null && (builder = this.current.nextBuilder()) != null) {
            return builder;
        }
        if (this.nextSubBlueprint >= this.subBlueprints.size()) {
            return null;
        }
        NBTTagCompound nbt = this.subBlueprints.get(this.nextSubBlueprint);
        BlueprintBase bpt = BlueprintBase.loadBluePrint(nbt.func_74775_l("bpt"));
        int nx = this.box.xMin + nbt.func_74762_e("x");
        int ny = this.box.yMin + nbt.func_74762_e("y");
        int nz = this.box.zMin + nbt.func_74762_e("z");
        ForgeDirection nbtDir = ForgeDirection.values()[nbt.func_74771_c("dir")];
        this.current = new RecursiveBlueprintBuilder(bpt, this.world, nx, ny, nz, nbtDir);
        ++this.nextSubBlueprint;
        return this.current.nextBuilder();
    }
}

