/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.blueprints.SchematicFactory;
import buildcraft.api.blueprints.SchematicMask;
import buildcraft.api.core.Position;
import buildcraft.core.builders.BuildingSlot;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class BuildingSlotBlock
extends BuildingSlot {
    public int x;
    public int y;
    public int z;
    public SchematicBlockBase schematic;
    public Mode mode = Mode.Build;
    public int buildStage = 0;

    @Override
    public SchematicBlockBase getSchematic() {
        if (this.schematic == null) {
            return new SchematicMask(false);
        }
        return this.schematic;
    }

    @Override
    public void writeToWorld(IBuilderContext context) {
        if (this.mode == Mode.ClearIfInvalid) {
            if (!this.getSchematic().isAlreadyBuilt(context, this.x, this.y, this.z)) {
                context.world().func_147468_f(this.x, this.y, this.z);
            }
        } else {
            try {
                this.getSchematic().placeInWorld(context, this.x, this.y, this.z, this.stackConsumed);
                TileEntity e = context.world().func_147438_o(this.x, this.y, this.z);
                if (e != null) {
                    e.func_145845_h();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                context.world().func_147468_f(this.x, this.y, this.z);
            }
        }
    }

    @Override
    public void postProcessing(IBuilderContext context) {
        this.getSchematic().postProcessing(context, this.x, this.y, this.z);
    }

    @Override
    public LinkedList<ItemStack> getRequirements(IBuilderContext context) {
        if (this.mode == Mode.ClearIfInvalid) {
            return new LinkedList<ItemStack>();
        }
        LinkedList<ItemStack> req = new LinkedList<ItemStack>();
        this.getSchematic().getRequirementsForPlacement(context, req);
        return req;
    }

    @Override
    public Position getDestination() {
        return new Position((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5);
    }

    @Override
    public void writeCompleted(IBuilderContext context, double complete) {
        if (this.mode == Mode.ClearIfInvalid) {
            context.world().func_147443_d(0, this.x, this.y, this.z, (int)(complete * 10.0) - 1);
        }
    }

    @Override
    public boolean isAlreadyBuilt(IBuilderContext context) {
        return this.schematic.isAlreadyBuilt(context, this.x, this.y, this.z);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        nbt.func_74774_a("mode", (byte)this.mode.ordinal());
        nbt.func_74768_a("x", this.x);
        nbt.func_74768_a("y", this.y);
        nbt.func_74768_a("z", this.z);
        if (this.schematic != null) {
            NBTTagCompound schematicNBT = new NBTTagCompound();
            SchematicFactory.getFactory(this.schematic.getClass()).saveSchematicToWorldNBT(schematicNBT, this.schematic, registry);
            nbt.func_74782_a("schematic", (NBTBase)schematicNBT);
        }
        NBTTagList nbtStacks = new NBTTagList();
        if (this.stackConsumed != null) {
            for (ItemStack stack : this.stackConsumed) {
                NBTTagCompound nbtStack = new NBTTagCompound();
                stack.func_77955_b(nbtStack);
                nbtStacks.func_74742_a((NBTBase)nbtStack);
            }
        }
        nbt.func_74782_a("stackConsumed", (NBTBase)nbtStacks);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, MappingRegistry registry) throws MappingNotFoundException {
        this.mode = Mode.values()[nbt.func_74771_c("mode")];
        this.x = nbt.func_74762_e("x");
        this.y = nbt.func_74762_e("y");
        this.z = nbt.func_74762_e("z");
        if (nbt.func_74764_b("schematic")) {
            this.schematic = (SchematicBlockBase)SchematicFactory.createSchematicFromWorldNBT(nbt.func_74775_l("schematic"), registry);
        }
        this.stackConsumed = new LinkedList();
        NBTTagList nbtStacks = nbt.func_150295_c("stackConsumed", 10);
        for (int i = 0; i < nbtStacks.func_74745_c(); ++i) {
            this.stackConsumed.add(ItemStack.func_77949_a((NBTTagCompound)nbtStacks.func_150305_b(i)));
        }
    }

    @Override
    public LinkedList<ItemStack> getStacksToDisplay() {
        if (this.mode == Mode.ClearIfInvalid) {
            return this.stackConsumed;
        }
        return this.getSchematic().getStacksToDisplay(this.stackConsumed);
    }

    @Override
    public int getEnergyRequirement() {
        return this.schematic.getEnergyRequirement(this.stackConsumed);
    }

    @Override
    public int buildTime() {
        if (this.schematic == null) {
            return 1;
        }
        return this.schematic.buildTime();
    }

    public static enum Mode {
        ClearIfInvalid,
        Build;

    }
}

