/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders;

import buildcraft.api.blueprints.ITileBuilder;
import buildcraft.api.core.NetworkData;
import buildcraft.core.IBoxProvider;
import buildcraft.core.LaserData;
import buildcraft.core.RFBattery;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.builders.BuildingItem;
import buildcraft.core.builders.IBuildingItemsProvider;
import buildcraft.core.network.RPC;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.network.RPCMessageInfo;
import buildcraft.core.network.RPCSide;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileAbstractBuilder
extends TileBuildCraft
implements ITileBuilder,
IInventory,
IBoxProvider,
IBuildingItemsProvider {
    private static final int FULL_CHEST_ENERGY = 355600;
    @NetworkData
    public LinkedList<LaserData> pathLasers = new LinkedList();
    public ArrayList<BuildingItem> buildersInAction = new ArrayList();
    private int rfPrev = 0;
    private int rfUnchangedCycles = 0;

    public TileAbstractBuilder() {
        this.setBattery(new RFBattery(355600, 1000, 0));
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.field_145850_b.field_72995_K) {
            RPCHandler.rpcServer(this, "uploadBuildersInAction", new Object[0]);
        }
    }

    @RPC(value=RPCSide.SERVER)
    private void uploadBuildersInAction(RPCMessageInfo info) {
        for (BuildingItem i : this.buildersInAction) {
            RPCHandler.rpcPlayer(info.sender, this, "launchItem", i);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        RFBattery battery = this.getBattery();
        if (this.rfPrev != battery.getEnergyStored()) {
            this.rfPrev = battery.getEnergyStored();
            this.rfUnchangedCycles = 0;
        }
        BuildingItem toRemove = null;
        for (BuildingItem i : this.buildersInAction) {
            i.update();
            if (!i.isDone) continue;
            toRemove = i;
        }
        if (toRemove != null) {
            this.buildersInAction.remove(toRemove);
        }
        if (this.rfPrev != battery.getEnergyStored()) {
            this.rfPrev = battery.getEnergyStored();
            this.rfUnchangedCycles = 0;
        }
        ++this.rfUnchangedCycles;
        if (this.rfUnchangedCycles > 100) {
            battery.useEnergy(0, 1000, false);
            this.rfPrev = battery.getEnergyStored();
        }
    }

    @Override
    public ArrayList<BuildingItem> getBuilders() {
        return this.buildersInAction;
    }

    public LinkedList<LaserData> getPathLaser() {
        return this.pathLasers;
    }

    @RPC(value=RPCSide.CLIENT)
    public void launchItem(BuildingItem item) {
        this.buildersInAction.add(item);
    }

    @Override
    public void addAndLaunchBuildingItem(BuildingItem item) {
        this.buildersInAction.add(item);
        RPCHandler.rpcBroadcastWorldPlayers(this.field_145850_b, this, "launchItem", item);
    }

    public final int energyAvailable() {
        return this.getBattery().getEnergyStored();
    }

    public final boolean consumeEnergy(int quantity) {
        return this.getBattery().useEnergy(quantity, quantity, false) > 0;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.rfPrev = this.getBattery().getEnergyStored();
        this.rfUnchangedCycles = 0;
    }

    public double func_145833_n() {
        return Double.MAX_VALUE;
    }
}

