/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders.patterns;

import buildcraft.api.blueprints.SchematicMask;
import buildcraft.api.filler.IFillerPattern;
import buildcraft.core.Box;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptBuilderTemplate;
import buildcraft.core.blueprints.SchematicRegistry;
import buildcraft.core.blueprints.Template;
import buildcraft.core.utils.StringUtils;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public abstract class FillerPattern
implements IFillerPattern {
    public static final Map<String, FillerPattern> patterns = new TreeMap<String, FillerPattern>();
    private final String tag;
    private IIcon icon;

    public FillerPattern(String tag) {
        this.tag = tag;
        patterns.put(this.getUniqueTag(), this);
    }

    @Override
    public String getDisplayName() {
        return StringUtils.localize("fillerpattern." + this.tag);
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:" + this.tag;
    }

    public void registerIcon(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcraft:fillerPatterns/" + this.tag);
    }

    @Override
    public IIcon getIcon() {
        return this.icon;
    }

    public String toString() {
        return "Pattern: " + this.getUniqueTag();
    }

    public static void fill(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, Template template) {
        for (int y = yMin; y <= yMax; ++y) {
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    if (!FillerPattern.isValid(x, y, z, template)) continue;
                    template.contents[x][y][z] = new SchematicMask(true);
                }
            }
        }
    }

    public static void empty(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, Template template) {
        int lastX = Integer.MAX_VALUE;
        int lastY = Integer.MAX_VALUE;
        int lastZ = Integer.MAX_VALUE;
        for (int y = yMax; y >= yMin; --y) {
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    if (!FillerPattern.isValid(x, y, z, template)) continue;
                    template.contents[x][y][z] = null;
                }
            }
        }
    }

    public static void flatten(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, Template template) {
        int lastX = Integer.MAX_VALUE;
        int lastY = Integer.MAX_VALUE;
        int lastZ = Integer.MAX_VALUE;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                for (int y = yMax; y >= yMin; --y) {
                    if (!FillerPattern.isValid(x, y, z, template)) continue;
                    template.contents[x][y][z] = new SchematicMask(true);
                }
            }
        }
    }

    public abstract Template getTemplate(Box var1, World var2);

    public Blueprint getBlueprint(Box box, World world, Block block, int meta) {
        Blueprint result = new Blueprint(box.sizeX(), box.sizeY(), box.sizeZ());
        Template tmpl = this.getTemplate(box, world);
        for (int x = 0; x < box.sizeX(); ++x) {
            for (int y = 0; y < box.sizeY(); ++y) {
                for (int z = 0; z < box.sizeZ(); ++z) {
                    if (tmpl.contents[x][y][z] == null) continue;
                    result.contents[x][y][z] = SchematicRegistry.INSTANCE.createSchematicBlock(block, meta);
                }
            }
        }
        return result;
    }

    public BptBuilderTemplate getTemplateBuilder(Box box, World world) {
        return new BptBuilderTemplate(this.getTemplate(box, world), world, box.xMin, box.yMin, box.zMin);
    }

    private static boolean isValid(int x, int y, int z, BlueprintBase bpt) {
        return x >= 0 && y >= 0 && z >= 0 && x < bpt.sizeX && y < bpt.sizeY && z < bpt.sizeZ;
    }
}

