/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.fluids;

import buildcraft.core.TileBuffer;
import buildcraft.core.inventory.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public final class FluidUtils {
    private FluidUtils() {
    }

    public static boolean handleRightClick(IFluidHandler tank, ForgeDirection side, EntityPlayer player, boolean fill, boolean drain) {
        if (player == null || tank == null) {
            return false;
        }
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null) {
            ItemStack filled;
            FluidStack available;
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
            if (fill && liquid != null) {
                int used = tank.fill(side, liquid, true);
                if (used > 0) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvUtils.consumeItem(current));
                        player.field_71071_by.func_70296_d();
                    }
                    return true;
                }
            } else if (drain && (available = tank.drain(side, Integer.MAX_VALUE, false)) != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                if (current.field_77994_a > 1) {
                    if (!player.field_71071_by.func_70441_a(filled)) {
                        return false;
                    }
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvUtils.consumeItem(current));
                    player.field_71071_by.func_70296_d();
                } else {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvUtils.consumeItem(current));
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filled);
                    player.field_71071_by.func_70296_d();
                }
                tank.drain(side, liquid.amount, true);
                return true;
            }
        }
        return false;
    }

    public static Block getFluidBlock(Fluid fluid, boolean moving) {
        if (fluid == FluidRegistry.WATER) {
            return moving ? Blocks.field_150358_i : Blocks.field_150355_j;
        }
        if (fluid == FluidRegistry.LAVA) {
            return moving ? Blocks.field_150356_k : Blocks.field_150353_l;
        }
        return fluid.getBlock();
    }

    public static void pushFluidToConsumers(IFluidTank tank, int flowCap, TileBuffer[] tileBuffer) {
        int amountToPush = flowCap;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            int used;
            TileEntity tile;
            FluidStack fluidStack = tank.drain(amountToPush, false);
            if (fluidStack == null || fluidStack.amount <= 0 || !((tile = tileBuffer[side.ordinal()].getTile()) instanceof IFluidHandler) || (used = ((IFluidHandler)tile).fill(side.getOpposite(), fluidStack, true)) <= 0) continue;
            tank.drain(used, true);
            if ((amountToPush -= used) > 0) continue;
            return;
        }
    }
}

