/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.inventory;

import buildcraft.api.recipes.IFlexibleCrafter;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CrafterCopy
implements IFlexibleCrafter {
    private ItemStack[] items;
    private FluidStack[] fluids;

    public CrafterCopy(IFlexibleCrafter origin) {
        int i;
        this.items = new ItemStack[origin.getCraftingItemStackSize()];
        for (i = 0; i < this.items.length; ++i) {
            ItemStack s = origin.getCraftingItemStack(i);
            this.items[i] = s != null ? s.func_77946_l() : null;
        }
        this.fluids = new FluidStack[origin.getCraftingFluidStackSize()];
        for (i = 0; i < this.fluids.length; ++i) {
            FluidStack f = origin.getCraftingFluidStack(i);
            this.fluids[i] = f != null ? origin.getCraftingFluidStack(i).copy() : null;
        }
    }

    @Override
    public int getCraftingItemStackSize() {
        return this.items.length;
    }

    @Override
    public ItemStack getCraftingItemStack(int slotid) {
        return this.items[slotid];
    }

    @Override
    public ItemStack decrCraftingItemgStack(int slotid, int val) {
        ItemStack result;
        if (val >= this.items[slotid].field_77994_a) {
            result = this.items[slotid];
            this.items[slotid] = null;
        } else {
            result = this.items[slotid].func_77946_l();
            result.field_77994_a = val;
            this.items[slotid].field_77994_a -= val;
        }
        return result;
    }

    @Override
    public FluidStack getCraftingFluidStack(int tankid) {
        return this.fluids[tankid];
    }

    @Override
    public FluidStack decrCraftingFluidStack(int tankid, int val) {
        FluidStack result;
        if (val >= this.fluids[tankid].amount) {
            result = this.fluids[tankid];
            this.fluids[tankid] = null;
        } else {
            result = this.fluids[tankid].copy();
            result.amount = val;
            this.fluids[tankid].amount -= val;
        }
        return result;
    }

    @Override
    public int getCraftingFluidStackSize() {
        return this.fluids.length;
    }
}

