/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.inventory;

import buildcraft.api.core.IInvSlot;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.IStackFilter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class InvUtils {
    private InvUtils() {
    }

    public static int countItems(IInventory inv, ForgeDirection side, IStackFilter filter) {
        int count = 0;
        for (IInvSlot slot : InventoryIterator.getIterable(inv, side)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !filter.matches(stack)) continue;
            count += stack.field_77994_a;
        }
        return count;
    }

    public static boolean containsItem(IInventory inv, ForgeDirection side, IStackFilter filter) {
        for (IInvSlot slot : InventoryIterator.getIterable(inv, side)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !filter.matches(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRoomForStack(ItemStack stack, ForgeDirection side, IInventory dest) {
        if (stack == null || dest == null) {
            return false;
        }
        ITransactor tran = Transactor.getTransactorFor(dest);
        return tran.add((ItemStack)stack, (ForgeDirection)side, (boolean)false).field_77994_a > 0;
    }

    public static ItemStack moveOneItem(IInventory source, ForgeDirection output, IInventory dest, ForgeDirection intput, IStackFilter filter) {
        ITransactor imSource = Transactor.getTransactorFor(source);
        ItemStack stack = imSource.remove(filter, output, false);
        if (stack != null) {
            ITransactor imDest = Transactor.getTransactorFor(dest);
            int moved = imDest.add((ItemStack)stack, (ForgeDirection)intput, (boolean)true).field_77994_a;
            if (moved > 0) {
                imSource.remove(filter, output, true);
                return stack;
            }
        }
        return null;
    }

    public static void dropItems(World world, ItemStack stack, int i, int j, int k) {
        if (stack == null || stack.field_77994_a <= 0) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, stack);
        entityitem.field_145804_b = 10;
        world.func_72838_d((Entity)entityitem);
    }

    public static void dropItems(World world, IInventory inv, int i, int j, int k) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack items = inv.func_70301_a(slot);
            if (items == null || items.field_77994_a <= 0) continue;
            InvUtils.dropItems(world, inv.func_70301_a(slot).func_77946_l(), i, j, k);
        }
    }

    public static void wipeInventory(IInventory inv) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            inv.func_70299_a(slot, null);
        }
    }

    public static NBTTagCompound getItemData(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    public static void addItemToolTip(ItemStack stack, String msg) {
        NBTTagCompound nbt = InvUtils.getItemData(stack);
        NBTTagCompound display = nbt.func_74775_l("display");
        nbt.func_74782_a("display", (NBTBase)display);
        NBTTagList lore = display.func_150295_c("Lore", 8);
        display.func_74782_a("Lore", (NBTBase)lore);
        lore.func_74742_a((NBTBase)new NBTTagString(msg));
    }

    public static void writeInvToNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = new NBTTagList();
        for (byte slot = 0; slot < inv.func_70302_i_(); slot = (byte)((byte)(slot + 1))) {
            ItemStack stack = inv.func_70301_a((int)slot);
            if (stack == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", slot);
            stack.func_77955_b(itemTag);
            list.func_74742_a((NBTBase)itemTag);
        }
        data.func_74782_a(tag, (NBTBase)list);
    }

    public static void readInvFromNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = data.func_150295_c(tag, 10);
        for (int entry = 0; entry < list.func_74745_c(); entry = (int)((byte)(entry + 1))) {
            NBTTagCompound itemTag = list.func_150305_b(entry);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= inv.func_70302_i_()) continue;
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            inv.func_70299_a((int)slot, stack);
        }
    }

    public static void readStacksFromNBT(NBTTagCompound nbt, String name, ItemStack[] stacks) {
        NBTTagList nbttaglist = nbt.func_150295_c(name, 10);
        for (int i = 0; i < stacks.length; ++i) {
            if (i < nbttaglist.func_74745_c()) {
                NBTTagCompound nbttagcompound2 = nbttaglist.func_150305_b(i);
                stacks[i] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound2);
                continue;
            }
            stacks[i] = null;
        }
    }

    public static void writeStacksToNBT(NBTTagCompound nbt, String name, ItemStack[] stacks) {
        NBTTagList nbttaglist = new NBTTagList();
        for (ItemStack stack : stacks) {
            NBTTagCompound cpt = new NBTTagCompound();
            nbttaglist.func_74742_a((NBTBase)cpt);
            if (stack == null) continue;
            stack.func_77955_b(cpt);
        }
        nbt.func_74782_a(name, (NBTBase)nbttaglist);
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().hasContainerItem(stack)) {
                return stack.func_77973_b().getContainerItem(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }

    public static IInventory getInventory(IInventory inv) {
        if (inv instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)inv;
            TileEntityChest adjacent = null;
            if (chest.field_145991_k != null) {
                adjacent = chest.field_145991_k;
            }
            if (chest.field_145990_j != null) {
                adjacent = chest.field_145990_j;
            }
            if (chest.field_145992_i != null) {
                adjacent = chest.field_145992_i;
            }
            if (chest.field_145988_l != null) {
                adjacent = chest.field_145988_l;
            }
            if (adjacent != null) {
                return new InventoryLargeChest("", inv, (IInventory)adjacent);
            }
            return inv;
        }
        return inv;
    }

    public static IInvSlot getItem(IInventory inv, IStackFilter filter) {
        for (IInvSlot s : InventoryIterator.getIterable(inv)) {
            if (s.getStackInSlot() == null || !filter.matches(s.getStackInSlot())) continue;
            return s;
        }
        return null;
    }
}

