/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.inventory.filters;

import buildcraft.core.inventory.filters.IFluidFilter;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class ArrayFluidFilter
implements IFluidFilter {
    protected Fluid[] fluids;

    public ArrayFluidFilter(ItemStack ... stacks) {
        this.fluids = new Fluid[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            this.fluids[i] = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stacks[i]).getFluid();
        }
    }

    public ArrayFluidFilter(Fluid ... iFluids) {
        this.fluids = iFluids;
    }

    public boolean hasFilter() {
        for (Fluid filter : this.fluids) {
            if (filter == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(Fluid fluid) {
        for (Fluid filter : this.fluids) {
            if (filter == null || fluid.getID() != filter.getID()) continue;
            return true;
        }
        return false;
    }
}

