/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.network.RPC;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.network.RPCMessageInfo;
import buildcraft.core.network.RPCSide;
import buildcraft.core.utils.Utils;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;

public class NetworkIdRegistry {
    public static NetworkIdRegistry instance;
    private static boolean isLocal;
    private static boolean isMaster;
    private static BiMap<String, Integer> idMap;
    private static LinkedList<EntityPlayerMP> playersToInitialize;

    public NetworkIdRegistry() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public static void write(ByteBuf buf, String strId) {
        if (!isMaster) {
            if (!idMap.containsKey((Object)strId)) {
                buf.writeInt(-1);
                Utils.writeUTF(buf, strId);
            } else {
                buf.writeInt(((Integer)idMap.get((Object)strId)).intValue());
            }
        } else {
            if (!idMap.containsKey((Object)strId)) {
                idMap.put((Object)strId, (Object)idMap.size());
                if (!isLocal) {
                    RPCHandler.rpcBroadcastAllPlayers(NetworkIdRegistry.class, "receiveId", strId, idMap.size() - 1);
                }
            }
            buf.writeInt(((Integer)idMap.get((Object)strId)).intValue());
        }
    }

    public static String read(ByteBuf buf) {
        int id = buf.readInt();
        if (!isMaster) {
            if (!idMap.inverse().containsKey((Object)id)) {
                RPCHandler.rpcServer(NetworkIdRegistry.class, "requestId", id);
                throw new IllegalArgumentException("Id " + id + " unknown by the registry.");
            }
            return (String)idMap.inverse().get((Object)id);
        }
        if (id == -1) {
            String str = Utils.readUTF(buf);
            if (!idMap.containsKey((Object)str)) {
                idMap.put((Object)str, (Object)idMap.size());
            }
            return str;
        }
        return (String)idMap.inverse().get((Object)id);
    }

    @RPC(value=RPCSide.SERVER)
    private static void requestId(int id, RPCMessageInfo info) {
        if (!idMap.inverse().containsKey((Object)id)) {
            throw new IllegalArgumentException("Id " + id + " unknown by the registry.");
        }
        RPCHandler.rpcPlayer(info.sender, NetworkIdRegistry.class, "receiveId", idMap.inverse().get((Object)id), id);
    }

    @RPC(value=RPCSide.SERVER)
    private static void receiveId(String str, int id) {
        idMap.put((Object)str, (Object)id);
    }

    private static void sendAllIdsTo(EntityPlayerMP player) {
        ArrayList idStr = new ArrayList();
        ArrayList ids = new ArrayList();
        for (Map.Entry e : idMap.entrySet()) {
            idStr.add(e.getKey());
            ids.add(e.getValue());
        }
        RPCHandler.rpcPlayer((EntityPlayer)player, NetworkIdRegistry.class, "receiveAllIds", idStr, ids);
    }

    @RPC(value=RPCSide.CLIENT)
    private static void receiveAllIds(ArrayList<String> idStr, ArrayList<Integer> ids) {
        idMap.clear();
        for (int i = 0; i < idStr.size(); ++i) {
            if (idMap.containsKey((Object)idStr.get(i))) continue;
            System.out.println("INIT " + ids.get(i) + " => " + idStr.get(i));
            idMap.put((Object)idStr.get(i), (Object)ids.get(i));
        }
    }

    @SubscribeEvent
    public void serverConnected(FMLNetworkEvent.ServerConnectionFromClientEvent evt) {
        isMaster = true;
        if (evt.isLocal) {
            isLocal = true;
        } else {
            isLocal = false;
            playersToInitialize.add(((NetHandlerPlayServer)evt.handler).field_147369_b);
        }
    }

    @SubscribeEvent
    public void serverConnected(FMLNetworkEvent.ClientConnectedToServerEvent evt) {
        if (!evt.isLocal) {
            isMaster = false;
            isLocal = false;
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent evt) {
        for (EntityPlayerMP player : playersToInitialize) {
            NetworkIdRegistry.sendAllIdsTo(player);
        }
        playersToInitialize.clear();
    }

    static {
        isLocal = false;
        isMaster = false;
        idMap = HashBiMap.create();
        playersToInitialize = new LinkedList();
        idMap.put((Object)"", (Object)0);
        idMap.put((Object)NetworkIdRegistry.class.getCanonicalName(), (Object)1);
        idMap.put((Object)String.class.getCanonicalName(), (Object)2);
        idMap.put((Object)Integer.class.getCanonicalName(), (Object)3);
    }
}

