/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.network.ISyncedTile;
import buildcraft.core.network.ISynchronizedTile;
import buildcraft.core.network.PacketRPC;
import buildcraft.core.network.PacketTileState;
import buildcraft.core.network.PacketTileUpdate;
import buildcraft.core.proxy.CoreProxy;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

@ChannelHandler.Sharable
public class PacketHandler
extends SimpleChannelInboundHandler<BuildCraftPacket> {
    private void onTileUpdate(EntityPlayer player, PacketTileUpdate packet) throws IOException {
        World world = player.field_70170_p;
        if (!packet.targetExists(world)) {
            return;
        }
        TileEntity entity = packet.getTarget(world);
        if (!(entity instanceof ISynchronizedTile)) {
            return;
        }
        ISynchronizedTile tile = (ISynchronizedTile)entity;
        tile.handleUpdatePacket(packet);
        tile.postPacketHandling(packet);
    }

    protected void channelRead0(ChannelHandlerContext ctx, BuildCraftPacket packet) {
        try {
            INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
            EntityPlayer player = CoreProxy.proxy.getPlayerFromNetHandler(netHandler);
            int packetID = packet.getID();
            switch (packetID) {
                case 0: {
                    this.onTileUpdate(player, (PacketTileUpdate)packet);
                    break;
                }
                case 100: {
                    PacketTileState pkt = (PacketTileState)packet;
                    World world = player.field_70170_p;
                    TileEntity tile = world.func_147438_o(pkt.posX, pkt.posY, pkt.posZ);
                    if (!(tile instanceof ISyncedTile)) break;
                    pkt.applyStates((ISyncedTile)tile);
                    break;
                }
                case 80: {
                    break;
                }
                case 81: {
                    break;
                }
                case 110: {
                    ((PacketRPC)packet).call(player);
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

