/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.network.PacketRPCPart;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;

public abstract class PacketRPC
extends BuildCraftPacket {
    public static HashMap<Integer, ByteBuf> bufferedPackets = new HashMap();
    public static int GLOBAL_ID = new Random(new Date().getTime()).nextInt();
    protected int id = GLOBAL_ID++;
    protected ByteBuf contents;

    @Override
    public final int getID() {
        return 110;
    }

    public void call(EntityPlayer sender) {
        ByteBuf data;
        if (bufferedPackets.containsKey(this.id) && (data = bufferedPackets.remove(this.id)) != null) {
            this.contents = data.writeBytes(this.contents);
        }
    }

    public ArrayList<PacketRPC> breakIntoSmallerPackets(int maxSize) {
        ArrayList<PacketRPC> messages = new ArrayList<PacketRPC>();
        if (this.contents.readableBytes() < maxSize) {
            messages.add(this);
            return messages;
        }
        int start = 0;
        do {
            ByteBuf subContents = this.contents.readBytes(this.contents.readableBytes() > maxSize ? maxSize : this.contents.readableBytes());
            PacketRPCPart subPacket = new PacketRPCPart();
            subPacket.id = this.id;
            subPacket.contents = subContents;
            messages.add(subPacket);
            start += maxSize;
        } while (this.contents.readableBytes() != 0);
        this.contents = Unpooled.buffer();
        messages.add(this);
        return messages;
    }

    @Override
    public void readData(ByteBuf data) {
        this.id = data.readInt();
        int length = data.readInt();
        this.contents = Unpooled.buffer((int)length);
        data.readBytes(this.contents, length);
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeInt(this.id);
        data.writeInt(this.contents.readableBytes());
        data.writeBytes(this.contents);
    }
}

