/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.network.NetworkIdRegistry;
import buildcraft.core.network.PacketRPC;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.network.RPCMessageInfo;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;

public class PacketRPCStatic
extends PacketRPC {
    private String classId;
    private Class<?> clas;

    public PacketRPCStatic() {
    }

    public PacketRPCStatic(Class iClass, ByteBuf bytes) {
        this.contents = bytes;
        this.clas = iClass;
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        this.classId = NetworkIdRegistry.read(data);
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        NetworkIdRegistry.write(data, this.clas.getCanonicalName());
    }

    @Override
    public void call(EntityPlayer sender) {
        super.call(sender);
        RPCMessageInfo info = new RPCMessageInfo();
        info.sender = sender;
        try {
            RPCHandler.receiveStaticRPC(Class.forName(this.classId), info, this.contents);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

