/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.network.PacketRPC;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.network.RPCMessageInfo;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class PacketRPCTile
extends PacketRPC {
    public TileEntity tile;
    int dimId;
    int x;
    int y;
    int z;

    public PacketRPCTile() {
    }

    public PacketRPCTile(TileEntity tile, ByteBuf bytes) {
        this.tile = tile;
        this.contents = bytes;
    }

    public void setTile(TileEntity aTile) {
        this.tile = aTile;
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        this.dimId = data.readShort();
        this.x = data.readInt();
        this.y = data.readShort();
        this.z = data.readInt();
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        data.writeShort(this.tile.func_145831_w().field_73011_w.field_76574_g);
        data.writeInt(this.tile.field_145851_c);
        data.writeShort(this.tile.field_145848_d);
        data.writeInt(this.tile.field_145849_e);
    }

    @Override
    public void call(EntityPlayer sender) {
        World world = null;
        if (!sender.field_70170_p.field_72995_K) {
            world = DimensionManager.getProvider((int)this.dimId).field_76579_a;
        } else if (sender.field_70170_p.field_73011_w.field_76574_g == this.dimId) {
            world = sender.field_70170_p;
        }
        TileEntity localTile = world.func_147438_o(this.x, this.y, this.z);
        this.setTile(localTile);
        RPCMessageInfo info = new RPCMessageInfo();
        info.sender = sender;
        RPCHandler.receiveRPC(localTile, info, this.contents);
    }
}

