/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.network.IClientState;
import buildcraft.core.network.ISyncedTile;
import buildcraft.core.network.PacketCoordinates;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class PacketTileState
extends PacketCoordinates {
    private ByteBuf state;
    private List<StateWithId> stateList = new LinkedList<StateWithId>();

    public PacketTileState() {
    }

    public PacketTileState(int x, int y, int z) {
        super(100, x, y, z);
        this.isChunkDataPacket = true;
    }

    @Override
    public int getID() {
        return 100;
    }

    public void applyStates(ISyncedTile tile) throws IOException {
        int stateCount = this.state.readByte();
        for (int i = 0; i < stateCount; ++i) {
            byte stateId = this.state.readByte();
            tile.getStateInstance(stateId).readData(this.state);
            tile.afterStateUpdated(stateId);
        }
    }

    public void addStateForSerialization(byte stateId, IClientState state) {
        this.stateList.add(new StateWithId(stateId, state));
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        ByteBuf tmpState = Unpooled.buffer();
        tmpState.writeByte(this.stateList.size());
        for (StateWithId stateWithId : this.stateList) {
            tmpState.writeByte((int)stateWithId.stateId);
            stateWithId.state.writeData(tmpState);
        }
        data.writeShort((int)((short)tmpState.readableBytes()));
        data.writeBytes(tmpState.readBytes(tmpState.readableBytes()));
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        this.state = Unpooled.buffer();
        int length = data.readUnsignedShort();
        this.state.writeBytes(data.readBytes(length));
    }

    private class StateWithId {
        public byte stateId;
        public IClientState state;

        public StateWithId(byte stateId, IClientState state) {
            this.stateId = stateId;
            this.state = state;
        }
    }
}

