/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.JavaTools;
import buildcraft.core.DefaultProps;
import buildcraft.core.network.PacketRPC;
import buildcraft.core.network.PacketRPCEntity;
import buildcraft.core.network.PacketRPCGui;
import buildcraft.core.network.PacketRPCPipe;
import buildcraft.core.network.PacketRPCStatic;
import buildcraft.core.network.PacketRPCTile;
import buildcraft.core.network.RPC;
import buildcraft.core.network.RPCMessageInfo;
import buildcraft.core.network.serializers.ClassMapping;
import buildcraft.core.network.serializers.ClassSerializer;
import buildcraft.core.network.serializers.SerializationContext;
import buildcraft.core.utils.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public final class RPCHandler {
    public static int MAX_PACKET_SIZE = 30720;
    private static Map<String, RPCHandler> handlers = new TreeMap<String, RPCHandler>();
    private Class<? extends Object> handledClass;
    private Map<String, Integer> methodsMap = new TreeMap<String, Integer>();
    private MethodMapping[] methods;

    private RPCHandler(Class<? extends Object> c) {
        this.handledClass = c;
        Method[] sortedMethods = JavaTools.getAllMethods(c).toArray(new Method[0]);
        LinkedList<MethodMapping> mappings = new LinkedList<MethodMapping>();
        Arrays.sort(sortedMethods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        LinkedList<Method> rpcMethods = new LinkedList<Method>();
        for (Method sortedMethod : sortedMethods) {
            if (sortedMethod.getAnnotation(RPC.class) == null) continue;
            sortedMethod.setAccessible(true);
            this.methodsMap.put(sortedMethod.getName(), rpcMethods.size());
            rpcMethods.add(sortedMethod);
            MethodMapping mapping = new MethodMapping();
            mapping.method = sortedMethod;
            mapping.parameters = sortedMethod.getParameterTypes();
            mapping.mappings = new ClassSerializer[mapping.parameters.length];
            for (int j = 0; j < mapping.parameters.length; ++j) {
                if (mapping.parameters[j].equals(RPCMessageInfo.class)) {
                    mapping.hasInfo = true;
                    continue;
                }
                mapping.mappings[j] = ClassMapping.get(mapping.parameters[j]);
            }
            mappings.add(mapping);
        }
        this.methods = mappings.toArray(new MethodMapping[mappings.size()]);
    }

    private static RPCHandler getHandler(Object object) {
        Class<?> clas = object instanceof Class ? (Class<?>)object : object.getClass();
        if (!handlers.containsKey(clas.getName())) {
            handlers.put(clas.getName(), new RPCHandler(clas));
        }
        return handlers.get(clas.getName());
    }

    public static void rpcServer(Object object, String method, Object ... actuals) {
        PacketRPC packet = RPCHandler.createPacket(object, method, actuals);
        if (packet != null) {
            for (PacketRPC p : packet.breakIntoSmallerPackets(MAX_PACKET_SIZE)) {
                BuildCraftCore.instance.sendToServer(p);
            }
        }
    }

    public static void rpcPlayer(EntityPlayer player, Object object, String method, Object ... actuals) {
        PacketRPC packet = RPCHandler.createPacket(object, method, actuals);
        if (packet != null) {
            for (PacketRPC p : packet.breakIntoSmallerPackets(MAX_PACKET_SIZE)) {
                BuildCraftCore.instance.sendToPlayer(player, p);
            }
        }
    }

    public static void rpcBroadcastWorldPlayers(World world, Object object, String method, Object ... actuals) {
        RPCHandler.rpcBroadcastPlayersAtDistance(world, object, method, DefaultProps.NETWORK_UPDATE_RANGE, actuals);
    }

    public static void rpcBroadcastPlayersAtDistance(World world, Object object, String method, int maxDistance, Object ... actuals) {
        block4: {
            PacketRPC packet = RPCHandler.createPacket(object, method, actuals);
            if (packet == null) break block4;
            if (packet instanceof PacketRPCTile) {
                TileEntity tile = (TileEntity)object;
                for (PacketRPC p : packet.breakIntoSmallerPackets(MAX_PACKET_SIZE)) {
                    BuildCraftCore.instance.sendToPlayers(p, world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, maxDistance);
                }
            } else {
                for (PacketRPC p : packet.breakIntoSmallerPackets(MAX_PACKET_SIZE)) {
                    BuildCraftCore.instance.sendToWorld(p, world);
                }
            }
        }
    }

    public static void rpcBroadcastAllPlayers(Object object, String method, Object ... actuals) {
        PacketRPC packet = RPCHandler.createPacket(object, method, actuals);
        if (packet != null) {
            for (PacketRPC p : packet.breakIntoSmallerPackets(MAX_PACKET_SIZE)) {
                BuildCraftCore.instance.sendToAll(p);
            }
        }
    }

    public static void receiveStaticRPC(Class clas, RPCMessageInfo info, ByteBuf data) {
        if (clas != null) {
            RPCHandler.getHandler(clas).internalRpcReceive(clas, info, data);
        }
    }

    public static void receiveRPC(Object obj, RPCMessageInfo info, ByteBuf data) {
        if (obj != null) {
            RPCHandler.getHandler(obj.getClass()).internalRpcReceive(obj, info, data);
        }
    }

    private PacketRPCPipe createRCPPacketPipe(Pipe<?> pipe, String method, Object ... actuals) {
        ByteBuf data = Unpooled.buffer();
        try {
            TileGenericPipe tile = pipe.container;
            data.writeShort(tile.func_145831_w().field_73011_w.field_76574_g);
            data.writeInt(tile.field_145851_c);
            data.writeInt(tile.field_145848_d);
            data.writeInt(tile.field_145849_e);
            this.writeParameters(method, data, actuals);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        byte[] bytes = new byte[data.readableBytes()];
        data.readBytes(bytes);
        return new PacketRPCPipe(bytes);
    }

    private static PacketRPC createPacket(Object object, String method, Object ... actuals) {
        PacketRPC packet = null;
        if (object instanceof Container) {
            packet = RPCHandler.getHandler(object).createRCPPacketContainer(method, actuals);
        } else if (object instanceof TileEntity) {
            packet = RPCHandler.getHandler(object).createRCPPacketTile((TileEntity)object, method, actuals);
        } else if (object instanceof Entity) {
            packet = RPCHandler.getHandler(object).createRCPPacketEntity((Entity)object, method, actuals);
        } else if (object instanceof Class) {
            packet = RPCHandler.getHandler(object).createRCPPacketStatic((Class)object, method, actuals);
        }
        return packet;
    }

    private ByteBuf getBytes(String method, Object ... actuals) {
        ByteBuf data = Unpooled.buffer();
        try {
            this.writeParameters(method, data, actuals);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return data;
    }

    private PacketRPCTile createRCPPacketTile(TileEntity tile, String method, Object ... actuals) {
        return new PacketRPCTile(tile, this.getBytes(method, actuals));
    }

    private PacketRPCGui createRCPPacketContainer(String method, Object ... actuals) {
        return new PacketRPCGui(this.getBytes(method, actuals));
    }

    private PacketRPCEntity createRCPPacketEntity(Entity entity, String method, Object ... actuals) {
        return new PacketRPCEntity(entity, this.getBytes(method, actuals));
    }

    private PacketRPC createRCPPacketStatic(Class<?> clas, String method, Object[] actuals) {
        return new PacketRPCStatic(clas, this.getBytes(method, actuals));
    }

    private void writeParameters(String method, ByteBuf data, Object ... actuals) throws IOException, IllegalArgumentException, IllegalAccessException {
        int expectedParameters;
        if (!this.methodsMap.containsKey(method)) {
            throw new RuntimeException(method + " is not a callable method of " + this.handledClass.getName());
        }
        int methodIndex = this.methodsMap.get(method);
        MethodMapping m = this.methods[methodIndex];
        Class<?>[] formals = m.parameters;
        int n = expectedParameters = m.hasInfo ? formals.length - 1 : formals.length;
        if (expectedParameters != actuals.length) {
            throw new RuntimeException(this.getClass().getName() + "." + method + " expects " + m.parameters.length + " parameters, not " + actuals.length);
        }
        data.writeShort(methodIndex);
        SerializationContext context = new SerializationContext();
        for (int i = 0; i < actuals.length; ++i) {
            if (this.writePrimitive(data, formals[i], actuals[i])) continue;
            m.mappings[i].write(data, actuals[i], context);
        }
    }

    private boolean writePrimitive(ByteBuf data, Class<?> formal, Object actual) {
        if (Integer.TYPE.equals(formal)) {
            data.writeInt(((Integer)actual).intValue());
        } else if (Float.TYPE.equals(formal)) {
            data.writeFloat(((Float)actual).floatValue());
        } else if (Double.TYPE.equals(formal)) {
            data.writeDouble(((Double)actual).doubleValue());
        } else if (Character.TYPE.equals(formal)) {
            data.writeChar((int)((Character)actual).charValue());
        } else if (Boolean.TYPE.equals(formal)) {
            data.writeBoolean(((Boolean)actual).booleanValue());
        } else if (String.class.equals(formal)) {
            Utils.writeUTF(data, (String)actual);
        } else if (Enum.class.isAssignableFrom(formal)) {
            data.writeByte((int)((byte)((Enum)actual).ordinal()));
        } else {
            return false;
        }
        return true;
    }

    private void internalRpcReceive(Object o, RPCMessageInfo info, ByteBuf data) {
        if (data.readableBytes() <= 0) {
            return;
        }
        try {
            short methodIndex = data.readShort();
            MethodMapping m = this.methods[methodIndex];
            Class<?>[] formals = m.parameters;
            Object[] actuals = new Object[formals.length];
            int expectedParameters = m.hasInfo ? formals.length - 1 : formals.length;
            SerializationContext context = new SerializationContext();
            for (int i = 0; i < expectedParameters; ++i) {
                if (this.readPrimitive(data, formals[i], actuals, i)) continue;
                actuals[i] = m.mappings[i].read(data, actuals[i], context);
            }
            if (m.hasInfo) {
                actuals[actuals.length - 1] = info;
            }
            m.method.invoke(o, actuals);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private boolean readPrimitive(ByteBuf data, Class<?> formal, Object[] actuals, int i) {
        if (Integer.TYPE.equals(formal)) {
            actuals[i] = data.readInt();
        } else if (Float.TYPE.equals(formal)) {
            actuals[i] = Float.valueOf(data.readFloat());
        } else if (Double.TYPE.equals(formal)) {
            actuals[i] = data.readDouble();
        } else if (Character.TYPE.equals(formal)) {
            actuals[i] = Character.valueOf(data.readChar());
        } else if (Boolean.TYPE.equals(formal)) {
            actuals[i] = data.readBoolean();
        } else if (String.class.equals(formal)) {
            actuals[i] = Utils.readUTF(data);
        } else if (Enum.class.isAssignableFrom(formal)) {
            actuals[i] = formal.getEnumConstants()[data.readByte()];
        } else {
            return false;
        }
        return true;
    }

    class MethodMapping {
        Method method;
        Class<?>[] parameters;
        ClassSerializer[] mappings;
        boolean hasInfo = false;

        MethodMapping() {
        }
    }
}

