/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network.serializers;

import buildcraft.api.core.JavaTools;
import buildcraft.api.core.NetworkData;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.core.network.INBTSerializable;
import buildcraft.core.network.NetworkIdRegistry;
import buildcraft.core.network.serializers.ClassSerializer;
import buildcraft.core.network.serializers.SerializationContext;
import buildcraft.core.network.serializers.SerializerArrayList;
import buildcraft.core.network.serializers.SerializerBitSet;
import buildcraft.core.network.serializers.SerializerBlock;
import buildcraft.core.network.serializers.SerializerFluidStack;
import buildcraft.core.network.serializers.SerializerHashMap;
import buildcraft.core.network.serializers.SerializerHashSet;
import buildcraft.core.network.serializers.SerializerINBTSerializable;
import buildcraft.core.network.serializers.SerializerIStatementParameter;
import buildcraft.core.network.serializers.SerializerInteger;
import buildcraft.core.network.serializers.SerializerItem;
import buildcraft.core.network.serializers.SerializerItemStack;
import buildcraft.core.network.serializers.SerializerLinkedList;
import buildcraft.core.network.serializers.SerializerLong;
import buildcraft.core.network.serializers.SerializerNBT;
import buildcraft.core.network.serializers.SerializerString;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class ClassMapping
extends ClassSerializer {
    private static Map<String, ClassSerializer> classes = new TreeMap<String, ClassSerializer>();
    private LinkedList<Field> floatFields = new LinkedList();
    private LinkedList<Field> doubleFields = new LinkedList();
    private LinkedList<Field> shortFields = new LinkedList();
    private LinkedList<Field> intFields = new LinkedList();
    private LinkedList<Field> booleanFields = new LinkedList();
    private LinkedList<Field> enumFields = new LinkedList();
    private LinkedList<FieldObject> objectFields = new LinkedList();
    private CptType cptType;
    private ClassSerializer cptMapping;

    public void analyzeClass(Class<? extends Object> c) {
        try {
            if (c.isArray()) {
                Class<?> cptClass = c.getComponentType();
                if (Byte.TYPE.equals(cptClass)) {
                    this.cptType = CptType.Byte;
                } else if (Float.TYPE.equals(cptClass)) {
                    this.cptType = CptType.Float;
                } else if (Double.TYPE.equals(cptClass)) {
                    this.cptType = CptType.Double;
                } else if (Short.TYPE.equals(cptClass)) {
                    this.cptType = CptType.Short;
                } else if (Integer.TYPE.equals(cptClass)) {
                    this.cptType = CptType.Int;
                } else if (Boolean.TYPE.equals(cptClass)) {
                    this.cptType = CptType.Byte;
                } else if (Character.TYPE.equals(cptClass)) {
                    this.cptType = CptType.Char;
                } else if (Enum.class.isAssignableFrom(cptClass)) {
                    this.cptType = CptType.Enum;
                } else {
                    this.cptType = CptType.Object;
                    this.cptMapping = ClassMapping.get(cptClass);
                }
            } else {
                List<Field> fields = JavaTools.getAllFields(c);
                for (Field f : fields) {
                    if (!this.isSynchronizedField(f)) continue;
                    f.setAccessible(true);
                    Class<?> t = f.getType();
                    if (!(t instanceof Class)) continue;
                    Class<?> fieldClass = t;
                    if (Short.TYPE.equals(fieldClass)) {
                        this.shortFields.add(f);
                        continue;
                    }
                    if (Integer.TYPE.equals(fieldClass)) {
                        this.intFields.add(f);
                        continue;
                    }
                    if (Boolean.TYPE.equals(fieldClass)) {
                        this.booleanFields.add(f);
                        continue;
                    }
                    if (Enum.class.isAssignableFrom(fieldClass)) {
                        this.enumFields.add(f);
                        continue;
                    }
                    if (Float.TYPE.equals(fieldClass)) {
                        this.floatFields.add(f);
                        continue;
                    }
                    if (Double.TYPE.equals(fieldClass)) {
                        this.doubleFields.add(f);
                        continue;
                    }
                    if (Character.TYPE.equals(fieldClass)) {
                        this.doubleFields.add(f);
                        continue;
                    }
                    FieldObject obj = new FieldObject();
                    obj.mapping = ClassMapping.get(fieldClass);
                    obj.field = f;
                    this.objectFields.add(obj);
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private boolean isSynchronizedField(Field f) {
        NetworkData updateAnnotation = f.getAnnotation(NetworkData.class);
        return updateAnnotation != null;
    }

    @Override
    public void write(ByteBuf data, Object o, SerializationContext context) throws IllegalArgumentException, IllegalAccessException {
        if (o == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            if (this.mappedClass.isArray()) {
                this.writeArray(o, data, context);
            } else {
                this.writeClass(o, data, context);
            }
        }
    }

    @Override
    public Object read(ByteBuf data, Object o, SerializationContext context) throws IllegalArgumentException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (!data.readBoolean()) {
            return null;
        }
        if (this.mappedClass.isArray()) {
            return this.readArray(o, data, context);
        }
        return this.readClass(o, data, context);
    }

    void writeClass(Object obj, ByteBuf data, SerializationContext context) throws IllegalArgumentException, IllegalAccessException {
        Class<?> realClass = obj.getClass();
        if (!realClass.equals(this.mappedClass)) {
            data.writeBoolean(false);
            NetworkIdRegistry.write(data, realClass.getCanonicalName());
            ClassMapping delegateMapping = (ClassMapping)ClassMapping.get(realClass);
            delegateMapping.writeClass(obj, data, context);
            return;
        }
        data.writeBoolean(true);
        for (Field field : this.shortFields) {
            data.writeShort((int)field.getShort(obj));
        }
        for (Field field : this.intFields) {
            data.writeInt(field.getInt(obj));
        }
        for (Field field : this.booleanFields) {
            data.writeBoolean(field.getBoolean(obj));
        }
        for (Field field : this.enumFields) {
            if (field.get(obj) == null) {
                data.writeBoolean(false);
                continue;
            }
            data.writeBoolean(true);
            data.writeByte(((Enum)field.get(obj)).ordinal());
        }
        for (Field field : this.floatFields) {
            data.writeFloat(field.getFloat(obj));
        }
        for (Field field : this.doubleFields) {
            data.writeDouble(field.getDouble(obj));
        }
        for (FieldObject fieldObject : this.objectFields) {
            Object cpt = fieldObject.field.get(obj);
            fieldObject.mapping.write(data, cpt, context);
        }
    }

    Object readClass(Object objI, ByteBuf data, SerializationContext context) throws IllegalArgumentException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        Object obj = objI;
        if (!data.readBoolean()) {
            String className = NetworkIdRegistry.read(data);
            Class<?> clazz = Class.forName(className);
            ClassMapping delegateMapping = (ClassMapping)ClassMapping.get(clazz);
            return delegateMapping.readClass(obj, data, context);
        }
        if (obj == null) {
            obj = this.mappedClass.newInstance();
        }
        for (Field field : this.shortFields) {
            field.setShort(obj, data.readShort());
        }
        for (Field field : this.intFields) {
            field.setInt(obj, data.readInt());
        }
        for (Field field : this.booleanFields) {
            field.setBoolean(obj, data.readBoolean());
        }
        for (Field field : this.enumFields) {
            if (!data.readBoolean()) continue;
            field.set(obj, ((Class)field.getGenericType()).getEnumConstants()[data.readByte()]);
        }
        for (Field field : this.floatFields) {
            field.setFloat(obj, data.readFloat());
        }
        for (Field field : this.doubleFields) {
            field.setDouble(obj, data.readDouble());
        }
        for (FieldObject fieldObject : this.objectFields) {
            fieldObject.field.set(obj, fieldObject.mapping.read(data, fieldObject.field.get(obj), context));
        }
        return obj;
    }

    private void writeArray(Object obj, ByteBuf data, SerializationContext context) throws IllegalArgumentException, IllegalAccessException {
        switch (this.cptType) {
            case Byte: {
                byte[] arr = (byte[])obj;
                data.writeInt(arr.length);
                data.writeBytes(arr);
                break;
            }
            case Float: {
                float[] arr = (float[])obj;
                data.writeInt(arr.length);
                for (float element : arr) {
                    data.writeFloat(element);
                }
                break;
            }
            case Double: {
                double[] arr = (double[])obj;
                data.writeInt(arr.length);
                for (double element : arr) {
                    data.writeDouble(element);
                }
                break;
            }
            case Short: {
                short[] arr = (short[])obj;
                data.writeInt(arr.length);
                for (short element : arr) {
                    data.writeShort((int)element);
                }
                break;
            }
            case Int: {
                int[] arr = (int[])obj;
                data.writeInt(arr.length);
                for (int element : arr) {
                    data.writeInt(element);
                }
                break;
            }
            case Boolean: {
                boolean[] arr = (boolean[])obj;
                data.writeInt(arr.length);
                for (boolean element : arr) {
                    data.writeBoolean(element);
                }
                break;
            }
            case Char: {
                char[] arr = (char[])obj;
                data.writeInt(arr.length);
                for (char element : arr) {
                    data.writeChar((int)element);
                }
                break;
            }
            case Enum: {
                Enum[] arr = (Enum[])obj;
                data.writeInt(arr.length);
                for (Enum element : arr) {
                    data.writeBoolean(element != null);
                    if (element == null) continue;
                    data.writeByte(element.ordinal());
                }
                break;
            }
            case Object: {
                Object[] arr = (Object[])obj;
                data.writeInt(arr.length);
                for (Object element : arr) {
                    this.cptMapping.write(data, element, context);
                }
                break;
            }
        }
    }

    private Object readArray(Object objI, ByteBuf data, SerializationContext context) throws IllegalArgumentException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        Object[] obj = objI;
        Class<?> cpt = this.mappedClass.getComponentType();
        int size = data.readInt();
        switch (this.cptType) {
            case Byte: {
                byte[] arr = obj == null ? new byte[size] : (byte[])obj;
                data.readBytes(arr);
                obj = arr;
                break;
            }
            case Float: {
                float[] arr = obj == null ? new float[size] : (float[])obj;
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = data.readFloat();
                }
                obj = arr;
                break;
            }
            case Double: {
                double[] arr = obj == null ? new double[size] : (double[])obj;
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = data.readDouble();
                }
                obj = arr;
                break;
            }
            case Short: {
                short[] arr = obj == null ? new short[size] : (short[])obj;
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = data.readShort();
                }
                obj = arr;
                break;
            }
            case Int: {
                int[] arr = obj == null ? new int[size] : (int[])obj;
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = data.readInt();
                }
                obj = arr;
                break;
            }
            case Boolean: {
                boolean[] arr = obj == null ? new boolean[size] : (boolean[])obj;
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = data.readBoolean();
                }
                obj = arr;
                break;
            }
            case Char: {
                char[] arr = obj == null ? new char[size] : (char[])obj;
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = data.readChar();
                }
                obj = arr;
                break;
            }
            case Enum: {
                Enum[] arr = obj == null ? new Enum[size] : (Enum[])obj;
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = data.readBoolean() ? (Enum)cpt.getEnumConstants()[data.readByte()] : null;
                }
                obj = arr;
                break;
            }
            case Object: {
                Object[] arr = obj == null ? (Object[])Array.newInstance(cpt, size) : (Object[])obj;
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = this.cptMapping.read(data, arr[i], context);
                }
                obj = arr;
                break;
            }
        }
        return obj;
    }

    private static void registerSerializer(Class<?> clas, ClassSerializer s) {
        try {
            s.mappedClass = clas;
            classes.put(clas.getCanonicalName(), s);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Can't register " + clas.getCanonicalName() + " in serializers");
        }
    }

    public static ClassSerializer get(Class<?> clas) {
        ClassSerializer mapping;
        if (Block.class.isAssignableFrom(clas)) {
            mapping = classes.get(Block.class.getCanonicalName());
        } else if (Item.class.isAssignableFrom(clas)) {
            mapping = classes.get(Item.class.getCanonicalName());
        } else if (INBTSerializable.class.isAssignableFrom(clas)) {
            mapping = classes.get(INBTSerializable.class.getCanonicalName());
        } else if (!classes.containsKey(clas.getCanonicalName())) {
            mapping = new ClassMapping();
            ClassMapping.registerSerializer(clas, mapping);
            ((ClassMapping)mapping).analyzeClass(clas);
        } else {
            mapping = classes.containsKey(clas.getCanonicalName()) ? classes.get(clas.getCanonicalName()) : null;
        }
        return mapping;
    }

    static {
        ClassMapping.registerSerializer(String.class, new SerializerString());
        ClassMapping.registerSerializer(HashMap.class, new SerializerHashMap());
        ClassMapping.registerSerializer(HashSet.class, new SerializerHashSet());
        ClassMapping.registerSerializer(LinkedList.class, new SerializerLinkedList());
        ClassMapping.registerSerializer(ArrayList.class, new SerializerArrayList());
        ClassMapping.registerSerializer(Block.class, new SerializerBlock());
        ClassMapping.registerSerializer(Item.class, new SerializerItem());
        ClassMapping.registerSerializer(NBTTagCompound.class, new SerializerNBT());
        ClassMapping.registerSerializer(ItemStack.class, new SerializerItemStack());
        ClassMapping.registerSerializer(FluidStack.class, new SerializerFluidStack());
        ClassMapping.registerSerializer(Integer.class, new SerializerInteger());
        ClassMapping.registerSerializer(Long.class, new SerializerLong());
        ClassMapping.registerSerializer(BitSet.class, new SerializerBitSet());
        ClassMapping.registerSerializer(INBTSerializable.class, new SerializerINBTSerializable());
        ClassMapping.registerSerializer(IStatementParameter.class, new SerializerIStatementParameter());
    }

    static enum CptType {
        Byte,
        Float,
        Double,
        Short,
        Int,
        Char,
        Boolean,
        Enum,
        Object;

    }

    class FieldObject {
        public Field field;
        public ClassSerializer mapping;

        FieldObject() {
        }
    }
}

