/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network.serializers;

import buildcraft.core.network.serializers.ClassSerializer;
import buildcraft.core.network.serializers.SerializationContext;
import buildcraft.core.utils.BitSetUtils;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;

public class SerializerBitSet
extends ClassSerializer {
    @Override
    public void write(ByteBuf data, Object o, SerializationContext context) {
        if (o == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            BitSet set = (BitSet)o;
            byte[] bytes = BitSetUtils.toByteArray(set);
            data.writeInt(bytes.length);
            data.writeBytes(bytes);
        }
    }

    @Override
    public Object read(ByteBuf data, Object o, SerializationContext context) {
        if (!data.readBoolean()) {
            return null;
        }
        int actualSize = data.readInt();
        byte[] bytes = new byte[actualSize];
        data.readBytes(bytes);
        BitSet set = BitSetUtils.fromByteArray(bytes);
        return set;
    }
}

