/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network.serializers;

import buildcraft.core.network.serializers.ClassSerializer;
import buildcraft.core.network.serializers.SerializationContext;
import buildcraft.core.network.serializers.SerializerObject;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;

public class SerializerHashSet
extends ClassSerializer {
    private static SerializerObject anonymousSerializer = new SerializerObject();

    @Override
    public void write(ByteBuf data, Object o, SerializationContext context) throws IllegalArgumentException, IllegalAccessException {
        HashSet set = (HashSet)o;
        if (o == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            data.writeShort(set.size());
            for (Object item : set) {
                anonymousSerializer.write(data, item, context);
            }
        }
    }

    @Override
    public Object read(ByteBuf data, Object o, SerializationContext context) throws IllegalArgumentException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (!data.readBoolean()) {
            return null;
        }
        int size = data.readShort();
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < size; ++i) {
            Object value = anonymousSerializer.read(data, null, context);
            set.add(value);
        }
        return set;
    }
}

