/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network.serializers;

import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementManager;
import buildcraft.core.network.serializers.ClassSerializer;
import buildcraft.core.network.serializers.SerializationContext;
import buildcraft.core.utils.Utils;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;

public class SerializerIStatementParameter
extends ClassSerializer {
    @Override
    public void write(ByteBuf data, Object o, SerializationContext context) {
        IStatementParameter parameter = (IStatementParameter)o;
        if (parameter == null) {
            data.writeBoolean(false);
        } else {
            NBTTagCompound cpt = new NBTTagCompound();
            parameter.writeToNBT(cpt);
            data.writeBoolean(true);
            Utils.writeUTF(data, parameter.getUniqueTag());
            Utils.writeNBT(data, cpt);
        }
    }

    @Override
    public Object read(ByteBuf data, Object o, SerializationContext context) {
        if (!data.readBoolean()) {
            return null;
        }
        String kind = Utils.readUTF(data);
        IStatementParameter parameter = StatementManager.createParameter(kind);
        parameter.readFromNBT(Utils.readNBT(data));
        return parameter;
    }
}

