/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network.serializers;

import buildcraft.core.network.NetworkIdRegistry;
import buildcraft.core.network.serializers.ClassMapping;
import buildcraft.core.network.serializers.ClassSerializer;
import buildcraft.core.network.serializers.SerializationContext;
import io.netty.buffer.ByteBuf;

public class SerializerObject
extends ClassSerializer {
    @Override
    public void write(ByteBuf data, Object o, SerializationContext context) throws IllegalArgumentException, IllegalAccessException {
        if (o == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            Class<?> realClass = o.getClass();
            NetworkIdRegistry.write(data, realClass.getCanonicalName());
            ClassSerializer delegateMapping = ClassMapping.get(realClass);
            if (delegateMapping instanceof ClassMapping) {
                ((ClassMapping)delegateMapping).writeClass(o, data, context);
            } else {
                delegateMapping.write(data, o, context);
            }
        }
    }

    @Override
    public Object read(ByteBuf data, Object o, SerializationContext context) throws IllegalArgumentException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (!data.readBoolean()) {
            return null;
        }
        String className = NetworkIdRegistry.read(data);
        Class<?> cls = Class.forName(className);
        ClassSerializer delegateMapping = ClassMapping.get(cls);
        if (delegateMapping instanceof ClassMapping) {
            return ((ClassMapping)delegateMapping).readClass(o, data, context);
        }
        return delegateMapping.read(data, o, context);
    }
}

