/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.recipes;

import buildcraft.api.recipes.CraftingResult;
import buildcraft.api.recipes.IFlexibleCrafter;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.api.recipes.IFlexibleRecipeViewable;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.inventory.filters.ArrayStackFilter;
import buildcraft.core.inventory.filters.IStackFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FlexibleRecipe<T>
implements IFlexibleRecipe<T>,
IFlexibleRecipeViewable {
    public int energyCost = 0;
    public long craftingTime = 0L;
    public String id;
    public T output = null;
    public ArrayList<ItemStack> inputItems = new ArrayList();
    public ArrayList<List<ItemStack>> inputItemsWithAlternatives = new ArrayList();
    public ArrayList<FluidStack> inputFluids = new ArrayList();

    public FlexibleRecipe() {
    }

    public FlexibleRecipe(String id, T output, int iEnergyCost, long craftingTime, Object ... input) {
        this.setContents(id, output, iEnergyCost, craftingTime, input);
    }

    public void setContents(String iid, Object ioutput, int iEnergyCost, long iCraftingTime, Object ... input) {
        this.id = iid;
        if (ioutput == null) {
            throw new IllegalArgumentException("The output of FlexibleRecipe " + iid + " is null! Rejecting recipe.");
        }
        if (ioutput instanceof ItemStack) {
            this.output = ioutput;
        } else if (ioutput instanceof Item) {
            this.output = new ItemStack((Item)ioutput);
        } else if (ioutput instanceof Block) {
            this.output = new ItemStack((Block)ioutput);
        } else if (ioutput instanceof FluidStack) {
            this.output = ioutput;
        } else {
            throw new IllegalArgumentException("An unknown object passed to recipe " + iid + " as output! (" + ioutput.getClass() + ")");
        }
        this.energyCost = iEnergyCost;
        this.craftingTime = iCraftingTime;
        for (Object i : input) {
            if (i == null) {
                throw new IllegalArgumentException("An input of FlexibleRecipe " + iid + " is null! Rejecting recipe.");
            }
            if (i instanceof ItemStack) {
                this.inputItems.add((ItemStack)i);
                continue;
            }
            if (i instanceof Item) {
                this.inputItems.add(new ItemStack((Item)i));
                continue;
            }
            if (i instanceof Block) {
                this.inputItems.add(new ItemStack((Block)i));
                continue;
            }
            if (i instanceof FluidStack) {
                this.inputFluids.add((FluidStack)i);
                continue;
            }
            if (i instanceof List) {
                this.inputItemsWithAlternatives.add((List)i);
                continue;
            }
            throw new IllegalArgumentException("An unknown object passed to recipe " + iid + " as input! (" + i.getClass() + ")");
        }
    }

    @Override
    public boolean canBeCrafted(IFlexibleCrafter crafter) {
        return this.craft(crafter, true) != null;
    }

    @Override
    public CraftingResult<T> craft(IFlexibleCrafter crafter, boolean preview) {
        int amount;
        ArrayStackFilter filter;
        if (this.output == null) {
            return null;
        }
        CraftingResult result = new CraftingResult();
        result.recipe = this;
        result.energyCost = this.energyCost;
        result.craftingTime = this.craftingTime;
        for (ItemStack itemStack : this.inputItems) {
            filter = new ArrayStackFilter(itemStack);
            if (this.consumeItems(crafter, result, filter, amount = itemStack.field_77994_a, preview) == 0) continue;
            return null;
        }
        for (List list : this.inputItemsWithAlternatives) {
            filter = new ArrayStackFilter(list.toArray(new ItemStack[0]));
            if (this.consumeItems(crafter, result, filter, amount = ((ItemStack)list.get((int)0)).field_77994_a, preview) == 0) continue;
            return null;
        }
        for (FluidStack fluidStack : this.inputFluids) {
            int amount2 = fluidStack.amount;
            for (int tankid = 0; tankid < crafter.getCraftingFluidStackSize(); ++tankid) {
                FluidStack fluid = crafter.getCraftingFluidStack(tankid);
                if (fluid != null && fluid.isFluidEqual(fluidStack)) {
                    int amountUsed = 0;
                    if (fluid.amount > amount2) {
                        amountUsed = amount2;
                        if (!preview) {
                            crafter.decrCraftingFluidStack(tankid, amount2);
                        }
                        amount2 = 0;
                    } else {
                        amountUsed = fluid.amount;
                        if (!preview) {
                            crafter.decrCraftingFluidStack(tankid, fluid.amount);
                        }
                        amount2 -= fluid.amount;
                    }
                    result.usedFluids.add(new FluidStack(fluidStack.fluidID, amountUsed));
                }
                if (amount2 == 0) break;
            }
            if (amount2 == 0) continue;
            return null;
        }
        result.crafted = this.output;
        return result;
    }

    @Override
    public String getId() {
        return this.id;
    }

    private int consumeItems(IFlexibleCrafter crafter, CraftingResult<T> result, IStackFilter filter, int amount, boolean preview) {
        int expected = amount;
        for (int slotid = 0; slotid < crafter.getCraftingItemStackSize(); ++slotid) {
            ItemStack stack = crafter.getCraftingItemStack(slotid);
            if (stack != null && filter.matches(stack)) {
                ItemStack removed = null;
                if (stack.field_77994_a >= expected) {
                    if (preview) {
                        removed = stack.func_77946_l();
                        removed.field_77994_a = expected;
                    } else {
                        removed = crafter.decrCraftingItemgStack(slotid, expected);
                    }
                    expected = 0;
                } else {
                    removed = preview ? stack.func_77946_l() : crafter.decrCraftingItemgStack(slotid, stack.field_77994_a);
                    expected -= removed.field_77994_a;
                }
                result.usedItems.add(removed);
            }
            if (expected != 0) continue;
            return 0;
        }
        return amount;
    }

    @Override
    public CraftingResult<T> canCraft(ItemStack expectedOutput) {
        if (this.output instanceof ItemStack && StackHelper.isMatchingItem(expectedOutput, (ItemStack)this.output)) {
            CraftingResult result = new CraftingResult();
            result.recipe = this;
            result.usedFluids = this.inputFluids;
            result.usedItems = this.inputItems;
            result.crafted = this.output;
            return result;
        }
        return null;
    }

    @Override
    public Object getOutput() {
        return this.output;
    }

    @Override
    public Collection<Object> getInputs() {
        ArrayList<Object> inputs = new ArrayList<Object>();
        inputs.addAll(this.inputItems);
        inputs.addAll(this.inputItemsWithAlternatives);
        inputs.addAll(this.inputFluids);
        return inputs;
    }

    @Override
    public int getEnergyCost() {
        return this.energyCost;
    }

    @Override
    public long getCraftingTime() {
        return this.craftingTime;
    }
}

