/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.recipes;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.BCLog;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.api.recipes.IRefineryRecipeManager;
import buildcraft.core.recipes.FlexibleRecipe;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import net.minecraftforge.fluids.FluidStack;

public final class RefineryRecipeManager
implements IRefineryRecipeManager {
    public static final RefineryRecipeManager INSTANCE = new RefineryRecipeManager();
    private HashMap<String, IFlexibleRecipe<FluidStack>> recipes = new HashMap();

    private RefineryRecipeManager() {
    }

    @Override
    public void addRecipe(String id, FluidStack ingredient, FluidStack result, int energy, int delay) {
        String name = result.getFluid().getName();
        if (BuildCraftCore.recipesBlacklist.contains(name)) {
            return;
        }
        FlexibleRecipe<FluidStack> recipe = new FlexibleRecipe<FluidStack>(id, result, energy, delay, ingredient);
        this.recipes.put(id, recipe);
    }

    @Override
    public void addRecipe(String id, FluidStack ingredient1, FluidStack ingredient2, FluidStack result, int energy, int delay) {
        String name = result.getFluid().getName();
        if (BuildCraftCore.recipesBlacklist.contains(name)) {
            return;
        }
        if (ingredient1 == null || ingredient2 == null || result == null) {
            BCLog.logger.warn("Rejected refinery recipe " + id + " due to a null FluidStack!");
        }
        FlexibleRecipe<FluidStack> recipe = new FlexibleRecipe<FluidStack>(id, result, energy, delay, ingredient1, ingredient2);
        this.recipes.put(id, recipe);
    }

    @Override
    public Collection<IFlexibleRecipe<FluidStack>> getRecipes() {
        return Collections.unmodifiableCollection(this.recipes.values());
    }

    @Override
    public IFlexibleRecipe<FluidStack> getRecipe(String id) {
        return this.recipes.get(id);
    }

    @Override
    public void removeRecipe(IFlexibleRecipe<FluidStack> recipe) {
        this.removeRecipe(recipe.getId());
    }

    @Override
    public void removeRecipe(String id) {
        this.recipes.remove(id);
    }
}

