/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.InventoryCopy;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.ArrayStackFilter;
import buildcraft.core.inventory.filters.ArrayStackOrListFilter;
import buildcraft.core.inventory.filters.IStackFilter;
import buildcraft.core.robots.AIRobotCraftGeneric;
import buildcraft.core.robots.AIRobotGotoStationToLoad;
import buildcraft.core.robots.AIRobotLoad;
import buildcraft.core.robots.AIRobotSearchAndGotoStation;
import buildcraft.core.robots.DockingStation;
import buildcraft.core.robots.IStationFilter;
import buildcraft.silicon.statements.ActionRobotFilter;
import buildcraft.silicon.statements.ActionStationAllowCraft;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class AIRobotCraftWorkbench
extends AIRobotCraftGeneric {
    private IRecipe recipe;
    private int craftingTimer = 0;
    private ArrayList<ArrayStackFilter> requirements;
    private ItemStack output;

    public AIRobotCraftWorkbench(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotCraftWorkbench(EntityRobotBase iRobot, IRecipe iRecipe) {
        super(iRobot);
        this.recipe = iRecipe;
    }

    @Override
    public void start() {
        this.requirements = this.tryCraft(false);
        if (this.requirements == null) {
            this.terminate();
            return;
        }
    }

    @Override
    public void update() {
        if (this.recipe == null) {
            this.terminate();
            return;
        }
        if (this.craftingTimer > 0) {
            --this.craftingTimer;
            if (this.craftingTimer == 0) {
                this.craft();
                this.terminate();
            }
        } else if (this.requirements.size() > 0) {
            this.startDelegateAI(new AIRobotGotoStationToLoad(this.robot, new ReqStackFilter(), this.robot.getZoneToWork()));
        } else {
            this.startDelegateAI(new AIRobotSearchAndGotoStation(this.robot, new StationWorkbenchFilter(), this.robot.getZoneToWork()));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoStationToLoad) {
            if (ai.success()) {
                this.startDelegateAI(new AIRobotLoad(this.robot, new ReqStackFilter(), 1));
            } else {
                this.terminate();
            }
        } else if (ai instanceof AIRobotLoad) {
            this.requirements = this.tryCraft(false);
        } else if (ai instanceof AIRobotSearchAndGotoStation) {
            if (new StationWorkbenchFilter().matches((DockingStation)this.robot.getDockingStation())) {
                this.craftingTimer = 40;
            } else {
                this.terminate();
            }
        }
    }

    protected ArrayList<ArrayStackFilter> tryCraft(boolean doRemove) {
        Object[] items = new Object[]{};
        if (this.recipe instanceof ShapedRecipes) {
            items = ((ShapedRecipes)this.recipe).field_77574_d;
        } else if (this.recipe instanceof ShapelessRecipes) {
            items = ((ShapelessRecipes)this.recipe).field_77579_b.toArray();
        } else if (this.recipe instanceof ShapedOreRecipe) {
            items = ((ShapedOreRecipe)this.recipe).getInput();
        } else if (this.recipe instanceof ShapelessOreRecipe) {
            items = ((ShapelessOreRecipe)this.recipe).getInput().toArray();
        }
        ArrayList<ArrayStackFilter> result = new ArrayList<ArrayStackFilter>();
        IInventory inv = this.robot;
        if (!doRemove) {
            inv = new InventoryCopy(this.robot);
        }
        InventoryCrafting invCraft = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < items.length; ++i) {
            ArrayStackFilter filter;
            Object tmp = items[i];
            if (tmp == null) continue;
            int qty = 0;
            if (tmp instanceof ItemStack) {
                ItemStack stack = (ItemStack)tmp;
                qty = stack.field_77994_a;
                filter = new ArrayStackFilter(stack);
            } else {
                ArrayList stacks = (ArrayList)tmp;
                qty = ((ItemStack)stacks.get((int)0)).field_77994_a;
                filter = new ArrayStackFilter(stacks.toArray(new ItemStack[stacks.size()]));
            }
            for (IInvSlot s : InventoryIterator.getIterable(inv)) {
                if (!filter.matches(s.getStackInSlot())) continue;
                ItemStack removed = s.decreaseStackInSlot(qty);
                qty -= removed.field_77994_a;
                if (invCraft.func_70301_a(i) != null) {
                    invCraft.func_70301_a((int)i).field_77994_a += qty;
                } else {
                    invCraft.func_70299_a(i, removed);
                }
                invCraft.func_70299_a(i, removed);
                if (removed.field_77994_a != 0) continue;
                break;
            }
            if (qty <= 0) continue;
            result.add(filter);
        }
        if (result.size() == 0 && doRemove) {
            this.output = this.recipe.func_77572_b(invCraft);
        }
        return result;
    }

    private void craft() {
        if (this.tryCraft(true).size() == 0 && this.output != null) {
            this.crafted = true;
            ITransactor transactor = Transactor.getTransactorFor((Object)this.robot);
            transactor.add(this.output, ForgeDirection.UNKNOWN, true);
        }
    }

    @Override
    public int getEnergyCost() {
        return 30;
    }

    private class StationWorkbenchFilter
    implements IStationFilter {
        private StationWorkbenchFilter() {
        }

        @Override
        public boolean matches(DockingStation station) {
            if (!ActionRobotFilter.canInteractWithItem(station, new ArrayStackOrListFilter(AIRobotCraftWorkbench.this.recipe.func_77571_b()), ActionStationAllowCraft.class)) {
                return false;
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Block nearbyBlock = AIRobotCraftWorkbench.this.robot.field_70170_p.func_147439_a(station.x() + dir.offsetX, station.y() + dir.offsetY, station.z() + dir.offsetZ);
                if (!(nearbyBlock instanceof BlockWorkbench)) continue;
                return true;
            }
            return false;
        }
    }

    private class ReqStackFilter
    implements IStackFilter {
        private ReqStackFilter() {
        }

        @Override
        public boolean matches(ItemStack stack) {
            for (ArrayStackFilter s : AIRobotCraftWorkbench.this.requirements) {
                if (!s.matches(stack)) continue;
                return true;
            }
            return false;
        }
    }
}

