/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.IStackFilter;
import buildcraft.core.robots.AIRobotGotoStationToLoad;
import buildcraft.core.robots.DockingStation;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotFetchAndEquipItemStack
extends AIRobot {
    private IStackFilter filter;

    public AIRobotFetchAndEquipItemStack(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotFetchAndEquipItemStack(EntityRobotBase iRobot, IStackFilter iFilter) {
        super(iRobot);
        this.filter = iFilter;
    }

    @Override
    public void update() {
        this.startDelegateAI(new AIRobotGotoStationToLoad(this.robot, this.filter, null));
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (this.filter == null) {
            this.abort();
            return;
        }
        if (this.robot.getDockingStation() != null) {
            DockingStation station = (DockingStation)this.robot.getDockingStation();
            ItemStack itemFound = null;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                ITransactor trans;
                TileEntity nearbyTile = this.robot.field_70170_p.func_147438_o(station.x() + dir.offsetX, station.y() + dir.offsetY, station.z() + dir.offsetZ);
                if (nearbyTile != null && nearbyTile instanceof IInventory && (itemFound = (trans = Transactor.getTransactorFor(nearbyTile)).remove(this.filter, dir.getOpposite(), true)) != null) break;
            }
            if (itemFound != null) {
                this.robot.setItemInUse(itemFound);
                this.terminate();
            }
        }
        this.terminate();
    }
}

