/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.robots.AIRobotGotoBlock;
import buildcraft.core.robots.AIRobotStraightMoveTo;
import buildcraft.core.robots.DockingStation;

public class AIRobotGoAndLinkToDock
extends AIRobot {
    public DockingStation station;

    public AIRobotGoAndLinkToDock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGoAndLinkToDock(EntityRobotBase iRobot, DockingStation iStation) {
        super(iRobot);
        this.station = iStation;
    }

    @Override
    public void start() {
        if (this.station == this.robot.getLinkedStation() && this.station == this.robot.getDockingStation()) {
            this.terminate();
        } else if (this.station.takeAsMain(this.robot)) {
            this.startDelegateAI(new AIRobotGotoBlock(this.robot, this.station.x() + this.station.side.offsetX * 2, this.station.y() + this.station.side.offsetY * 2, this.station.z() + this.station.side.offsetZ * 2));
        } else {
            this.terminate();
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoBlock) {
            this.startDelegateAI(new AIRobotStraightMoveTo(this.robot, (float)this.station.x() + 0.5f + (float)this.station.side.offsetX * 0.5f, (float)this.station.y() + 0.5f + (float)this.station.side.offsetY * 0.5f, (float)this.station.z() + 0.5f + (float)this.station.side.offsetZ * 0.5f));
        } else {
            this.robot.dock(this.station);
            this.station = null;
            this.terminate();
        }
    }

    @Override
    public void end() {
        if (this.station != null) {
            this.station.release(this.robot);
        }
    }
}

