/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.robots.AIRobotGotoBlock;
import buildcraft.core.robots.AIRobotSearchRandomGroundBlock;
import buildcraft.core.robots.IBlockFilter;
import buildcraft.core.utils.PathFinding;
import buildcraft.core.utils.PathFindingJob;
import java.util.LinkedList;
import net.minecraft.entity.Entity;

public class AIRobotGotoRandomGroundBlock
extends AIRobot {
    public BlockIndex blockFound;
    private int range;
    private PathFinding pathFinding;
    private PathFindingJob pathFindingJob;
    private IBlockFilter filter;
    private IZone zone;

    public AIRobotGotoRandomGroundBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGotoRandomGroundBlock(EntityRobotBase iRobot, int iRange, IBlockFilter iFilter, IZone iZone) {
        super(iRobot);
        this.range = iRange;
        this.filter = iFilter;
        this.zone = iZone;
    }

    @Override
    public void update() {
        if (this.pathFindingJob == null) {
            this.startDelegateAI(new AIRobotSearchRandomGroundBlock(this.robot, this.range, this.filter, this.zone));
        } else if (!this.pathFindingJob.isAlive()) {
            LinkedList<BlockIndex> path = this.pathFinding.getResult();
            if (path.size() == 0) {
                this.terminate();
            } else {
                path.removeLast();
                this.startDelegateAI(new AIRobotGotoBlock(this.robot, path));
            }
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchRandomGroundBlock) {
            AIRobotSearchRandomGroundBlock aiFind = (AIRobotSearchRandomGroundBlock)ai;
            if (aiFind.blockFound == null) {
                this.terminate();
            }
            this.blockFound = aiFind.blockFound;
            this.pathFinding = new PathFinding(this.robot.field_70170_p, new BlockIndex((Entity)this.robot), this.blockFound);
            this.pathFindingJob = new PathFindingJob(this.pathFinding);
            this.pathFindingJob.start();
        } else if (ai instanceof AIRobotGotoBlock) {
            this.terminate();
        }
    }

    @Override
    public void end() {
        if (this.pathFindingJob != null) {
            this.pathFindingJob.terminate();
        }
    }
}

