/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.IStackFilter;
import buildcraft.core.robots.AIRobotSearchAndGotoStation;
import buildcraft.core.robots.DockingStation;
import buildcraft.core.robots.IStationFilter;
import buildcraft.silicon.statements.ActionRobotFilter;
import buildcraft.silicon.statements.ActionStationProvideItems;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotGotoStationToLoad
extends AIRobot {
    private boolean found = false;
    private IStackFilter filter;
    private IZone zone;

    public AIRobotGotoStationToLoad(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGotoStationToLoad(EntityRobotBase iRobot, IStackFilter iFilter, IZone iZone) {
        super(iRobot);
        this.filter = iFilter;
        this.zone = iZone;
    }

    @Override
    public void update() {
        this.startDelegateAI(new AIRobotSearchAndGotoStation(this.robot, new StationFilter(), this.zone));
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchAndGotoStation) {
            this.found = ((AIRobotSearchAndGotoStation)ai).targetStation != null;
            this.terminate();
        }
    }

    @Override
    public boolean success() {
        return this.found;
    }

    private class StationFilter
    implements IStationFilter {
        private StationFilter() {
        }

        @Override
        public boolean matches(DockingStation station) {
            if (!ActionRobotFilter.canInteractWithItem(station, AIRobotGotoStationToLoad.this.filter, ActionStationProvideItems.class)) {
                return false;
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                ITransactor trans;
                TileEntity nearbyTile = AIRobotGotoStationToLoad.this.robot.field_70170_p.func_147438_o(station.x() + dir.offsetX, station.y() + dir.offsetY, station.z() + dir.offsetZ);
                if (nearbyTile == null || !(nearbyTile instanceof IInventory) || (trans = Transactor.getTransactorFor(nearbyTile)).remove(AIRobotGotoStationToLoad.this.filter, dir.getOpposite(), false) == null) continue;
                return true;
            }
            return false;
        }
    }
}

