/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.inventory.filters.IFluidFilter;
import buildcraft.core.robots.AIRobotSearchAndGotoStation;
import buildcraft.core.robots.DockingStation;
import buildcraft.core.robots.IStationFilter;
import buildcraft.silicon.statements.ActionRobotFilter;
import buildcraft.silicon.statements.ActionStationProvideFluids;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class AIRobotGotoStationToLoadFluids
extends AIRobot {
    private boolean found = false;
    private IZone zone;
    private IFluidFilter filter;

    public AIRobotGotoStationToLoadFluids(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGotoStationToLoadFluids(EntityRobotBase iRobot, IFluidFilter iFiler, IZone iZone) {
        super(iRobot);
        this.zone = iZone;
        this.filter = iFiler;
    }

    @Override
    public void update() {
        this.startDelegateAI(new AIRobotSearchAndGotoStation(this.robot, new StationFilter(), this.zone));
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchAndGotoStation) {
            this.found = ai.success();
            this.terminate();
        }
    }

    @Override
    public boolean success() {
        return this.found;
    }

    private class StationFilter
    implements IStationFilter {
        private StationFilter() {
        }

        @Override
        public boolean matches(DockingStation station) {
            if (!ActionRobotFilter.canInteractWithFluid(station, AIRobotGotoStationToLoadFluids.this.filter, ActionStationProvideFluids.class)) {
                return false;
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                IFluidHandler handler;
                FluidStack drainable;
                TileEntity nearbyTile = AIRobotGotoStationToLoadFluids.this.robot.field_70170_p.func_147438_o(station.x() + dir.offsetX, station.y() + dir.offsetY, station.z() + dir.offsetZ);
                if (nearbyTile == null || !(nearbyTile instanceof IFluidHandler) || (drainable = (handler = (IFluidHandler)nearbyTile).drain(station.side, 1, false)) == null || !AIRobotGotoStationToLoadFluids.this.filter.matches(drainable.getFluid()) || !AIRobotGotoStationToLoadFluids.this.robot.canFill(ForgeDirection.UNKNOWN, drainable.getFluid())) continue;
                return true;
            }
            return false;
        }
    }
}

